/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser.config;

import com.immomo.core.parser.config.ViewLogogramBase;
import com.immomo.core.parser.config.ViewLogogramColor;
import com.immomo.core.parser.config.ViewLogogramGradient;
import com.immomo.core.parser.config.ViewLogogramInterface;
import com.immomo.core.parser.config.ViewLogogramParams;
import com.immomo.core.parser.token.LLuaToken;
import java.util.ArrayList;
import java.util.List;

public class ViewLogogramConfig {
    public static ViewLogogramConfig INSTANCE = new ViewLogogramConfig();
    private ViewLogogramBase viewLogogramBase = new ViewLogogramBase();
    private List<ViewLogogramInterface> logograms = new ArrayList<ViewLogogramInterface>();

    private ViewLogogramConfig() {
        this.addLogogram(this.viewLogogramBase);
        this.addLogogram(new ViewLogogramColor());
        this.addLogogram(new ViewLogogramGradient());
        this.addLogogram(new ViewLogogramParams());
    }

    public void addLogogram(ViewLogogramInterface logogram) {
        this.logograms.add(logogram);
    }

    public StringBuilder logogramToSrc(String attribute, List<LLuaToken> params) {
        for (ViewLogogramInterface imp : this.logograms) {
            StringBuilder builder = imp.logogramToSrc(attribute, params);
            if (builder == null) continue;
            return builder;
        }
        return null;
    }

    public boolean canTransformLogogramToken(LLuaToken token) {
        return this.viewLogogramBase._baseLogograms.containsKey(token.value);
    }

    public void transformLogogramToken(LLuaToken token) {
        if (this.viewLogogramBase._baseLogograms.containsKey(token.value)) {
            token.value = this.viewLogogramBase._baseLogograms.get(token.value);
        }
    }
}

