/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser;

import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.resolver.base.ModuleResult;
import com.immomo.core.parser.resolver.base.Resolver;
import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.resolver.base.ResolverResult;
import com.immomo.core.parser.resolver.other.SourceResolver;
import com.immomo.core.parser.resolver.preview.PreviewResolver;
import com.immomo.core.parser.resolver.require.RequireResolver;
import com.immomo.core.parser.resolver.statement.ModelResolver;
import com.immomo.core.parser.resolver.ui.UIModuleResolver;
import com.immomo.core.parser.resolver.ui.UIResolver;
import com.immomo.core.parser.resolver.variable.GlobalResolver;
import com.immomo.core.parser.resolver.variable.LocalResolver;
import com.immomo.core.parser.token.LLuaToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LLuaTokenAdapter {
    private Map<ResolverName, Resolver> resolvers = new LinkedHashMap<ResolverName, Resolver>();
    private Map<ResolverName, ModuleResult> resolverResultMap = new LinkedHashMap<ResolverName, ModuleResult>();
    private List<ResolverResult> parsedResults = new ArrayList<ResolverResult>();

    public LLuaTokenAdapter() {
        this.registerResolvers();
    }

    private void registerResolvers() {
        this.addResolver(new ModelResolver());
        this.addResolver(new UIModuleResolver());
        this.addResolver(new UIResolver());
        this.addResolver(new LocalResolver());
        this.addResolver(new GlobalResolver());
        this.addResolver(new RequireResolver());
        this.addResolver(new PreviewResolver());
        this.addResolver(new SourceResolver());
    }

    public void addResolver(Resolver resolver) {
        this.resolvers.put(resolver.resolveName(), resolver);
        if (!this.resolverResultMap.containsKey((Object)resolver.resolveName())) {
            this.resolverResultMap.put(resolver.resolveName(), new ModuleResult(resolver.resolveName()));
        }
    }

    public Resolver getResolver(ResolverName resolverName) {
        return this.resolvers.get((Object)resolverName);
    }

    public void dispense(LLuaToken header) {
        for (Resolver resolver : this.resolvers.values()) {
            ModuleResult moduleResult1;
            if (!resolver.canResolve(header)) continue;
            ResolverResult result = resolver.resolve(header);
            if (result == null) break;
            result.resolverName = resolver.resolveName();
            ModuleResult moduleResult = this.resolverResultMap.get((Object)resolver.resolveName());
            if (moduleResult != null) {
                moduleResult.addResolerResult(result);
            }
            this.parsedResults.add(result);
            LLuaTokenAdapter dispose = LLuaParserStack.disposeToAdapter(result);
            if (dispose == null || (moduleResult1 = dispose.resolverResultMap.get((Object)resolver.resolveName())) == null) break;
            moduleResult1.addResolerResult(result);
            break;
        }
    }

    public boolean containModule(ResolverName resolverName, String moduleName) {
        if (resolverName == null || moduleName == null) {
            return false;
        }
        ModuleResult moduleResult = this.resolverResultMap.get((Object)resolverName);
        if (moduleResult == null) {
            return false;
        }
        if (moduleResult.contain(moduleName)) {
            return true;
        }
        for (String value : moduleResult.getResolverResultNames()) {
            if (!moduleName.startsWith(value + ".") && !value.startsWith(moduleName + ".")) continue;
            return true;
        }
        return false;
    }

    public ResolverResult getModule(ResolverName resolverName, String moduleName) {
        if (resolverName == null || moduleName == null) {
            return null;
        }
        if (this.resolverResultMap.containsKey((Object)resolverName)) {
            ModuleResult moduleResult = this.resolverResultMap.get((Object)resolverName);
            ResolverResult result = moduleResult.getResolverResult(moduleName);
            if (result != null) {
                return result;
            }
            for (ResolverResult value : moduleResult.getResolverResults()) {
                if (!value.name.startsWith(moduleName + ".") && !moduleName.startsWith(value.name + ".")) continue;
                return value;
            }
            return null;
        }
        return null;
    }

    public boolean containModule(String moduleName) {
        if (moduleName == null) {
            return false;
        }
        for (ResolverName resolverName : this.resolverResultMap.keySet()) {
            if (!this.containModule(resolverName, moduleName)) continue;
            return true;
        }
        return false;
    }

    public ResolverResult getModule(String moduleName) {
        if (moduleName == null) {
            return null;
        }
        for (ResolverName resolverName : this.resolverResultMap.keySet()) {
            ResolverResult resolverResult = this.getModule(resolverName, moduleName);
            if (resolverResult == null) continue;
            return resolverResult;
        }
        return null;
    }

    public ModuleResult getModules(ResolverName resolverName) {
        return this.resolverResultMap.get((Object)resolverName);
    }

    public List<ResolverResult> getParsedResults() {
        return this.parsedResults;
    }

    public void clear() {
        this.parsedResults.clear();
        for (ModuleResult result : this.resolverResultMap.values()) {
            result.clear();
        }
        for (Resolver resolver : this.resolvers.values()) {
            resolver.clear();
        }
    }
}

