/*
 * Decompiled with CFR 0.152.
 */
package com.immomo.core.parser;

import com.immomo.core.parser.LLuaParserStack;
import com.immomo.core.parser.LLuaTokenAdapter;
import com.immomo.core.parser.config.Constants;
import com.immomo.core.parser.params.TokenParamsParser;
import com.immomo.core.parser.resolver.base.ModuleResult;
import com.immomo.core.parser.resolver.base.ResolverName;
import com.immomo.core.parser.resolver.base.ResolverResult;
import com.immomo.core.parser.token.LLuaToken;
import com.immomo.core.parser.token.LLuaTokenGenerate;
import com.immomo.core.parser.util.TokenUtil;
import com.immomo.core.parser.util.preview.PreViewUtil;
import com.immomo.core.parser.view.generate.ViewNameUtil;
import com.immomo.ui.values.LLuaVirtualFileUtil;
import com.luaj.vm2.Globals;
import com.luaj.vm2.compiler.LuaC;
import com.luaj.vm2.lib.jse.JsePlatform;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class LLuaParser {
    private static String _requireBasePath = null;
    private String _requireName = null;
    private boolean _isui = false;
    private StringBuilder _previewSrc = null;
    private boolean parsedRet = false;
    private LLuaTokenAdapter tokenAdapter = null;
    private List<LLuaToken> _blocks = new ArrayList<LLuaToken>();
    private StringBuilder retSrc;

    public static void setRequireBasePath(String path) {
        _requireBasePath = path;
        if (_requireBasePath.endsWith("/")) {
            _requireBasePath = _requireBasePath.substring(0, _requireBasePath.length() - 1);
        }
    }

    public LLuaParser() {
    }

    public LLuaParser(String requireName) throws Exception {
        if (requireName.startsWith("/")) {
            requireName = requireName.substring(1);
        }
        this._requireName = requireName = requireName.replace('.', '/');
        String text = LLuaVirtualFileUtil.getFileDocumentText(_requireBasePath, requireName + ".llua");
        if (text != null) {
            this.parseSrc(text);
        } else {
            this.parseFileName(_requireBasePath + "/" + requireName + ".llua");
        }
    }

    public boolean parseFileName(String name) throws Exception {
        Globals globals = JsePlatform.standardGlobals();
        InputStream inputStream = globals.finder.findResource(name);
        return this.parser(inputStream);
    }

    public boolean parseSrc(String src) throws Exception {
        InputStream inputStream = Globals.getInputStream(src);
        return this.parser(inputStream);
    }

    public String parsedSource() {
        if (this.parsedRet && this.retSrc != null) {
            return this.retSrc.toString();
        }
        return "";
    }

    public void clear() {
        this.retSrc = null;
        this._previewSrc = null;
    }

    public String getRequireName() {
        return this._requireName;
    }

    public boolean isUI() {
        return this._isui;
    }

    public boolean hasSource() {
        return this.parsedRet && this.retSrc.length() > 5;
    }

    public StringBuilder getPreviewSource() {
        return this._previewSrc;
    }

    protected LLuaTokenAdapter getTokenAdapter() {
        return this.tokenAdapter;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._blocks != null) {
            for (LLuaToken token : this._blocks) {
                token.dealloc();
            }
        }
    }

    private boolean parser(InputStream inputStream) throws Exception {
        this.parsedRet = false;
        LLuaParserStack.push(this);
        try {
            LuaC.instance.compile(inputStream, "llua");
            this._blocks.addAll(LLuaTokenGenerate.INSTANCE.blocks);
            LLuaTokenGenerate.INSTANCE.blocks.clear();
            LLuaTokenGenerate.INSTANCE.clear();
            for (LLuaToken token : this._blocks) {
                new TokenParamsParser(token);
            }
            this.tokenAdapter = new LLuaTokenAdapter();
            for (LLuaToken token : this._blocks) {
                this.tokenAdapter.dispense(token);
            }
            this.combineResolverResult();
            this.parsedRet = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            LLuaTokenGenerate.INSTANCE.clear();
            this.tokenAdapter.clear();
            LLuaParserStack.pop();
        }
        return this.parsedRet;
    }

    private void combineResolverResult() {
        this.retSrc = new StringBuilder();
        ModuleResult previewModuleResult = this.tokenAdapter.getModules(ResolverName.PREVIEW);
        if (previewModuleResult != null && previewModuleResult.contain(Constants.PREVIEW)) {
            ResolverResult preview = previewModuleResult.getResolverResult(Constants.PREVIEW);
            this._previewSrc = PreViewUtil.previewSource(preview);
        }
        for (ResolverResult resolverResult : this.tokenAdapter.getParsedResults()) {
            switch (resolverResult.resolverName) {
                case VAR_LOCAL: 
                case VAR_GLOBAL: 
                case REQUIRE: 
                case SOURCE: {
                    this.retSrc.append(resolverResult.moduleSrc != null ? resolverResult.moduleSrc : "");
                    TokenUtil.appendNewLine(this.retSrc);
                }
            }
        }
        ResolverResult uiResult = this.tokenAdapter.getModule(ResolverName.UI, Constants.UI);
        if (uiResult != null) {
            ViewNameUtil.push();
            this.retSrc.append((CharSequence)uiResult.view.desSourceCode());
            TokenUtil.appendNewLine(this.retSrc);
            this.retSrc.append(Constants.VIEWIDS).append(" = {}\n");
            for (String id : ViewNameUtil.get()) {
                this.retSrc.append(Constants.VIEWIDS).append('.').append(id).append(" = ").append(id).append('\n');
            }
            ViewNameUtil.pop();
        }
        if (uiResult != null && uiResult.view != null && uiResult.view.subViews.size() > 0) {
            this._isui = true;
            TokenUtil.appendNewLine(this.retSrc);
            this.retSrc.append("return {}, true");
        }
    }
}

