/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.util;

public class ByteReader {
    public static final int UINT8_MAX_VAL = 255;
    public static final int UINT8_MIN_VAL = 0;
    public static final int INT8_MAX_VAL = 127;
    public static final int INT8_MIN_VAL = -128;
    public static final int UINT16_MAX_VAL = 65535;
    public static final int UINT16_MIN_VAL = 0;
    public static final int INT16_MAX_VAL = Short.MAX_VALUE;
    public static final int INT16_MIN_VAL = Short.MIN_VALUE;
    public static final long UINT32_MAX_VAL = 0xFFFFFFFFL;
    public static final long UINT32_MIN_VAL = 0L;
    public static final long INT32_MAX_VAL = Integer.MAX_VALUE;
    public static final long INT32_MIN_VAL = Integer.MIN_VALUE;

    public static byte getInt8(byte[] buffer, int offset) {
        short value = buffer[offset];
        assert (value >= -128 && value <= 127);
        return (byte)value;
    }

    public static short getUInt8(byte[] buffer, int offset) {
        short value = (short)(buffer[offset] & 0x7F);
        if (buffer[offset] < 0) {
            value = (short)(value | 0x80);
        }
        assert (value >= 0 && value <= 255);
        return value;
    }

    public static short getInt16(byte[] buffer, int offset) {
        int word = (buffer[offset + 1] & 0x7F) << 8 | buffer[offset] & 0x7F;
        if (buffer[offset] < 0) {
            word |= 0x80;
        }
        if (buffer[offset + 1] < 0) {
            word = Short.MIN_VALUE + word;
        }
        assert (word >= Short.MIN_VALUE && word <= Short.MAX_VALUE);
        return (short)word;
    }

    public static int getUInt16(byte[] buffer, int offset) {
        int word = (buffer[offset + 1] & 0x7F) << 8 | buffer[offset] & 0x7F;
        if (buffer[offset + 1] < 0) {
            word |= 0x8000;
        }
        if (buffer[offset] < 0) {
            word |= 0x80;
        }
        assert (word >= 0 && word <= 65535);
        return word;
    }

    public static int getInt32(byte[] buffer, int offset) {
        long doubleWord = (buffer[offset + 3] & 0x7F) << 24 | (buffer[offset + 2] & 0x7F) << 16 | (buffer[offset + 1] & 0x7F) << 8 | buffer[offset] & 0x7F;
        if (buffer[offset + 2] < 0) {
            doubleWord |= 0x800000L;
        }
        if (buffer[offset + 1] < 0) {
            doubleWord |= 0x8000L;
        }
        if (buffer[offset] < 0) {
            doubleWord |= 0x80L;
        }
        if (buffer[offset + 3] < 0) {
            doubleWord = Integer.MIN_VALUE + doubleWord;
        }
        assert (doubleWord >= Integer.MIN_VALUE && doubleWord <= Integer.MAX_VALUE);
        return (int)doubleWord;
    }

    public static long getUInt32(byte[] buffer, int offset) {
        long doubleWord = (buffer[offset + 3] & 0x7F) << 24 | (buffer[offset + 2] & 0x7F) << 16 | (buffer[offset + 1] & 0x7F) << 8 | buffer[offset] & 0x7F;
        if (buffer[offset + 3] < 0) {
            doubleWord |= 0x80000000L;
        }
        if (buffer[offset + 2] < 0) {
            doubleWord |= 0x800000L;
        }
        if (buffer[offset + 1] < 0) {
            doubleWord |= 0x8000L;
        }
        if (buffer[offset] < 0) {
            doubleWord |= 0x80L;
        }
        assert (doubleWord >= 0L && doubleWord <= 0xFFFFFFFFL);
        return doubleWord;
    }

    public static long getInt64(byte[] buffer, int offset) {
        long qWord = (long)(buffer[offset + 7] & 0x7F) << 56 | (long)(buffer[offset + 6] & 0x7F) << 48 | (long)(buffer[offset + 5] & 0x7F) << 40 | (long)(buffer[offset + 4] & 0x7F) << 32 | (long)((buffer[offset + 3] & 0x7F) << 24) | (long)((buffer[offset + 2] & 0x7F) << 16) | (long)((buffer[offset + 1] & 0x7F) << 8) | (long)(buffer[offset] & 0x7F);
        if (buffer[offset + 7] < 0) {
            qWord |= Long.MIN_VALUE;
        }
        if (buffer[offset + 6] < 0) {
            qWord |= 0x80000000000000L;
        }
        if (buffer[offset + 5] < 0) {
            qWord |= 0x800000000000L;
        }
        if (buffer[offset + 4] < 0) {
            qWord |= 0x8000000000L;
        }
        if (buffer[offset + 3] < 0) {
            qWord |= 0x80000000L;
        }
        if (buffer[offset + 2] < 0) {
            qWord |= 0x800000L;
        }
        if (buffer[offset + 1] < 0) {
            qWord |= 0x8000L;
        }
        if (buffer[offset] < 0) {
            qWord |= 0x80L;
        }
        return qWord;
    }

    public static long getUInt64(byte[] buffer, int offset) {
        long qWord = (long)(buffer[offset + 7] & 0x7F) << 56 | (long)(buffer[offset + 6] & 0x7F) << 48 | (long)(buffer[offset + 5] & 0x7F) << 40 | (long)(buffer[offset + 4] & 0x7F) << 32 | (long)((buffer[offset + 3] & 0x7F) << 24) | (long)((buffer[offset + 2] & 0x7F) << 16) | (long)((buffer[offset + 1] & 0x7F) << 8) | (long)(buffer[offset] & 0x7F);
        if (buffer[offset + 6] < 0) {
            qWord |= 0x80000000000000L;
        }
        if (buffer[offset + 5] < 0) {
            qWord |= 0x800000000000L;
        }
        if (buffer[offset + 4] < 0) {
            qWord |= 0x8000000000L;
        }
        if (buffer[offset + 3] < 0) {
            qWord |= 0x80000000L;
        }
        if (buffer[offset + 2] < 0) {
            qWord |= 0x800000L;
        }
        if (buffer[offset + 1] < 0) {
            qWord |= 0x8000L;
        }
        if (buffer[offset] < 0) {
            qWord |= 0x80L;
        }
        if (buffer[offset + 7] < 0) {
            qWord = Long.MIN_VALUE + qWord;
        }
        return qWord;
    }

    public static byte[] getBytes(byte[] data, int offset, int length) {
        byte[] buffer = new byte[length];
        System.arraycopy(data, offset, buffer, 0, length);
        return buffer;
    }

    public static int alingToNextDWord(int offset) {
        return offset + (4 - offset % 4);
    }

    public static int alignToDWord(int offset) {
        int correction = 4 - offset % 4;
        return offset + (correction != 4 ? correction : 0);
    }

    public static int alignToNextWord(int offset) {
        return offset + (2 - offset % 2);
    }

    public static int alignToWord(int offset) {
        int correction = 2 - offset % 2;
        return offset + (correction != 2 ? correction : 0);
    }

    public static byte[] getUTF16PreparedBytes(byte[] data, int offset, int length) {
        if (data == null) {
            return null;
        }
        byte[] buffer = ByteReader.getBytes(data, offset, length);
        if (buffer == null) {
            return null;
        }
        if ((buffer.length & 1) != 0) {
            byte[] extendedBuffer = new byte[buffer.length + 1];
            for (int i = 0; i < buffer.length - 1; i += 2) {
                extendedBuffer[i] = buffer[i + 1];
                extendedBuffer[i + 1] = buffer[i];
            }
            extendedBuffer[buffer.length - 1] = 0;
            extendedBuffer[buffer.length] = buffer[buffer.length - 1];
            return extendedBuffer;
        }
        for (int i = 0; i < buffer.length; i += 2) {
            byte swapElement = buffer[i];
            buffer[i] = buffer[i + 1];
            buffer[i + 1] = swapElement;
        }
        return buffer;
    }

    public static int getSizeOfHeapLength(int heapObjectSize) {
        assert (heapObjectSize >= 0);
        if (heapObjectSize > 16383) {
            return 4;
        }
        if (heapObjectSize > 127) {
            return 2;
        }
        return 1;
    }

    public static int readHeapObjectSize(byte[] data, int offset) {
        short prefix = ByteReader.getUInt8(data, offset);
        if ((prefix & 0x80) == 0) {
            return prefix;
        }
        if ((prefix & 0xC0) == 128) {
            return ((prefix & 0x3F) << 8) + ByteReader.getUInt8(data, offset + 1);
        }
        assert ((prefix & 0xC0) == 192);
        return ((prefix & 0x1F) << 24) + (ByteReader.getUInt8(data, offset + 1) << 16) + (ByteReader.getUInt8(data, offset + 2) << 8) + ByteReader.getUInt8(data, offset + 3);
    }

    public static int getSizeOfSignatureElement(int signatureObjectSize) {
        if (signatureObjectSize > 16383) {
            return 4;
        }
        if (signatureObjectSize > 127) {
            return 2;
        }
        return 1;
    }

    public static int decodeSignatureElement(byte[] data, int offset) {
        short prefix = ByteReader.getUInt8(data, offset);
        if ((prefix & 0x80) == 0) {
            return prefix;
        }
        if ((prefix & 0xFF) == 255) {
            return -1;
        }
        if ((prefix & 0xC0) == 128) {
            return ((prefix & 0x3F) << 8) + ByteReader.getUInt8(data, offset + 1);
        }
        assert ((prefix & 0xE0) == 192);
        return ((prefix & 0x1F) << 24) + (ByteReader.getUInt8(data, offset + 1) << 16) + (ByteReader.getUInt8(data, offset + 2) << 8) + ByteReader.getUInt8(data, offset + 3);
    }

    public static float getFloat(byte[] data, int offset) {
        return Float.intBitsToFloat(ByteReader.getInt32(data, offset));
    }

    public static double getDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(ByteReader.getInt64(data, offset));
    }

    public static boolean testFlags(long flags, long mask, long testBits) {
        return (mask & flags) == testBits;
    }

    public static boolean testFlags(int flags, int mask, int testBits) {
        return (mask & flags) == testBits;
    }

    public static boolean testFlags(byte flags, byte mask, byte testBits) {
        return (mask & flags) == testBits;
    }

    public static boolean testFlags(long flags, long testBits) {
        return (flags & testBits) == testBits;
    }

    public static boolean testFlags(int flags, int testBits) {
        return (flags & testBits) == testBits;
    }

    public static boolean testFlags(byte flags, byte testBits) {
        return (flags & testBits) == testBits;
    }

    public static boolean testAny(long flags, long testBits) {
        return (flags & testBits) != 0L;
    }

    public static boolean testAny(int flags, int testBits) {
        return (flags & testBits) != 0;
    }

    public static boolean testAny(byte flags, byte testBits) {
        return (flags & testBits) != 0;
    }

    public static long setFlags(long flags, long flagsToSet, boolean set) {
        flags = set ? (flags |= flagsToSet) : (flags &= flagsToSet ^ 0xFFFFFFFFFFFFFFFFL);
        return flags;
    }

    public static int setFlags(int flags, int flagsToSet, boolean set) {
        flags = set ? (flags |= flagsToSet) : (flags &= ~flagsToSet);
        return flags;
    }

    public static byte setFlags(byte flags, byte flagsToSet, boolean set) {
        flags = set ? (byte)(flags | flagsToSet) : (byte)(flags & ~flagsToSet);
        return flags;
    }
}

