/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.util;

public class ArrayUtils {
    public static boolean contains(int[] array, int element) {
        for (int value : array) {
            if (value != element) continue;
            return true;
        }
        return false;
    }

    public static String formatByteArray(byte[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer(array.length * 3);
        buffer.append(String.format("%02x", array[0]));
        for (int i = 1; i < array.length; ++i) {
            buffer.append(String.format(" %02x", array[i]));
        }
        return buffer.toString();
    }

    public static boolean arraysAreEqual(byte[] a1, byte[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysAreEqualN(byte[] a1, byte[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsAreEqualN(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static int compareStrings(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        if (s2 == null) {
            return Integer.MIN_VALUE;
        }
        return s2.compareTo(s1);
    }

    public static int findDifference(byte[] a1, byte[] a2) {
        int limit = a1.length;
        if (limit > a2.length) {
            limit = a2.length;
        }
        for (int i = 0; i < limit; ++i) {
            if (a1[i] == a2[i]) continue;
            return i;
        }
        return a1.length == a2.length ? 0 : limit;
    }

    public static String formatAsHexTable(long codeRVA, byte[] byteBuffer, int length, boolean addHeader) {
        int i;
        if (byteBuffer == null) {
            return null;
        }
        if (length > byteBuffer.length) {
            length = byteBuffer.length;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (addHeader) {
            stringBuffer.append("Address: ");
            stringBuffer.append(String.format("-%1x--%1x--%1x--%1x--%1x--%1x--%1x--%1x--", codeRVA % 16L, (codeRVA + 1L) % 16L, (codeRVA + 2L) % 16L, (codeRVA + 3L) % 16L, (codeRVA + 4L) % 16L, (codeRVA + 5L) % 16L, (codeRVA + 6L) % 16L, (codeRVA + 7L) % 16L));
            stringBuffer.append(String.format("%1x--%1x--%1x--%1x--%1x--%1x--%1x--%1x\n", (codeRVA + 8L) % 16L, (codeRVA + 9L) % 16L, (codeRVA + 10L) % 16L, (codeRVA + 11L) % 16L, (codeRVA + 12L) % 16L, (codeRVA + 13L) % 16L, (codeRVA + 14L) % 16L, (codeRVA + 15L) % 16L));
            stringBuffer.append(String.format("%08X ", codeRVA));
        }
        for (i = 0; i < length; ++i) {
            stringBuffer.append(String.format("%02x ", byteBuffer[i]));
            if ((i & 0xF) != 15) continue;
            byte[] buffer = new byte[16];
            System.arraycopy(byteBuffer, i - 15, buffer, 0, 16);
            codeRVA += 16L;
            if (addHeader) {
                stringBuffer.append(String.format(" %s\n%08X ", new String(buffer).replaceAll("\\p{Cntrl}", "."), codeRVA));
                continue;
            }
            stringBuffer.append(String.format(" %s\n ", new String(buffer).replaceAll("\\p{Cntrl}", ".")));
        }
        --i;
        for (int space = 15; space > (i & 0xF); --space) {
            stringBuffer.append("   ");
        }
        if ((i & 0xF) != 15) {
            byte[] buffer = new byte[(i & 0xF) + 1];
            System.arraycopy(byteBuffer, length - (i & 0xF) - 1, buffer, 0, (i & 0xF) + 1);
            stringBuffer.append(" ").append(new String(buffer).replaceAll("\\p{Cntrl}", "."));
        }
        return stringBuffer.toString();
    }

    public static String formatAsHexTable(byte[] byteBuffer, boolean addHeader) {
        return ArrayUtils.formatAsHexTable(0L, byteBuffer, byteBuffer == null ? 0 : byteBuffer.length, addHeader);
    }

    public static String formatAsHexTable(byte[] byteBuffer, int length, boolean addHeader) {
        return ArrayUtils.formatAsHexTable(0L, byteBuffer, length, addHeader);
    }

    public static String formatAsHexTable(long codeRVA, byte[] byteBuffer, boolean addHeader) {
        return ArrayUtils.formatAsHexTable(codeRVA, byteBuffer, byteBuffer == null ? 0 : byteBuffer.length, addHeader);
    }

    public static int findInByteArray(byte[] data, int offset, byte sign) {
        int index = offset;
        while (data[index] != sign) {
            if (++index < data.length) continue;
            return -1;
        }
        return index - offset;
    }
}

