/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.utils;

import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import junit.framework.TestCase;

public class IndexDecoderTests
extends TestCase {
    public void testGetBitSize() {
        IndexDecoderTests.assertEquals((int)3, (int)IndexDecoder.getBitSize(CodedIndex.CustomAttributeType));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.getBitSize(CodedIndex.HasConstant));
        IndexDecoderTests.assertEquals((int)5, (int)IndexDecoder.getBitSize(CodedIndex.HasCustomAttribute));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.getBitSize(CodedIndex.HasDeclSecurity));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.getBitSize(CodedIndex.HasFieldMarshall));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.getBitSize(CodedIndex.HasSemantics));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.getBitSize(CodedIndex.Implementation));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.getBitSize(CodedIndex.MemberForwarded));
        IndexDecoderTests.assertEquals((int)3, (int)IndexDecoder.getBitSize(CodedIndex.MemberRefParent));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.getBitSize(CodedIndex.MethodDefOrRef));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.getBitSize(CodedIndex.ResolutionScope));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.getBitSize(CodedIndex.TypeDefOrRef));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.getBitSize(CodedIndex.TypeOrMethodDef));
    }

    public void testGetTableIndices() {
        double inverseLog2 = 1.0 / Math.log10(2.0);
        IndexDecoderTests.assertEquals((int)3, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.CustomAttributeType).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)2, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.HasConstant).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)5, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.HasCustomAttribute).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)2, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.HasDeclSecurity).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)1, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.HasFieldMarshall).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)1, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.HasSemantics).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)2, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.Implementation).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)1, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.MemberForwarded).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)3, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.MemberRefParent).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)1, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.MethodDefOrRef).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)2, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.ResolutionScope).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)2, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.TypeDefOrRef).length) * inverseLog2)));
        IndexDecoderTests.assertEquals((int)1, (int)((int)Math.ceil(Math.log10(IndexDecoder.getTableIndices(CodedIndex.TypeOrMethodDef).length) * inverseLog2)));
    }

    public void testGetByteSizeOfTargetRowInt() {
        int[] numberOfRows = new int[]{0, 2, 4, 100, 65535, 65536, 2342343};
        IndexDecoderTests.assertEquals((int)IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 0), (int)2);
        IndexDecoderTests.assertEquals((int)IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 1), (int)2);
        IndexDecoderTests.assertEquals((int)IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 2), (int)2);
        IndexDecoderTests.assertEquals((int)IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 3), (int)2);
        IndexDecoderTests.assertEquals((int)IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 4), (int)2);
        IndexDecoderTests.assertEquals((int)IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 5), (int)4);
        IndexDecoderTests.assertEquals((int)IndexDecoder.getByteSizeOfTargetRow(numberOfRows, 6), (int)4);
    }

    public void testDecodeIndexContent() {
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.CustomAttributeType, 170L) + 1), (int)21);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.HasConstant, 170L) + 1), (int)42);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.HasCustomAttribute, 170L) + 1), (int)5);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.HasDeclSecurity, 170L) + 1), (int)42);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.HasFieldMarshall, 170L) + 1), (int)85);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.HasSemantics, 170L) + 1), (int)85);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.Implementation, 170L) + 1), (int)42);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.MemberForwarded, 170L) + 1), (int)85);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.MemberRefParent, 170L) + 1), (int)21);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.MethodDefOrRef, 170L) + 1), (int)85);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.ResolutionScope, 170L) + 1), (int)42);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.TypeDefOrRef, 170L) + 1), (int)42);
        IndexDecoderTests.assertEquals((int)(IndexDecoder.decodeIndexContent(CodedIndex.TypeOrMethodDef, 170L) + 1), (int)85);
        for (int i = 0; i < 256; ++i) {
            int shift1 = i >> 1;
            int shift2 = i >> 2;
            int shift3 = i >> 3;
            int shift5 = i >> 5;
            IndexDecoderTests.assertEquals((int)shift3, (int)(IndexDecoder.decodeIndexContent(CodedIndex.CustomAttributeType, i) + 1));
            IndexDecoderTests.assertEquals((int)shift2, (int)(IndexDecoder.decodeIndexContent(CodedIndex.HasConstant, i) + 1));
            IndexDecoderTests.assertEquals((int)shift5, (int)(IndexDecoder.decodeIndexContent(CodedIndex.HasCustomAttribute, i) + 1));
            IndexDecoderTests.assertEquals((int)shift2, (int)(IndexDecoder.decodeIndexContent(CodedIndex.HasDeclSecurity, i) + 1));
            IndexDecoderTests.assertEquals((int)shift1, (int)(IndexDecoder.decodeIndexContent(CodedIndex.HasFieldMarshall, i) + 1));
            IndexDecoderTests.assertEquals((int)shift1, (int)(IndexDecoder.decodeIndexContent(CodedIndex.HasSemantics, i) + 1));
            IndexDecoderTests.assertEquals((int)shift2, (int)(IndexDecoder.decodeIndexContent(CodedIndex.Implementation, i) + 1));
            IndexDecoderTests.assertEquals((int)shift1, (int)(IndexDecoder.decodeIndexContent(CodedIndex.MemberForwarded, i) + 1));
            IndexDecoderTests.assertEquals((int)shift3, (int)(IndexDecoder.decodeIndexContent(CodedIndex.MemberRefParent, i) + 1));
            IndexDecoderTests.assertEquals((int)shift1, (int)(IndexDecoder.decodeIndexContent(CodedIndex.MethodDefOrRef, i) + 1));
            IndexDecoderTests.assertEquals((int)shift2, (int)(IndexDecoder.decodeIndexContent(CodedIndex.ResolutionScope, i) + 1));
            IndexDecoderTests.assertEquals((int)shift2, (int)(IndexDecoder.decodeIndexContent(CodedIndex.TypeDefOrRef, i) + 1));
            IndexDecoderTests.assertEquals((int)shift1, (int)(IndexDecoder.decodeIndexContent(CodedIndex.TypeOrMethodDef, i) + 1));
        }
        for (long i = 256L; i <= Integer.MAX_VALUE; i <<= 1) {
            long shift1 = i >> 1;
            long shift2 = i >> 2;
            long shift3 = i >> 3;
            long shift5 = i >> 5;
            IndexDecoderTests.assertEquals((long)shift3, (long)(IndexDecoder.decodeIndexContent(CodedIndex.CustomAttributeType, i) + 1));
            IndexDecoderTests.assertEquals((long)shift2, (long)(IndexDecoder.decodeIndexContent(CodedIndex.HasConstant, i) + 1));
            IndexDecoderTests.assertEquals((long)shift5, (long)(IndexDecoder.decodeIndexContent(CodedIndex.HasCustomAttribute, i) + 1));
            IndexDecoderTests.assertEquals((long)shift2, (long)(IndexDecoder.decodeIndexContent(CodedIndex.HasDeclSecurity, i) + 1));
            IndexDecoderTests.assertEquals((long)shift1, (long)(IndexDecoder.decodeIndexContent(CodedIndex.HasFieldMarshall, i) + 1));
            IndexDecoderTests.assertEquals((long)shift1, (long)(IndexDecoder.decodeIndexContent(CodedIndex.HasSemantics, i) + 1));
            IndexDecoderTests.assertEquals((long)shift2, (long)(IndexDecoder.decodeIndexContent(CodedIndex.Implementation, i) + 1));
            IndexDecoderTests.assertEquals((long)shift1, (long)(IndexDecoder.decodeIndexContent(CodedIndex.MemberForwarded, i) + 1));
            IndexDecoderTests.assertEquals((long)shift3, (long)(IndexDecoder.decodeIndexContent(CodedIndex.MemberRefParent, i) + 1));
            IndexDecoderTests.assertEquals((long)shift1, (long)(IndexDecoder.decodeIndexContent(CodedIndex.MethodDefOrRef, i) + 1));
            IndexDecoderTests.assertEquals((long)shift2, (long)(IndexDecoder.decodeIndexContent(CodedIndex.ResolutionScope, i) + 1));
            IndexDecoderTests.assertEquals((long)shift2, (long)(IndexDecoder.decodeIndexContent(CodedIndex.TypeDefOrRef, i) + 1));
            IndexDecoderTests.assertEquals((long)shift1, (long)(IndexDecoder.decodeIndexContent(CodedIndex.TypeOrMethodDef, i) + 1));
        }
    }

    public void testDecodeIndex() {
        IndexDecoderTests.assertEquals((int)5, (int)IndexDecoder.decodeIndex(CodedIndex.CustomAttributeType, 85L));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.decodeIndex(CodedIndex.CustomAttributeType, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.HasConstant, 85L));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.decodeIndex(CodedIndex.HasConstant, 170L));
        IndexDecoderTests.assertEquals((int)21, (int)IndexDecoder.decodeIndex(CodedIndex.HasCustomAttribute, 85L));
        IndexDecoderTests.assertEquals((int)10, (int)IndexDecoder.decodeIndex(CodedIndex.HasCustomAttribute, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.HasDeclSecurity, 85L));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.decodeIndex(CodedIndex.HasDeclSecurity, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.HasFieldMarshall, 85L));
        IndexDecoderTests.assertEquals((int)0, (int)IndexDecoder.decodeIndex(CodedIndex.HasFieldMarshall, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.HasSemantics, 85L));
        IndexDecoderTests.assertEquals((int)0, (int)IndexDecoder.decodeIndex(CodedIndex.HasSemantics, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.Implementation, 85L));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.decodeIndex(CodedIndex.Implementation, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.MemberForwarded, 85L));
        IndexDecoderTests.assertEquals((int)0, (int)IndexDecoder.decodeIndex(CodedIndex.MemberForwarded, 170L));
        IndexDecoderTests.assertEquals((int)5, (int)IndexDecoder.decodeIndex(CodedIndex.MemberRefParent, 85L));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.decodeIndex(CodedIndex.MemberRefParent, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.MethodDefOrRef, 85L));
        IndexDecoderTests.assertEquals((int)0, (int)IndexDecoder.decodeIndex(CodedIndex.MethodDefOrRef, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.ResolutionScope, 85L));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.decodeIndex(CodedIndex.ResolutionScope, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.TypeDefOrRef, 85L));
        IndexDecoderTests.assertEquals((int)2, (int)IndexDecoder.decodeIndex(CodedIndex.TypeDefOrRef, 170L));
        IndexDecoderTests.assertEquals((int)1, (int)IndexDecoder.decodeIndex(CodedIndex.TypeOrMethodDef, 85L));
        IndexDecoderTests.assertEquals((int)0, (int)IndexDecoder.decodeIndex(CodedIndex.TypeOrMethodDef, 170L));
    }
}

