/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.utils;

import at.pollaknet.api.facile.util.ByteReader;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;

public class ByteReaderTests
extends TestCase {
    public void testGetInt8() {
        byte[] numbers = new byte[]{-86, 85, 0, -1, 127, -128};
        ByteReaderTests.assertTrue((ByteReader.getInt8(numbers, 0) == -86 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt8(numbers, 1) == 85 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt8(numbers, 2) == 0 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt8(numbers, 3) == -1 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt8(numbers, 4) == 127 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt8(numbers, 5) == -128 ? 1 : 0) != 0);
    }

    public void testGetUInt8() {
        byte[] numbers = new byte[]{-86, 85, 0, -1, 127, -128};
        ByteReaderTests.assertTrue((ByteReader.getUInt8(numbers, 0) == 170 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt8(numbers, 1) == 85 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt8(numbers, 2) == 0 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt8(numbers, 3) == 255 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt8(numbers, 4) == 127 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt8(numbers, 5) == 128 ? 1 : 0) != 0);
    }

    public void testGetInt16() {
        byte[] numbers = new byte[]{-86, -86, 85, 85, 0, 0, -1, -1, -1, 127, 0, -128};
        ByteReaderTests.assertTrue((ByteReader.getInt16(numbers, 0) == -21846 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt16(numbers, 2) == 21845 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt16(numbers, 4) == 0 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt16(numbers, 6) == -1 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt16(numbers, 8) == Short.MAX_VALUE ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt16(numbers, 10) == Short.MIN_VALUE ? 1 : 0) != 0);
    }

    public void testGetUInt16() {
        byte[] numbers = new byte[]{-86, -86, 85, 85, 0, 0, -1, -1, -1, 127, 0, -128};
        ByteReaderTests.assertTrue((ByteReader.getUInt16(numbers, 0) == 43690 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt16(numbers, 2) == 21845 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt16(numbers, 4) == 0 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt16(numbers, 6) == 65535 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt16(numbers, 8) == Short.MAX_VALUE ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt16(numbers, 10) == 32768 ? 1 : 0) != 0);
    }

    public void testGetInt32() {
        byte[] numbers = new byte[]{-86, -86, -86, -86, 85, 85, 85, 85, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 127, 0, 0, 0, -128, -1, 0, -1, 127, 0, -1, 0, -128};
        ByteReaderTests.assertTrue((ByteReader.getInt32(numbers, 0) == -1431655766 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt32(numbers, 4) == 0x55555555 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt32(numbers, 8) == 0 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt32(numbers, 12) == -1 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt32(numbers, 16) == Integer.MAX_VALUE ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt32(numbers, 20) == Integer.MIN_VALUE ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt32(numbers, 24) == 0x7FFF00FF ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt32(numbers, 28) == -2147418368 ? 1 : 0) != 0);
    }

    public void testGetUInt32() {
        byte[] numbers = new byte[]{-86, -86, -86, -86, 85, 85, 85, 85, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 127, 0, 0, 0, -128, -1, 0, -1, 127, 0, -1, 0, -128};
        ByteReaderTests.assertTrue((ByteReader.getUInt32(numbers, 0) == 0xAAAAAAAAL ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt32(numbers, 4) == 0x55555555L ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt32(numbers, 8) == 0L ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt32(numbers, 12) == 0xFFFFFFFFL ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt32(numbers, 16) == Integer.MAX_VALUE ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt32(numbers, 20) == 0x80000000L ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt32(numbers, 24) == 0x7FFF00FFL ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getUInt32(numbers, 28) == 0x8000FF00L ? 1 : 0) != 0);
    }

    public void testGetInt64() {
        byte[] numbers = new byte[]{-86, -86, -86, -86, -86, -86, -86, -86, 85, 85, 85, 85, 85, 85, 85, 85, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 127, 0, 0, 0, 0, 0, 0, 0, -128, 0, -1, 0, -1, 0, 0, -1, 127, -1, 0, -1, 0, -1, -1, 0, -128};
        ByteReaderTests.assertTrue((ByteReader.getInt64(numbers, 0) == -6148914691236517206L ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt64(numbers, 8) == 0x5555555555555555L ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt64(numbers, 16) == 0L ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt64(numbers, 24) == -1L ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt64(numbers, 32) == Long.MAX_VALUE ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt64(numbers, 40) == Long.MIN_VALUE ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt64(numbers, 48) == 0x7FFF0000FF00FF00L ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getInt64(numbers, 56) == -9223090566156320513L ? 1 : 0) != 0);
    }

    public void testGetBytes() {
        byte[] byteArray = new byte[]{-86, 85, 10, 42, 66, 83, 74, 66, 1, 0, 1, 0, 0, 0, 0, 0, 12, 0, 0, 0, 118, 50, 46, 48, 46, 53, 48, 55, 50, 55, 0};
        ByteReaderTests.assertTrue((ByteReader.getBytes(byteArray, 0, 0).length == 0 ? 1 : 0) != 0);
        ByteReaderTests.assertTrue((ByteReader.getBytes(byteArray, 10, 0).length == 0 ? 1 : 0) != 0);
        int index = 0;
        for (byte b : ByteReader.getBytes(byteArray, 0, 2)) {
            ByteReaderTests.assertTrue((b == byteArray[index] ? 1 : 0) != 0);
            ++index;
        }
        for (byte b : ByteReader.getBytes(byteArray, 2, 3)) {
            ByteReaderTests.assertTrue((b == byteArray[index] ? 1 : 0) != 0);
            ++index;
        }
        for (byte b : ByteReader.getBytes(byteArray, 5, 4)) {
            ByteReaderTests.assertTrue((b == byteArray[index] ? 1 : 0) != 0);
            ++index;
        }
        index = 19;
        for (byte b : ByteReader.getBytes(byteArray, 19, 5)) {
            ByteReaderTests.assertTrue((b == byteArray[index] ? 1 : 0) != 0);
            ++index;
        }
        ByteReaderTests.assertEquals((String)"*BSJB", (String)new String(ByteReader.getBytes(byteArray, 3, 5)));
        ByteReaderTests.assertEquals((String)"v2.0.50727", (String)new String(ByteReader.getBytes(byteArray, 20, 10)));
    }

    public void testAlignToNextDWord() {
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(0), (int)4);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(1), (int)4);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(2), (int)4);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(3), (int)4);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(4), (int)8);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(7), (int)8);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(8), (int)12);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(129), (int)132);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(1021), (int)1024);
        ByteReaderTests.assertEquals((int)ByteReader.alingToNextDWord(8096), (int)8100);
    }

    public void testGetUTF16PreparedBytes() {
        byte[] byteArray = new byte[]{-86, 85, 10, 42, 0, 66, 0, 83, 0, 74, 0, 66, 0, 1, 0, 1, 0, 0, 0, 0, 0, 12, 0, 0, 0, 118, 0, 50, 0, 46, 0, 48, 0, 46, 0, 53, 0, 48, 0, 55, 0, 50, 0, 55, 0, 0};
        try {
            ByteReaderTests.assertEquals((String)new String(ByteReader.getUTF16PreparedBytes(byteArray, 3, 10), "UTF16"), (String)"*BSJB");
            ByteReaderTests.assertEquals((String)new String(ByteReader.getUTF16PreparedBytes(byteArray, 25, 20), "UTF16"), (String)"v2.0.50727");
            ByteReaderTests.assertEquals((String)new String(ByteReader.getUTF16PreparedBytes(byteArray, 3, 9), "UTF16"), (String)"*BSJB");
        }
        catch (UnsupportedEncodingException e) {
            ByteReaderTests.fail((String)e.getMessage());
        }
    }

    public void testGetSizeOfHeapLength() {
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(0), (int)1);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(3), (int)1);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(17), (int)1);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(32), (int)1);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(127), (int)1);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(128), (int)2);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(512), (int)2);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(16383), (int)2);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(16384), (int)4);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(65536), (int)4);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(72392302), (int)4);
        ByteReaderTests.assertEquals((int)ByteReader.getSizeOfHeapLength(Integer.MAX_VALUE), (int)4);
    }

    public void testReadHeapObjectSize() {
        byte[] byteArray = new byte[]{0, 1, 18, 127, -128, -128, -126, 3, -65, -1, -64, 0, 64, 0, -1, -1, -1, -1};
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 0), (int)0);
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 1), (int)1);
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 2), (int)18);
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 3), (int)127);
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 4), (int)128);
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 6), (int)515);
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 8), (int)16383);
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 10), (int)16384);
        ByteReaderTests.assertEquals((int)ByteReader.readHeapObjectSize(byteArray, 14), (int)0x1FFFFFFF);
    }
}

