/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.utils;

import at.pollaknet.api.facile.util.ArrayUtils;
import junit.framework.TestCase;

public class ArrayUtilsTest
extends TestCase {
    public void testContains() {
        int[] intArray = new int[]{0, 2, 0, 4, 112, 1345, 5968, 9, 0, 40, 892374, 337, 1};
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.contains(intArray, 0));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.contains(intArray, 1345));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.contains(intArray, 9));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.contains(intArray, 892374));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.contains(intArray, 1));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.contains(intArray, -1));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.contains(intArray, 3));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.contains(intArray, 113));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.contains(intArray, 892375));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.contains(intArray, -40));
    }

    public void testFormatByteArray() {
        byte[] array1 = new byte[]{-86, -86, 85, 85, 0};
        byte[] array2 = new byte[]{-1, -1, -1, 127, 0, -128};
        ArrayUtilsTest.assertEquals((String)"aa aa 55 55 00", (String)ArrayUtils.formatByteArray(array1));
        ArrayUtilsTest.assertEquals((String)"ff ff ff 7f 00 80", (String)ArrayUtils.formatByteArray(array2));
    }

    public void testByteArraysAreEqual() {
        byte[] array0 = new byte[]{-86, -86, 84, 85, 0};
        byte[] array1 = new byte[]{-86, -86, 85, 85, 0};
        byte[] array2 = new byte[]{-86, -86, 85, 85, 0};
        byte[] array3 = new byte[]{-86, -86, 85, 85, 0, 18};
        byte[] array4 = new byte[]{-1, -1, -1, 127, 0, -128};
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.arraysAreEqual(array1, array1));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.arraysAreEqual(array4, array4));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.arraysAreEqual(array1, array2));
        ArrayUtilsTest.assertTrue((boolean)ArrayUtils.arraysAreEqual(array2, array1));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.arraysAreEqual(array1, array3));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.arraysAreEqual(array3, array1));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.arraysAreEqual(array0, array4));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.arraysAreEqual(array4, array0));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.arraysAreEqual(array0, array1));
        ArrayUtilsTest.assertFalse((boolean)ArrayUtils.arraysAreEqual(array1, array0));
    }

    public void testFindInByteArray() {
        byte[] byteArray = new byte[]{-86, 85, 10, 42, 66, 83, 74, 66, 1, 0, 1, 0, 0, 0, 0, 0, 12, 0, 0, 0, 118, 50, 46, 48, 46, 53, 48, 55, 50, 55, 0};
        ArrayUtilsTest.assertEquals((int)ArrayUtils.findInByteArray(byteArray, 0, (byte)74), (int)6);
        ArrayUtilsTest.assertEquals((int)ArrayUtils.findInByteArray(byteArray, 0, (byte)0), (int)9);
        ArrayUtilsTest.assertEquals((int)ArrayUtils.findInByteArray(byteArray, 9, (byte)0), (int)0);
        ArrayUtilsTest.assertEquals((int)ArrayUtils.findInByteArray(byteArray, 20, (byte)0), (int)10);
        ArrayUtilsTest.assertEquals((int)ArrayUtils.findInByteArray(byteArray, 3, (byte)55), (int)24);
        ArrayUtilsTest.assertEquals((int)ArrayUtils.findInByteArray(byteArray, 3, (byte)-2), (int)-1);
    }
}

