/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.local;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.exception.CoffPeDataNotFoundException;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import junit.framework.TestCase;

public class TestDrives
extends TestCase {
    private static FileFilter filter;
    private int fileCount = 0;
    private int loadedAssemblyCount = 0;
    private int failedCount = 0;
    private static boolean performExtendedTests;

    public TestDrives() {
    }

    public TestDrives(String name) {
        super(name);
    }

    public static void main(String[] args) {
        new TestDrives().testAllAssembliesOnDriveLocalDrives();
    }

    public void testAllAssembliesOnDriveLocalDrives() {
        filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                if (name.endsWith(".exe")) {
                    return true;
                }
                if (name.endsWith(".dll")) {
                    return true;
                }
                if (name.endsWith(".netmodule")) {
                    return true;
                }
                if (name.endsWith(".mcl")) {
                    return true;
                }
                return file.isDirectory();
            }
        };
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        if (operatingSystem.startsWith("win")) {
            for (char letter = 'A'; letter <= 'Z'; letter = (char)(letter + '\u0001')) {
                this.addAndInvokeFiles(letter + ":\\");
            }
        } else {
            this.addAndInvokeFiles("/");
        }
        System.out.println("\nProcessed " + this.fileCount + " files.");
        System.out.println("(" + this.failedCount + " out of " + (this.failedCount + this.loadedAssemblyCount) + " assemblies failed)");
        if (this.failedCount > 0) {
            TestDrives.fail();
        }
    }

    private void addAndInvokeFiles(String directoryPath) {
        File currentDirectory = new File(directoryPath);
        File[] filesInDirectory = currentDirectory.listFiles(filter);
        if (filesInDirectory != null) {
            for (File file : filesInDirectory) {
                if (file.isDirectory()) {
                    this.addAndInvokeFiles(file.getAbsolutePath());
                    continue;
                }
                this.tryAssembly(file);
                ++this.fileCount;
                if (this.fileCount % 100 != 0 || this.fileCount == 0) continue;
                System.out.println(String.format("Passed %5d  files... (%5d Assemblies)", this.fileCount, this.loadedAssemblyCount));
                System.gc();
            }
        }
    }

    private void tryAssembly(File file) {
        String path = file.getAbsolutePath();
        try {
            FacileReflector reflector = Facile.load(path);
            Assembly assembly = reflector.loadAssembly();
            if (performExtendedTests) {
                Assembly comparisonAssembly = Facile.loadAssembly(path);
                if (!assembly.equals(comparisonAssembly)) {
                    throw new Exception("Equals test failed!");
                }
                if (!comparisonAssembly.equals(assembly)) {
                    throw new Exception("Equals test failed!");
                }
            }
            ++this.loadedAssemblyCount;
        }
        catch (Error e) {
            System.out.println("Unable to open: " + path + ":");
            e.printStackTrace();
        }
        catch (CoffPeDataNotFoundException e) {
        }
        catch (IOException e) {
            System.out.println("Unable to read: " + path + " (" + e.getMessage() + ")");
        }
        catch (RuntimeException e) {
            System.out.println("Exception in: " + path);
            e.printStackTrace();
            ++this.failedCount;
        }
        catch (Exception e) {
            System.out.println("Exception in: " + path);
            e.printStackTrace();
            ++this.failedCount;
        }
    }

    static {
        performExtendedTests = false;
    }
}

