/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.gac;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.exception.CoffPeDataNotFoundException;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestGACFusion
extends TestCase {
    private static final String GAC_WIN_ABSOLUTE_PATH = "C:/WINDOWS/assembly";
    private static final String GAC_OSX_PATH_PREFIX = "/Library/Frameworks/Mono.framework/Versions";
    private static final String ALL_OSX_PATH_POSTFIX = "/lib/mono";
    private static ArrayList<String> assemblies = null;
    static FileFilter filter;

    private static void initGACFileList() {
        if (assemblies == null) {
            assemblies = new ArrayList(1024);
            filter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String name = file.getName();
                    if (name.endsWith(".exe")) {
                        return true;
                    }
                    if (name.endsWith(".dll")) {
                        return true;
                    }
                    if (name.endsWith(".netmodule")) {
                        return true;
                    }
                    if (name.endsWith(".mcl")) {
                        return true;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    return name.equals("__AssemblyInfo__.ini");
                }
            };
            String operatingSystem = System.getProperty("os.name").toLowerCase();
            if (operatingSystem.startsWith("win")) {
                TestGACFusion.addFiles(GAC_WIN_ABSOLUTE_PATH);
            } else if (operatingSystem.startsWith("mac")) {
                File currentDirectory = new File(GAC_OSX_PATH_PREFIX);
                File[] directoryFiles = currentDirectory.listFiles();
                if (directoryFiles != null) {
                    for (File file : directoryFiles) {
                        if (!file.isDirectory()) continue;
                        TestGACFusion.addFiles(file.getAbsolutePath() + GAC_OSX_PATH_PREFIX);
                    }
                }
            } else {
                TestGACFusion.assertTrue((String)"Please define operating system first!", (boolean)false);
            }
        }
    }

    private static void addFiles(String directoryPath) {
        File currentDirectory = new File(directoryPath);
        for (File file : currentDirectory.listFiles(filter)) {
            if (file.isDirectory()) {
                TestGACFusion.addFiles(file.getAbsolutePath());
                continue;
            }
            if (file.getName().equals("__AssemblyInfo__.ini")) {
                try {
                    FileInputStream stream = new FileInputStream(file);
                    TestGACFusion.assertTrue((file.length() <= Integer.MAX_VALUE ? 1 : 0) != 0);
                    byte[] buffer = new byte[(int)file.length()];
                    int bytesRead = stream.read(buffer);
                    assert (bytesRead == (int)file.length());
                    assert (stream.read() == -1);
                    stream.close();
                    String text = new String(buffer);
                    int pos = text.indexOf("URL=file:///");
                    while (pos >= 0) {
                        String pathToAssembly = (text = text.substring(pos + 12)).substring(0, text.indexOf(13));
                        if (!assemblies.contains(pathToAssembly)) {
                            assemblies.add(pathToAssembly);
                        }
                        pos = text.indexOf("URL=file:///");
                    }
                    continue;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            assemblies.add(file.getAbsolutePath());
        }
    }

    public TestGACFusion(String name) {
        super(name);
    }

    public void testAllAssembliesInGAC() throws RuntimeException {
        String currentFile = null;
        int fileCount = 0;
        int missingCount = 0;
        TestGACFusion.initGACFileList();
        for (String path : assemblies) {
            try {
                Assembly assembly = Facile.loadAssembly(path);
                ++fileCount;
            }
            catch (Error e) {
                System.out.println("Error occurred: " + path);
                ++missingCount;
            }
            catch (CoffPeDataNotFoundException e) {
                System.out.println("No .NET content found: " + path);
                ++missingCount;
            }
            catch (IOException e) {
                System.out.println("Unable to read: " + path);
                ++missingCount;
            }
            catch (RuntimeException e) {
                currentFile = path;
                System.out.println("Exception in: " + path);
                e.printStackTrace();
            }
            catch (Exception e) {
                currentFile = path;
                System.out.println("Exception in: " + path);
                e.printStackTrace();
            }
        }
        System.out.println("\nProcessed " + fileCount + " .net assemblies.");
        System.out.println("(" + missingCount + " files are missing; " + (assemblies.size() - fileCount - missingCount) + " failed to reflect/load)\n");
        if (fileCount + missingCount != assemblies.size()) {
            TestGACFusion.fail((String)currentFile);
        }
    }
}

