/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.assemblies;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.exception.DotNetContentNotFoundException;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import junit.framework.TestCase;

public class FacileReferenceTests
extends TestCase {
    private static final String PATH_MSCORLIBV4_0_4000_32 = "assemblies/v4.0.4.0.0.0_32/mscorlib.dll";
    private static final String PATH_MSCORLIBV4_0_4000_64 = "assemblies/v4.0.4.0.0.0_64/mscorlib.dll";
    private static final int NUM_OF_TEST_CASES = 1;
    private static FacileReflector reflector32 = null;
    private static FacileReflector reflector64 = null;
    private static int testCounter = 0;

    public FacileReferenceTests(String name) {
        super(name);
    }

    protected void setUp() {
        if (testCounter == 0) {
            try {
                reflector32 = Facile.reflect(PATH_MSCORLIBV4_0_4000_32);
                reflector32.getReferneceEnums().clear();
            }
            catch (Exception e) {
                FacileReferenceTests.fail();
            }
            try {
                reflector64 = Facile.reflect(PATH_MSCORLIBV4_0_4000_64);
                reflector64.getReferneceEnums().clear();
            }
            catch (Exception e) {
                FacileReferenceTests.fail();
            }
        }
        ++testCounter;
    }

    protected void tearDown() {
        if (testCounter == 1) {
            reflector32 = null;
            reflector64 = null;
        }
    }

    public void testLoadAssembyWithoutEnumReferences() {
        Assembly mscorlib32 = null;
        try {
            mscorlib32 = reflector32.loadAssembly();
        }
        catch (DotNetContentNotFoundException e) {
            e.printStackTrace();
            FacileReferenceTests.fail();
        }
        FacileReferenceTests.assertNotNull((Object)mscorlib32);
        Assembly mscorlib64 = null;
        try {
            mscorlib64 = reflector64.loadAssembly();
        }
        catch (DotNetContentNotFoundException e) {
            e.printStackTrace();
            FacileReferenceTests.fail();
        }
        FacileReferenceTests.assertNotNull((Object)mscorlib64);
    }
}

