/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.assemblies;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.util.ArrayUtils;
import junit.framework.TestCase;

public class FacileMscorlibV4_0_4_0_0_0Tests
extends TestCase {
    private static final String PATH_MSCORLIBV4_0_4000_32 = "assemblies/v4.0.4.0.0.0_32/mscorlib.dll";
    private static final String PATH_MSCORLIBV4_0_4000_64 = "assemblies/v4.0.4.0.0.0_64/mscorlib.dll";
    private static final int NUM_OF_TEST_CASES = 5;
    private static FacileReflector reflector32 = null;
    private static FacileReflector reflector64 = null;
    private static int testCounter = 0;

    public FacileMscorlibV4_0_4_0_0_0Tests(String name) {
        super(name);
    }

    protected void setUp() {
        if (testCounter == 0) {
            try {
                reflector32 = Facile.load(PATH_MSCORLIBV4_0_4000_32);
            }
            catch (Exception e) {
                FacileMscorlibV4_0_4_0_0_0Tests.fail();
            }
            try {
                reflector64 = Facile.load(PATH_MSCORLIBV4_0_4000_64);
            }
            catch (Exception e) {
                FacileMscorlibV4_0_4_0_0_0Tests.fail();
            }
        }
        ++testCounter;
    }

    protected void tearDown() {
        if (testCounter == 5) {
            reflector32 = null;
            reflector64 = null;
        }
    }

    public void testCliHeader() {
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector32.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getCliHeader().getMinorRuntimeVersion(), (int)5);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector32.getCliHeader().getAddrOfMetadataDirectory(), (long)1475016L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector32.getCliHeader().getSizeOfMetadataDirectory(), (long)2254704L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector32.getCliHeader().getFlags(), (long)11L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector64.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getCliHeader().getMinorRuntimeVersion(), (int)5);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector64.getCliHeader().getAddrOfMetadataDirectory(), (long)1475896L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector64.getCliHeader().getSizeOfMetadataDirectory(), (long)2254152L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector64.getCliHeader().getFlags(), (long)9L);
    }

    public void testMetadataRootHeader() {
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector32.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)reflector32.getCliMetadataRootHeader().getVersionString(), (String)"v4.0.30319\u0000\u0000");
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((long)reflector64.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)reflector64.getCliMetadataRootHeader().getVersionString(), (String)"v4.0.30319\u0000\u0000");
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
    }

    public void testStreamSizes() {
        int alignmentGap = 4;
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getSizeOfMetadataStream(), (int)(1389816 - alignmentGap));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getSizeOfStringsStream(), (int)395900);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getSizeOfUserStringStream(), (int)222740);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector32.getSizeOfBlobStream(), (int)246124);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getSizeOfMetadataStream(), (int)(1389500 - alignmentGap));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getSizeOfStringsStream(), (int)395708);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getSizeOfUserStringStream(), (int)222684);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((int)reflector64.getSizeOfBlobStream(), (int)246136);
    }

    public void testStringsStream() {
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"DaysTo10000", (String)reflector32.getStringsStream().getString(1));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"Digit100", (String)reflector32.getStringsStream().getString(26));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"SystemFunction040", (String)reflector32.getStringsStream().getString(445));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"WAIT_OBJECT_0", (String)reflector32.getStringsStream().getString(755));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"SystemCollectionsConcurrent_ProducerConsumerCollectionDebugView`1", (String)reflector32.getStringsStream().getString(5395));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"GetNewLogicalCallID", (String)reflector32.getStringsStream().getString(23517));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"System.Runtime.InteropServices.ICustomQueryInterface.GetInterface", (String)reflector32.getStringsStream().getString(88346));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"StandAloneSig", (String)reflector32.getStringsStream().getString(170184));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<TKey,TValue>>.GetEnumerator", (String)reflector32.getStringsStream().getString(280694));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"EncodeHexStringFromInt", (String)reflector32.getStringsStream().getString(344085));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"GetServerContextAndDomainIdForProxy", (String)reflector32.getStringsStream().getString(395515));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"DaysTo10000", (String)reflector64.getStringsStream().getString(1));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"Digit100", (String)reflector64.getStringsStream().getString(26));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"SystemFunction040", (String)reflector64.getStringsStream().getString(445));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"WAIT_OBJECT_0", (String)reflector64.getStringsStream().getString(755));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"SystemCollectionsConcurrent_ProducerConsumerCollectionDebugView`1", (String)reflector64.getStringsStream().getString(5395));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"GetNewLogicalCallID", (String)reflector64.getStringsStream().getString(23517));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"System.Runtime.InteropServices.ICustomQueryInterface.GetInterface", (String)reflector64.getStringsStream().getString(88310));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"StandAloneSig", (String)reflector64.getStringsStream().getString(170119));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"GetRuntimeMethodHandleFromMetadataToken", (String)reflector64.getStringsStream().getString(216708));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"System.Runtime.Remoting.Contexts", (String)reflector64.getStringsStream().getString(329363));
        FacileMscorlibV4_0_4_0_0_0Tests.assertEquals((String)"System.Collections.IDictionaryEnumerator.Entry", (String)reflector64.getStringsStream().getString(388806));
    }

    public void testBlobStream() {
        byte[] blob1 = new byte[]{21, 18, -125, 88, 1, 18, -110, 64};
        byte[] blob2 = new byte[]{32, 0, 21, 18, -128, -48, 1, 19, 0};
        byte[] blob3 = new byte[]{7, 5, 18, 72, 18, -124, -104, 18, -124, -104, 28, 18, 20};
        byte[] blob4 = new byte[]{0, 3, 29, 18, -126, 4, 18, -124, -128, 18, -124, -116, 2};
        byte[] blob5 = new byte[]{1, 0, 8, 0, 0, 0, 1, 0, 84, 2, 9, 73, 110, 104, 101, 114, 105, 116, 101, 100, 1};
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob1, reflector32.getBlobStream().getBlob(1)));
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob2, reflector32.getBlobStream().getBlob(110)));
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob3, reflector32.getBlobStream().getBlob(18063)));
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob4, reflector32.getBlobStream().getBlob(128463)));
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob5, reflector32.getBlobStream().getBlob(241326)));
        byte[] blob6 = new byte[]{21, 18, -125, 88, 1, 18, -110, 56};
        byte[] blob7 = new byte[]{32, 0, 21, 18, -128, -48, 1, 19, 0};
        byte[] blob8 = new byte[]{7, 5, 18, 72, 18, -124, -104, 18, -124, -104, 28, 18, 20};
        byte[] blob9 = new byte[]{0, 3, 29, 18, -126, 4, 18, -124, -128, 18, -124, -116, 2};
        byte[] blob10 = new byte[]{32, 10, 18, -125, -128, 8, 8, 17, -126, -124, 17, -126, -128, 8, 14, 8, 8, 18, -126, 80, 28};
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob6, reflector64.getBlobStream().getBlob(1)));
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob7, reflector64.getBlobStream().getBlob(110)));
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob8, reflector64.getBlobStream().getBlob(18063)));
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob9, reflector64.getBlobStream().getBlob(128491)));
        FacileMscorlibV4_0_4_0_0_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob10, reflector64.getBlobStream().getBlob(198206)));
    }
}

