/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.assemblies;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.util.ArrayUtils;
import junit.framework.TestCase;

public class FacileMscorlibV4_0_30319Tests
extends TestCase {
    private static final String PATH_MSCORLIBV4_0_30319_32 = "assemblies/v4.0.30319_32/mscorlib.dll";
    private static final String PATH_MSCORLIBV4_0_30319_64 = "assemblies/v4.0.30319_64/mscorlib.dll";
    private static final int NUM_OF_TEST_CASES = 5;
    private static FacileReflector reflector32 = null;
    private static FacileReflector reflector64 = null;
    private static int testCounter = 0;

    public FacileMscorlibV4_0_30319Tests(String name) {
        super(name);
    }

    protected void setUp() {
        if (testCounter == 0) {
            try {
                reflector32 = Facile.load(PATH_MSCORLIBV4_0_30319_32);
            }
            catch (Exception e) {
                FacileMscorlibV4_0_30319Tests.fail();
            }
            try {
                reflector64 = Facile.load(PATH_MSCORLIBV4_0_30319_64);
            }
            catch (Exception e) {
                FacileMscorlibV4_0_30319Tests.fail();
            }
        }
        ++testCounter;
    }

    protected void tearDown() {
        if (testCounter == 5) {
            reflector32 = null;
        }
    }

    public void testCliHeader() {
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector32.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getCliHeader().getMinorRuntimeVersion(), (int)5);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector32.getCliHeader().getAddrOfMetadataDirectory(), (long)2361488L);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector32.getCliHeader().getSizeOfMetadataDirectory(), (long)2102204L);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector32.getCliHeader().getFlags(), (long)11L);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector64.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getCliHeader().getMinorRuntimeVersion(), (int)5);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector64.getCliHeader().getAddrOfMetadataDirectory(), (long)2361560L);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector64.getCliHeader().getSizeOfMetadataDirectory(), (long)2102620L);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector64.getCliHeader().getFlags(), (long)9L);
    }

    public void testMetadataRootHeader() {
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector32.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV4_0_30319Tests.assertEquals((String)reflector32.getCliMetadataRootHeader().getVersionString(), (String)"v4.0.30319\u0000\u0000");
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV4_0_30319Tests.assertEquals((long)reflector64.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV4_0_30319Tests.assertEquals((String)reflector64.getCliMetadataRootHeader().getVersionString(), (String)"v4.0.30319\u0000\u0000");
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
    }

    public void testStreamSizes() {
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getSizeOfMetadataStream(), (int)1250864);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getSizeOfStringsStream(), (int)423536);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getSizeOfUserStringStream(), (int)214784);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector32.getSizeOfBlobStream(), (int)212896);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getSizeOfMetadataStream(), (int)1251264);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getSizeOfStringsStream(), (int)423580);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getSizeOfUserStringStream(), (int)214728);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV4_0_30319Tests.assertEquals((int)reflector64.getSizeOfBlobStream(), (int)212924);
    }

    public void testStringsStream() {
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"<Module>", (String)reflector32.getStringsStream().getString(1));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"CommonLanguageRuntimeLibrary", (String)reflector32.getStringsStream().getString(10));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"Object", (String)reflector32.getStringsStream().getString(39));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"System", (String)reflector32.getStringsStream().getString(46));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"System.Runtime.Serialization", (String)reflector32.getStringsStream().getString(103));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"DBNull", (String)reflector32.getStringsStream().getString(3400));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"MinValue", (String)reflector32.getStringsStream().getString(61623));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"sLocalizedCountry", (String)reflector32.getStringsStream().getString(219351));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"get_SerializationFormatter", (String)reflector32.getStringsStream().getString(285866));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"System.Runtime.InteropServices._TypeBuilder.GetTypeInfoCount", (String)reflector32.getStringsStream().getString(349606));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"System.Collections.Generic.IEnumerator<System.Globalization.CultureInfo>.Current", (String)reflector32.getStringsStream().getString(421845));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"<Module>", (String)reflector64.getStringsStream().getString(1));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"CommonLanguageRuntimeLibrary", (String)reflector64.getStringsStream().getString(10));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"Object", (String)reflector64.getStringsStream().getString(39));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"System", (String)reflector64.getStringsStream().getString(46));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"System.Runtime.Serialization", (String)reflector64.getStringsStream().getString(103));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"DBNull", (String)reflector64.getStringsStream().getString(3429));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"MinValue", (String)reflector64.getStringsStream().getString(61653));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"Write7BitEncodedInt", (String)reflector64.getStringsStream().getString(233539));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"AllocateUninitializedObject", (String)reflector64.getStringsStream().getString(316174));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"System.Runtime.InteropServices._TypeBuilder.GetTypeInfoCount", (String)reflector64.getStringsStream().getString(349724));
        FacileMscorlibV4_0_30319Tests.assertEquals((String)"__StaticArrayInitTypeSize=4096", (String)reflector64.getStringsStream().getString(423269));
    }

    public void testBlobStream() {
        byte[] blob1 = new byte[]{21, 18, -128, -56, 1, 19, 0};
        byte[] blob2 = new byte[]{21, 18, -114, 52, 2, 19, 0, 21, 18, -115, -92, 1, 19, 0};
        byte[] blob3 = new byte[]{0, 5, 2, 18, -124, -64, 17, -112, 20, 14, 2, 14};
        byte[] blob4 = new byte[]{32, 12, 1, 14, 17, -101, -36, 17, -101, -48, 8, 2, 17, -101, -24, 8, 17, -101, -28, 18, -107, -96, 14, 2, 2};
        byte[] blob5 = new byte[]{7, 10, 17, -87, -36, 18, -86, 12, 18, -86, 12, 18, -87, 28, 18, -87, 28, 5, 8, 8, 8, 8};
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob1, reflector32.getBlobStream().getBlob(1)));
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob2, reflector32.getBlobStream().getBlob(667)));
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob3, reflector32.getBlobStream().getBlob(32638)));
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob4, reflector32.getBlobStream().getBlob(84592)));
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob5, reflector32.getBlobStream().getBlob(211579)));
        byte[] blob6 = new byte[]{21, 18, -128, -56, 1, 19, 0};
        byte[] blob7 = new byte[]{21, 18, -114, 56, 2, 19, 0, 21, 18, -115, -88, 1, 19, 0};
        byte[] blob8 = new byte[]{0, 5, 2, 18, -124, -56, 17, -112, 24, 14, 2, 14};
        byte[] blob9 = new byte[]{6, 21, 18, -115, 84, 2, 18, -124, -56, 18, -91, -112};
        byte[] blob10 = new byte[]{7, 9, 17, -106, -104, 18, -105, 20, 18, -97, 72, 17, -97, -36, 18, -105, 20, 18, -97, 72, 29, 17, -106, -104, 18, -128, -40, 18, -128, -24};
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob6, reflector64.getBlobStream().getBlob(1)));
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob7, reflector64.getBlobStream().getBlob(667)));
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob8, reflector64.getBlobStream().getBlob(32638)));
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob9, reflector64.getBlobStream().getBlob(99988)));
        FacileMscorlibV4_0_30319Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob10, reflector64.getBlobStream().getBlob(193276)));
    }
}

