/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.assemblies;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.util.ArrayUtils;
import junit.framework.TestCase;

public class FacileMscorlibV2_0_50727_832Tests
extends TestCase {
    private static final String PATH_MSCORLIBV2_0_50727_832 = "assemblies/v2.0.50727.832/mscorlib.dll";
    private static final int NUM_OF_TEST_CASES = 5;
    private static FacileReflector reflector = null;
    private static int testCounter = 0;

    public FacileMscorlibV2_0_50727_832Tests(String name) {
        super(name);
    }

    protected void setUp() {
        if (testCounter == 0) {
            try {
                reflector = Facile.load(PATH_MSCORLIBV2_0_50727_832);
            }
            catch (Exception e) {
                FacileMscorlibV2_0_50727_832Tests.fail();
            }
        }
        ++testCounter;
    }

    protected void tearDown() {
        if (testCounter == 5) {
            reflector = null;
        }
    }

    public void testCliHeader() {
        FacileMscorlibV2_0_50727_832Tests.assertEquals((long)reflector.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getCliHeader().getMinorRuntimeVersion(), (int)5);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((long)reflector.getCliHeader().getAddrOfMetadataDirectory(), (long)2313328L);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((long)reflector.getCliHeader().getSizeOfMetadataDirectory(), (long)1635212L);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((long)reflector.getCliHeader().getFlags(), (long)11L);
    }

    public void testMetadataRootHeader() {
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((long)reflector.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)reflector.getCliMetadataRootHeader().getVersionString(), (String)"v2.0.50727\u0000\u0000");
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
    }

    public void testStreamSizes() {
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getSizeOfMetadataStream(), (int)951100);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getSizeOfStringsStream(), (int)357088);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getSizeOfUserStringStream(), (int)171652);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV2_0_50727_832Tests.assertEquals((int)reflector.getSizeOfBlobStream(), (int)155248);
    }

    public void testStringsStream() {
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"<Module>", (String)reflector.getStringsStream().getString(1));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"CommonLanguageRuntimeLibrary", (String)reflector.getStringsStream().getString(10));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"Object", (String)reflector.getStringsStream().getString(39));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"System", (String)reflector.getStringsStream().getString(46));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"ICloneable", (String)reflector.getStringsStream().getString(97));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"IFormatProvider", (String)reflector.getStringsStream().getString(3304));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"TypeEntry", (String)reflector.getStringsStream().getString(34183));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"File_ImportPath", (String)reflector.getStringsStream().getString(104064));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"LOCALE_SNATIVEDIGITS", (String)reflector.getStringsStream().getString(172608));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"CreateCompressedState_HG", (String)reflector.getStringsStream().getString(238887));
        FacileMscorlibV2_0_50727_832Tests.assertEquals((String)"System.Reflection.ICustomAttributeProvider.GetCustomAttributes", (String)reflector.getStringsStream().getString(284076));
    }

    public void testBlobStream() {
        byte[] blob1 = new byte[]{21, 18, 48, 1, 19, 0};
        byte[] blob2 = new byte[]{21, 18, 88, 1, 19, 0};
        byte[] blob3 = new byte[]{21, 18, 108, 1, 2};
        byte[] blob4 = new byte[]{32, 1, 8, 17, -126, -32};
        byte[] blob5 = new byte[]{7, 5, 18, -125, -72, 18, -100, 56, 18, -101, 56, 18, -100, 4, 14};
        FacileMscorlibV2_0_50727_832Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob1, reflector.getBlobStream().getBlob(1)));
        FacileMscorlibV2_0_50727_832Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob2, reflector.getBlobStream().getBlob(8)));
        FacileMscorlibV2_0_50727_832Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob3, reflector.getBlobStream().getBlob(69)));
        FacileMscorlibV2_0_50727_832Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob4, reflector.getBlobStream().getBlob(19840)));
        FacileMscorlibV2_0_50727_832Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob5, reflector.getBlobStream().getBlob(143169)));
    }
}

