/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.assemblies;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.util.ArrayUtils;
import junit.framework.TestCase;

public class FacileMscorlibV2_0_50727_1433Tests
extends TestCase {
    private static final String PATH_MSCORLIBV2_0_50727_1433 = "assemblies/v2.0.50727.1433/mscorlib.dll";
    private static final int NUM_OF_TEST_CASES = 5;
    private static FacileReflector reflector = null;
    private static int testCounter = 0;

    public FacileMscorlibV2_0_50727_1433Tests(String name) {
        super(name);
    }

    protected void setUp() {
        if (testCounter == 0) {
            try {
                reflector = Facile.load(PATH_MSCORLIBV2_0_50727_1433);
            }
            catch (Exception e) {
                FacileMscorlibV2_0_50727_1433Tests.fail();
            }
        }
        ++testCounter;
    }

    protected void tearDown() {
        if (testCounter == 5) {
            reflector = null;
        }
    }

    public void testCliHeader() {
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((long)reflector.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getCliHeader().getMinorRuntimeVersion(), (int)5);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((long)reflector.getCliHeader().getAddrOfMetadataDirectory(), (long)2329808L);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((long)reflector.getCliHeader().getSizeOfMetadataDirectory(), (long)1656440L);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((long)reflector.getCliHeader().getFlags(), (long)11L);
    }

    public void testMetadataRootHeader() {
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((long)reflector.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)reflector.getCliMetadataRootHeader().getVersionString(), (String)"v2.0.50727\u0000\u0000");
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
    }

    public void testStreamSizes() {
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getSizeOfMetadataStream(), (int)963712);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getSizeOfStringsStream(), (int)362872);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getSizeOfUserStringStream(), (int)172564);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((int)reflector.getSizeOfBlobStream(), (int)157164);
    }

    public void testStringsStream() {
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"<Module>", (String)reflector.getStringsStream().getString(1));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"CommonLanguageRuntimeLibrary", (String)reflector.getStringsStream().getString(10));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"Object", (String)reflector.getStringsStream().getString(39));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"System", (String)reflector.getStringsStream().getString(46));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"ValueType", (String)reflector.getStringsStream().getString(220));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"Boolean", (String)reflector.getStringsStream().getString(2168));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"CategoryMembershipDataEntryFieldId", (String)reflector.getStringsStream().getString(7455));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"ArrayListEnumeratorSimple", (String)reflector.getStringsStream().getString(11151));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"CryptographicUnexpectedOperationException", (String)reflector.getStringsStream().getString(38885));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"INVOCATION_FLAGS_CONTAINS_STACK_POINTERS", (String)reflector.getStringsStream().getString(80440));
        FacileMscorlibV2_0_50727_1433Tests.assertEquals((String)"SXS_INSTALL_REFERENCE_SCHEME_SXS_STRONGNAME_SIGNED_PRIVATE_ASSEMBLY", (String)reflector.getStringsStream().getString(114132));
    }

    public void testBlobStream() {
        byte[] blob1 = new byte[]{21, 18, 48, 1, 19, 0};
        byte[] blob2 = new byte[]{21, 18, 88, 1, 19, 0};
        byte[] blob3 = new byte[]{21, 18, 104, 1, 2};
        byte[] blob4 = new byte[]{32, 2, 18, -116, -72, 14, 14};
        byte[] blob5 = new byte[]{0, 3, 28, 18, -125, -60, 29, 28, 29, 28};
        FacileMscorlibV2_0_50727_1433Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob1, reflector.getBlobStream().getBlob(1)));
        FacileMscorlibV2_0_50727_1433Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob2, reflector.getBlobStream().getBlob(8)));
        FacileMscorlibV2_0_50727_1433Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob3, reflector.getBlobStream().getBlob(79)));
        FacileMscorlibV2_0_50727_1433Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob4, reflector.getBlobStream().getBlob(568)));
        FacileMscorlibV2_0_50727_1433Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob5, reflector.getBlobStream().getBlob(12733)));
    }
}

