/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.assemblies;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.util.ArrayUtils;
import junit.framework.TestCase;

public class FacileMscorlibV2_0_31005_0Tests
extends TestCase {
    private static final String PATH_MSCORLIBV2_0_31005_0 = "assemblies/v2.0.31005.0/mscorlib.dll";
    private static final int NUM_OF_TEST_CASES = 5;
    private static FacileReflector reflector = null;
    private static int testCounter = 0;

    public FacileMscorlibV2_0_31005_0Tests(String name) {
        super(name);
    }

    protected void setUp() {
        if (testCounter == 0) {
            try {
                reflector = Facile.load(PATH_MSCORLIBV2_0_31005_0);
            }
            catch (Exception e) {
                FacileMscorlibV2_0_31005_0Tests.fail();
            }
        }
        ++testCounter;
    }

    protected void tearDown() {
        if (testCounter == 5) {
            reflector = null;
        }
    }

    public void testCliHeader() {
        FacileMscorlibV2_0_31005_0Tests.assertEquals((long)reflector.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getCliHeader().getMinorRuntimeVersion(), (int)5);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((long)reflector.getCliHeader().getAddrOfMetadataDirectory(), (long)615340L);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((long)reflector.getCliHeader().getSizeOfMetadataDirectory(), (long)832272L);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((long)reflector.getCliHeader().getFlags(), (long)11L);
    }

    public void testMetadataRootHeader() {
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((long)reflector.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)reflector.getCliMetadataRootHeader().getVersionString(), (String)"v2.0.50727\u0000\u0000");
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
    }

    public void testStreamSizes() {
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getSizeOfMetadataStream(), (int)505724);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getSizeOfStringsStream(), (int)176520);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getSizeOfUserStringStream(), (int)63808);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV2_0_31005_0Tests.assertEquals((int)reflector.getSizeOfBlobStream(), (int)86096);
    }

    public void testStringsStream() {
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"<Module>", (String)reflector.getStringsStream().getString(1));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"CommonLanguageRuntimeLibrary", (String)reflector.getStringsStream().getString(10));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"Object", (String)reflector.getStringsStream().getString(39));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"System", (String)reflector.getStringsStream().getString(46));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"IComparable", (String)reflector.getStringsStream().getString(99));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"IEnumerator", (String)reflector.getStringsStream().getString(1723));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"Mscorlib_DictionaryValueCollectionDebugView`2", (String)reflector.getStringsStream().getString(5801));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"MethodBuilderInstantiation", (String)reflector.getStringsStream().getString(12356));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"SystemRuntimeSerializationFormattersSoap", (String)reflector.getStringsStream().getString(20250));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"System.Collections.IEnumerator.Current", (String)reflector.getStringsStream().getString(36379));
        FacileMscorlibV2_0_31005_0Tests.assertEquals((String)"CreateAdjustmentRuleFromTimeZoneInformation", (String)reflector.getStringsStream().getString(60861));
    }

    public void testBlobStream() {
        byte[] blob1 = new byte[]{21, 18, -127, 112, 1, 19, 0};
        byte[] blob2 = new byte[]{21, 18, -127, -112, 1, 19, 0};
        byte[] blob3 = new byte[]{21, 18, -124, 32, 1, 14};
        byte[] blob4 = new byte[]{16, 1, 0, 30, 0};
        byte[] blob5 = new byte[]{108, 0, 115, 0, 116, 0, 114, 0, 99, 0, 112, 0, 121, 0};
        FacileMscorlibV2_0_31005_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob1, reflector.getBlobStream().getBlob(1)));
        FacileMscorlibV2_0_31005_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob2, reflector.getBlobStream().getBlob(9)));
        FacileMscorlibV2_0_31005_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob3, reflector.getBlobStream().getBlob(308)));
        FacileMscorlibV2_0_31005_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob4, reflector.getBlobStream().getBlob(9908)));
        FacileMscorlibV2_0_31005_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob5, reflector.getBlobStream().getBlob(10555)));
    }
}

