/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.assemblies;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.util.ArrayUtils;
import junit.framework.TestCase;

public class FacileMscorlibV1_0_50_00_0Tests
extends TestCase {
    private static final String PATH_MSCORLIBV1_0_50_00_0 = "assemblies/v1.0.5000.0/mscorlib.dll";
    private static final int NUM_OF_TEST_CASES = 5;
    private static FacileReflector reflector = null;
    private static int testCounter = 0;

    public FacileMscorlibV1_0_50_00_0Tests(String name) {
        super(name);
    }

    protected void setUp() {
        if (testCounter == 0) {
            try {
                reflector = Facile.load(PATH_MSCORLIBV1_0_50_00_0);
            }
            catch (Exception e) {
                FacileMscorlibV1_0_50_00_0Tests.fail();
            }
        }
        ++testCounter;
    }

    protected void tearDown() {
        if (testCounter == 5) {
            reflector = null;
        }
    }

    public void testCliHeader() {
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((long)reflector.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getCliHeader().getMinorRuntimeVersion(), (int)0);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((long)reflector.getCliHeader().getAddrOfMetadataDirectory(), (long)997360L);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((long)reflector.getCliHeader().getSizeOfMetadataDirectory(), (long)1053160L);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((long)reflector.getCliHeader().getFlags(), (long)9L);
    }

    public void testMetadataRootHeader() {
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((long)reflector.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)reflector.getCliMetadataRootHeader().getVersionString(), (String)"v1.1.4322\u0000\u0000\u0000");
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
    }

    public void testStreamSizes() {
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getSizeOfMetadataStream(), (int)612072);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getSizeOfStringsStream(), (int)222680);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getSizeOfUserStringStream(), (int)125432);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((int)reflector.getSizeOfBlobStream(), (int)92848);
    }

    public void testStringsStream() {
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"InternalBlockCopy", (String)reflector.getStringsStream().getString(1));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"SynchronizedClientContextSink", (String)reflector.getStringsStream().getString(4315));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"<PrivateImplementationDetails>", (String)reflector.getStringsStream().getString(1572));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"System.Configuration.Assemblies", (String)reflector.getStringsStream().getString(1717));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"IOUtil", (String)reflector.getStringsStream().getString(3270));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"Context", (String)reflector.getStringsStream().getString(8138));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"File", (String)reflector.getStringsStream().getString(12394));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"SetWin32ContextInIDispatchAttribute", (String)reflector.getStringsStream().getString(14156));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"DESCryptoServiceProvider", (String)reflector.getStringsStream().getString(16838));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"Boolean", (String)reflector.getStringsStream().getString(24783));
        FacileMscorlibV1_0_50_00_0Tests.assertEquals((String)"System.Runtime.InteropServices._Activator.Invoke", (String)reflector.getStringsStream().getString(62754));
    }

    public void testBlobStream() {
        byte[] blob1 = new byte[]{6, 17, -105, 52};
        byte[] blob2 = new byte[]{6, 17, -106, 8};
        byte[] blob3 = new byte[]{0, 2, 14, 14, 18, -126, 92};
        byte[] blob4 = new byte[]{0, 2, 8, 29, 3, 8};
        byte[] blob5 = new byte[]{7, 7, 8, 8, 8, 8, 18, -113, 24, 18, -114, 44, 8};
        FacileMscorlibV1_0_50_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob1, reflector.getBlobStream().getBlob(1)));
        FacileMscorlibV1_0_50_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob2, reflector.getBlobStream().getBlob(6)));
        FacileMscorlibV1_0_50_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob3, reflector.getBlobStream().getBlob(5207)));
        FacileMscorlibV1_0_50_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob4, reflector.getBlobStream().getBlob(40201)));
        FacileMscorlibV1_0_50_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob5, reflector.getBlobStream().getBlob(78882)));
    }
}

