/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.tests.assemblies;

import at.pollaknet.api.facile.Facile;
import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.util.ArrayUtils;
import junit.framework.TestCase;

public class FacileMscorlibV1_0_33_00_0Tests
extends TestCase {
    private static final String PATH_MSCORLIBV1_0_33_00_0 = "assemblies/v1.0.3300.0/mscorlib.dll";
    private static final int NUM_OF_TEST_CASES = 5;
    private static FacileReflector reflector = null;
    private static int testCounter = 0;

    public FacileMscorlibV1_0_33_00_0Tests(String name) {
        super(name);
    }

    protected void setUp() {
        if (testCounter == 0) {
            try {
                reflector = Facile.load(PATH_MSCORLIBV1_0_33_00_0);
            }
            catch (Exception e) {
                FacileMscorlibV1_0_33_00_0Tests.fail();
            }
        }
        ++testCounter;
    }

    protected void tearDown() {
        if (testCounter == 5) {
            reflector = null;
        }
    }

    public void testCliHeader() {
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((long)reflector.getCliHeader().getClrHeaderSize(), (long)72L);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getCliHeader().getMajorRuntimeVersion(), (int)2);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getCliHeader().getMinorRuntimeVersion(), (int)0);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((long)reflector.getCliHeader().getAddrOfMetadataDirectory(), (long)964580L);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((long)reflector.getCliHeader().getSizeOfMetadataDirectory(), (long)1028788L);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((long)reflector.getCliHeader().getFlags(), (long)9L);
    }

    public void testMetadataRootHeader() {
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getSize(), (int)105);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMajorVersion(), (int)1);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getMinorVersion(), (int)1);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((long)reflector.getCliMetadataRootHeader().getExtraDataOffset(), (long)0L);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)reflector.getCliMetadataRootHeader().getVersionString(), (String)"v1.x86ret\u0000\u0000\u0000");
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getFlags(), (int)0);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getCliMetadataRootHeader().getNumberOfStreams(), (int)5);
    }

    public void testStreamSizes() {
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getSizeOfMetadataStream(), (int)600132);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getSizeOfStringsStream(), (int)217096);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getSizeOfUserStringStream(), (int)121524);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getSizeOfGuidStream(), (int)16);
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((int)reflector.getSizeOfBlobStream(), (int)89912);
    }

    public void testStringsStream() {
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"System.IO", (String)reflector.getStringsStream().getString(1));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"FileStream", (String)reflector.getStringsStream().getString(11));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"SuppressUnmanagedCodeSecurityAttribute", (String)reflector.getStringsStream().getString(22));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"Array", (String)reflector.getStringsStream().getString(95));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"CodeAccessSecurityEngine", (String)reflector.getStringsStream().getString(118));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"ObjWait", (String)reflector.getStringsStream().getString(35276));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"bitCount", (String)reflector.getStringsStream().getString(105162));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"Internet", (String)reflector.getStringsStream().getString(140870));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"THRESHOLD_FOR_VALUETYPE_IDS", (String)reflector.getStringsStream().getString(176068));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"System.Runtime.InteropServices._MethodRental.Invoke", (String)reflector.getStringsStream().getString(186154));
        FacileMscorlibV1_0_33_00_0Tests.assertEquals((String)"clsToken", (String)reflector.getStringsStream().getString(216465));
    }

    public void testBlobStream() {
        byte[] blob1 = new byte[]{6, 17, -107, -72};
        byte[] blob2 = new byte[]{0, 1, 14, 14};
        byte[] blob3 = new byte[]{6, 29, 18, -112, 68};
        byte[] blob4 = new byte[]{7, 1, 18, -113, -52};
        byte[] blob5 = new byte[]{7, 7, 29, 18, -125, 8, 8, 29, 18, -123, -24, 18, -116, -8, 18, -116, -84, 18, -125, 8, 18, -125, 8};
        FacileMscorlibV1_0_33_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob1, reflector.getBlobStream().getBlob(1)));
        FacileMscorlibV1_0_33_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob2, reflector.getBlobStream().getBlob(2117)));
        FacileMscorlibV1_0_33_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob3, reflector.getBlobStream().getBlob(7871)));
        FacileMscorlibV1_0_33_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob4, reflector.getBlobStream().getBlob(78116)));
        FacileMscorlibV1_0_33_00_0Tests.assertTrue((boolean)ArrayUtils.arraysAreEqual(blob5, reflector.getBlobStream().getBlob(88082)));
    }
}

