/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab.signature;

import at.pollaknet.api.facile.exception.InvalidSignatureException;
import at.pollaknet.api.facile.metamodel.HasBackupBlobIndex;
import at.pollaknet.api.facile.metamodel.entries.AssemblyRefEntry;
import at.pollaknet.api.facile.metamodel.entries.ParamEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeSpecEntry;
import at.pollaknet.api.facile.symtab.BasicTypesDirectory;
import at.pollaknet.api.facile.symtab.TypeInstance;
import at.pollaknet.api.facile.symtab.TypeKind;
import at.pollaknet.api.facile.symtab.signature.ArrayShape;
import at.pollaknet.api.facile.symtab.signature.MethodDefOrRefSignature;
import at.pollaknet.api.facile.symtab.signature.ParamOrFieldMarshalSignature;
import at.pollaknet.api.facile.symtab.symbols.Field;
import at.pollaknet.api.facile.symtab.symbols.Parameter;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.TypeSpec;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Signature
extends TypeKind {
    public static final int ELEMENT_TYPE_MODIFIER = 64;
    public static final int ELEMENT_TYPE_SENTINEL = 65;
    public static final int ELEMENT_TYPE_PINNED = 69;
    public static final int UNNAMED_SYSTEM_TYPE = 80;
    public static final int UNNAMED_BOXED_OBJECT = 81;
    public static final int UNNAMED_RESERVED = 82;
    public static final int UNNAMED_CSTM_ATRB_FIELD = 83;
    public static final int UNNAMED_CSTM_ATRB_PROPERTY = 84;
    public static final int SERIALIZATION_TYPE_PROPERTY = 84;
    public static final int UNNAMED_CSTM_ATRB_ENUM = 85;
    public static final int PREFIX_CUSTOM_ATTRIBUTE = 1;
    public static final int PREFIX_FIELD = 6;
    public static final int PREFIX_LOCAL_VAR = 7;
    public static final int PREFIX_PROPERTY = 8;
    public static final int PREFIX_GENERIC_INSTANCE = 10;
    public static final int PREFIX_DECL_SECURITY = 46;
    public static final int CODED_TDOR_DEF_TOKEN_ID = 0;
    public static final int CODED_TDOR_REF_TOKEN_ID = 1;
    public static final int CODED_TDOR_SPEC_TOKEN_ID = 2;
    protected byte[] binarySignature;
    protected int currentToken;
    protected int currentIndex = -1;
    protected BasicTypesDirectory directory;
    protected boolean malformedSignature = false;

    protected void nextToken() throws InvalidSignatureException {
        ++this.currentIndex;
        if (this.currentIndex > this.binarySignature.length) {
            throw new InvalidSignatureException("Size of signature exceeded!");
        }
        this.currentToken = this.currentIndex < this.binarySignature.length ? (int)ByteReader.getUInt8(this.binarySignature, this.currentIndex) : -1;
    }

    protected boolean hasNext() {
        return this.currentIndex + 1 < this.binarySignature.length;
    }

    protected void setBinarySignature(byte[] signature) {
        assert (signature != null);
        assert (signature.length != 0);
        this.binarySignature = signature;
    }

    public byte[] getBinarySignature() {
        return this.binarySignature;
    }

    protected void setDirectory(BasicTypesDirectory directory) {
        this.directory = directory;
    }

    protected TypeRefEntry plainType() throws InvalidSignatureException {
        switch (this.currentToken) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 80: {
                int token = this.currentToken;
                this.nextToken();
                return this.directory.getType(token);
            }
        }
        return null;
    }

    protected void type(TypeSpecEntry enclosingType) throws InvalidSignatureException {
        boolean belongsToMethod = false;
        switch (this.currentToken) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: 
            case 24: 
            case 25: 
            case 28: {
                enclosingType.setEnclosedTypeRef(this.directory.getType(this.currentToken));
                this.nextToken();
                break;
            }
            case 15: 
            case 20: 
            case 21: 
            case 27: 
            case 29: {
                this.typeSpecBlob(enclosingType);
                break;
            }
            case 18: {
                this.nextToken();
                enclosingType.setAsClass(true);
                this.typeDefOrRefEncoded(enclosingType);
                break;
            }
            case 17: {
                this.nextToken();
                enclosingType.setAsValueType(true);
                this.typeDefOrRefEncoded(enclosingType);
                break;
            }
            case 30: {
                belongsToMethod = true;
            }
            case 19: {
                this.nextToken();
                int genericNumber = this.decodeIntegerInSignature();
                assert (genericNumber >= 0);
                enclosingType.setAsGenericParameter(genericNumber, belongsToMethod);
                break;
            }
            case 85: {
                this.nextToken();
                String fullQualifiedName = this.readSerString();
                this.setNameAndSpace(enclosingType, fullQualifiedName);
                int kind = BasicTypesDirectory.findSuperTypeKind(enclosingType);
                if (kind == 0) {
                    kind = 85;
                }
                enclosingType.setElementKind(kind);
                break;
            }
            case 80: {
                this.nextToken();
                enclosingType.setElementKind(80);
                break;
            }
            case 81: {
                TypeSpecEntry typeSpec = new TypeSpecEntry();
                this.nextToken();
                enclosingType.setAsBoxed(true);
                enclosingType.setElementKind(28);
                this.type(typeSpec);
                this.directory.registerEmbeddedTypeSpec(typeSpec);
                enclosingType.setEnclosedTypeRef(typeSpec);
                break;
            }
            default: {
                throw new InvalidSignatureException(this.currentToken);
            }
        }
    }

    protected void setNameAndSpace(TypeSpecEntry enclosingType, String fullQualifiedName) {
        StringTokenizer tokenizer = new StringTokenizer(fullQualifiedName, ", ");
        int index = 0;
        String assembly = null;
        String version = null;
        String culture = null;
        String publicKey = null;
        while (tokenizer.hasMoreTokens()) {
            String currentPart = tokenizer.nextToken();
            switch (index) {
                case 0: {
                    int dotPosition = currentPart.lastIndexOf(46);
                    enclosingType.setName(dotPosition < 0 ? currentPart : currentPart.substring(dotPosition + 1));
                    enclosingType.setNamespace(dotPosition < 0 ? "" : currentPart.substring(0, dotPosition));
                    break;
                }
                case 1: {
                    assembly = currentPart;
                    break;
                }
                case 2: {
                    if (currentPart == null) break;
                    version = currentPart.substring(currentPart.indexOf(61) + 1);
                    break;
                }
                case 3: {
                    if (currentPart == null) break;
                    culture = currentPart.substring(currentPart.indexOf(61) + 1);
                    break;
                }
                case 4: {
                    if (currentPart != null) {
                        publicKey = currentPart.substring(currentPart.indexOf(61) + 1);
                    }
                    AssemblyRefEntry dummyAssembly = Signature.setExtractedAssemblyData(fullQualifiedName, assembly, version, culture, publicKey);
                    enclosingType.setResolutionScope(dummyAssembly);
                    break;
                }
            }
            ++index;
        }
    }

    private static AssemblyRefEntry setExtractedAssemblyData(String fullQualifiedName, String assembly, String version, String culture, String publicKey) {
        AssemblyRefEntry dummyAssembly = new AssemblyRefEntry();
        dummyAssembly.setName(assembly);
        if (version != null) {
            int indexInVersionString = 0;
            StringTokenizer numberTokenizer = new StringTokenizer(version, ".");
            while (numberTokenizer.hasMoreTokens()) {
                String number = numberTokenizer.nextToken();
                try {
                    switch (indexInVersionString) {
                        case 0: {
                            dummyAssembly.setMajorVersion(Integer.parseInt(number));
                            break;
                        }
                        case 1: {
                            dummyAssembly.setMinorVersion(Integer.parseInt(number));
                            break;
                        }
                        case 2: {
                            dummyAssembly.setBuildNumber(Integer.parseInt(number));
                            break;
                        }
                        default: {
                            dummyAssembly.setRevisionNumber(Integer.parseInt(number));
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    Logger logger = Logger.getLogger("at.pollaknet.api.facile");
                    String buffer = "Unable to convert element " + indexInVersionString + " of version string [" + version + "] of " + fullQualifiedName + ".";
                    logger.log(Level.WARNING, buffer);
                }
                ++indexInVersionString;
            }
        }
        dummyAssembly.setCulture(culture);
        if (publicKey != null) {
            dummyAssembly.setPublicKey(publicKey.getBytes());
        }
        return dummyAssembly;
    }

    protected int decode4ByteNullableIntegerInSignature() throws InvalidSignatureException {
        int value = ByteReader.decodeSignatureElement(this.binarySignature, this.currentIndex);
        int length = value < 0 ? 4 : ByteReader.getSizeOfSignatureElement(value);
        this.skipTokens(length);
        return value;
    }

    protected int decodeNullableIntegerInSignature() throws InvalidSignatureException {
        int value = ByteReader.decodeSignatureElement(this.binarySignature, this.currentIndex);
        int length = ByteReader.getSizeOfSignatureElement(value);
        this.skipTokens(length);
        return value;
    }

    protected int decodeIntegerInSignature() throws InvalidSignatureException {
        int value = ByteReader.decodeSignatureElement(this.binarySignature, this.currentIndex);
        int length = ByteReader.getSizeOfSignatureElement(value);
        if (length < 0) {
            throw new InvalidSignatureException(this.currentToken);
        }
        this.skipTokens(length);
        return value;
    }

    protected void skipTokens(int numberOfTokens) throws InvalidSignatureException {
        for (int count = 0; count < numberOfTokens; ++count) {
            this.nextToken();
        }
    }

    private void arrayShape(TypeSpecEntry enclosingType) throws InvalidSignatureException {
        int rank = this.decodeIntegerInSignature();
        int[] sizes = new int[this.decodeIntegerInSignature()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = this.decodeIntegerInSignature();
        }
        int[] lowerBounds = new int[this.decodeIntegerInSignature()];
        for (int i = 0; i < lowerBounds.length; ++i) {
            lowerBounds[i] = this.decodeIntegerInSignature();
        }
        enclosingType.setArrayShape(new ArrayShape(rank, sizes, lowerBounds));
    }

    protected void typeDefOrRefEncoded(TypeSpecEntry enclosedType) throws InvalidSignatureException {
        int token = this.decodeIntegerInSignature();
        int index = (token >> 2) - 1;
        switch (token & 3) {
            case 0: {
                enclosedType.setEnclosedTypeRef(this.directory.getTypeDefs()[index]);
                break;
            }
            case 1: {
                enclosedType.setEnclosedTypeRef(this.directory.getTypeRefs()[index]);
                break;
            }
            case 2: {
                enclosedType.setEnclosedTypeRef(this.directory.getTypeSpecs()[index]);
                break;
            }
            default: {
                throw new InvalidSignatureException(this.currentToken);
            }
        }
    }

    protected TypeRefEntry returnType() throws InvalidSignatureException {
        boolean isPlainType;
        TypeSpecEntry returnType = new TypeSpecEntry();
        TypeRefEntry plainType = null;
        boolean bl = isPlainType = !this.customModifiers(returnType);
        if (isPlainType) {
            plainType = this.plainType();
        }
        if (plainType != null) {
            return plainType;
        }
        this.type(returnType);
        this.directory.registerEmbeddedTypeSpec(returnType);
        return returnType;
    }

    protected void returnType(ParamEntry paramEntry) {
        boolean isPlainType;
        TypeSpecEntry returnType = new TypeSpecEntry();
        TypeRefEntry plainType = null;
        boolean bl = isPlainType = !this.customModifiers(returnType);
        if (isPlainType) {
            plainType = this.plainType();
        }
        if (plainType != null) {
            returnType.setEnclosedTypeRef(plainType);
            paramEntry.setTypeRef(returnType);
        } else {
            this.type(returnType);
            this.directory.registerEmbeddedTypeSpec(returnType);
            paramEntry.setTypeRef(returnType);
        }
    }

    protected boolean customModifiers(TypeSpecEntry typeSpec) throws InvalidSignatureException {
        boolean hasModifiers = false;
        while (this.currentToken == 32 || this.currentToken == 31 || this.currentToken == 16 || this.currentToken == 69) {
            hasModifiers = true;
            TypeSpecEntry optionalOrReqType = new TypeSpecEntry();
            if (this.currentToken == 16) {
                this.nextToken();
                typeSpec.setTypeByRef(true);
                continue;
            }
            if (this.currentToken == 69) {
                this.nextToken();
                typeSpec.setAsPinned(true);
                continue;
            }
            if (this.currentToken == 32) {
                this.nextToken();
                this.typeDefOrRefEncoded(optionalOrReqType);
                typeSpec.addOptionalModifier(optionalOrReqType);
                this.directory.registerEmbeddedTypeSpec(optionalOrReqType);
                continue;
            }
            this.nextToken();
            this.typeDefOrRefEncoded(optionalOrReqType);
            typeSpec.addRequiredModifier(optionalOrReqType);
            this.directory.registerEmbeddedTypeSpec(optionalOrReqType);
        }
        return hasModifiers;
    }

    protected void typeSpecBlob(TypeSpecEntry enclosingType) throws InvalidSignatureException {
        switch (this.currentToken) {
            case 20: {
                this.nextToken();
                enclosingType.setGeneralArray(true);
                TypeSpecEntry typeSpec = new TypeSpecEntry();
                this.type(typeSpec);
                this.directory.registerEmbeddedTypeSpec(typeSpec);
                enclosingType.setEnclosedTypeRef(typeSpec);
                this.arrayShape(enclosingType);
                break;
            }
            case 29: {
                this.nextToken();
                enclosingType.setSingleDimensionalZeroBasedArray(true);
                this.customModifiers(enclosingType);
                TypeSpecEntry typeSpec = new TypeSpecEntry();
                this.type(typeSpec);
                this.directory.registerEmbeddedTypeSpec(typeSpec);
                enclosingType.setEnclosedTypeRef(typeSpec);
                break;
            }
            case 15: {
                this.nextToken();
                enclosingType.incPointer();
                this.customModifiers(enclosingType);
                this.type(enclosingType);
                break;
            }
            case 27: {
                this.nextToken();
                enclosingType.setAsFunctionPointer(true);
                MethodDefOrRefSignature function = MethodDefOrRefSignature.decode(this.directory, this.binarySignature, this.currentIndex);
                enclosingType.setFunctionPointer(function);
                this.skipTokens(function.getBinarySignature().length);
                break;
            }
            case 21: {
                this.nextToken();
                enclosingType.setAsGenericInstance(true);
                if (this.currentToken == 18) {
                    enclosingType.setAsClass(true);
                } else if (this.currentToken == 17) {
                    enclosingType.setAsValueType(true);
                } else {
                    throw new InvalidSignatureException(this.currentToken);
                }
                this.nextToken();
                this.typeDefOrRefEncoded(enclosingType);
                enclosingType.setGenericArguments(this.typeArray(null));
                break;
            }
            default: {
                throw new InvalidSignatureException(this.currentToken);
            }
        }
    }

    protected TypeRefEntry[] typeArray(Parameter[] genericParameters) {
        int count = this.decodeIntegerInSignature();
        TypeRefEntry[] genericTypes = new TypeRefEntry[count];
        for (int i = 0; i < count; ++i) {
            genericTypes[i] = this.plainType();
            if (genericTypes[i] == null) {
                TypeSpecEntry typeSpec = new TypeSpecEntry();
                this.customModifiers(typeSpec);
                this.type(typeSpec);
                genericTypes[i] = typeSpec;
                this.directory.registerEmbeddedTypeSpec(typeSpec);
            }
            if (genericTypes[i].getName() != null || genericParameters == null || genericParameters.length <= i) continue;
            genericTypes[i].setName(genericParameters[i].getName());
        }
        return genericTypes;
    }

    protected int params(ParamEntry[] parameter, boolean skipFirst) throws InvalidSignatureException {
        int index;
        int sentinelPosition = -1;
        if (parameter == null) {
            return sentinelPosition;
        }
        int n = index = skipFirst ? 1 : 0;
        while (index < parameter.length) {
            if (parameter[index] == null) {
                parameter[index] = new ParamEntry();
            } else {
                ParamOrFieldMarshalSignature.decodeAndAttach(this.directory, parameter[index]);
            }
            if (this.currentToken == 65) {
                this.nextToken();
                sentinelPosition = index;
            }
            this.param(parameter[index]);
            ++index;
        }
        return sentinelPosition;
    }

    protected void param(ParamEntry paramEntry) throws InvalidSignatureException {
        boolean isPlainType;
        assert (paramEntry != null);
        TypeSpecEntry enclosingType = new TypeSpecEntry();
        TypeRefEntry plainType = null;
        boolean bl = isPlainType = !this.customModifiers(enclosingType);
        if (this.currentToken == 16) {
            this.nextToken();
            enclosingType.setTypeByRef(true);
            isPlainType = false;
        }
        if (isPlainType) {
            plainType = this.plainType();
        }
        if (plainType != null) {
            enclosingType.setEnclosedTypeRef(plainType);
            paramEntry.setTypeRef(enclosingType);
        } else {
            this.type(enclosingType);
            paramEntry.setTypeRef(enclosingType);
            this.directory.registerEmbeddedTypeSpec(enclosingType);
        }
    }

    protected TypeInstance fixedArgument(HasBackupBlobIndex customAttribute, TypeRef typeRef) throws InvalidSignatureException {
        int kind;
        TypeSpec spec = typeRef.getTypeSpec();
        int backupIndex = customAttribute.getBinaryBlobIndex();
        if (spec != null) {
            if (spec.isSingleDimensionalZeroBasedArray()) {
                return this.typeInstanceArray(customAttribute, spec, backupIndex);
            }
            if (spec.getEnclosedTypeRef() != null) {
                if (spec.isBoxed()) {
                    return new TypeInstance((TypeRef)spec, this.fixedArgument(customAttribute, spec.getEnclosedTypeRef()));
                }
                return this.fixedArgument(customAttribute, spec.getEnclosedTypeRef());
            }
        }
        if ((kind = typeRef.getElementTypeKind()) == 0) {
            kind = BasicTypesDirectory.findSuperTypeKind(typeRef);
        }
        switch (kind) {
            case 0: {
                Logger logger = Logger.getLogger("at.pollaknet.api.facile");
                logger.log(Level.WARNING, "Found a fixed Argument without a type kind specification, typeRef: " + typeRef);
                return new TypeInstance(typeRef, this.readNumericValue(backupIndex, 85, typeRef));
            }
            case 1: {
                return new TypeInstance(typeRef, (TypeInstance)null);
            }
            case 14: 
            case 80: {
                return new TypeInstance(typeRef, this.readSerString(backupIndex));
            }
            case 29: {
                int length = ArrayUtils.findInByteArray(this.binarySignature, this.currentIndex, (byte)0);
                String value = null;
                try {
                    value = new String(this.binarySignature, this.currentIndex, length, "UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    value = "Undecoadeable UTF8 identifier in signature";
                }
                return new TypeInstance(typeRef, value);
            }
            case 28: 
            case 81: {
                if (this.currentToken == 29) {
                    this.nextToken();
                    TypeRefEntry type = null;
                    if (this.currentToken == 81) {
                        type = this.directory.getType(28);
                        this.nextToken();
                    } else {
                        type = this.filedOrPropertyType();
                    }
                    assert (type != null);
                    return this.typeInstanceArray(customAttribute, type, backupIndex);
                }
                TypeRefEntry boxedTypeRef = this.filedOrPropertyType();
                return new TypeInstance(typeRef, this.fixedArgument(customAttribute, boxedTypeRef));
            }
            case 12: {
                this.ensureSignatureLength(backupIndex, 4);
                Float value = Float.valueOf(Float.intBitsToFloat(ByteReader.getInt32(this.binarySignature, this.currentIndex)));
                this.skipTokens(4);
                return new TypeInstance(typeRef, value.toString());
            }
            case 11: {
                this.ensureSignatureLength(backupIndex, 8);
                long value = ByteReader.getUInt64(this.binarySignature, this.currentIndex);
                this.skipTokens(8);
                return new TypeInstance(typeRef, String.format("0x%x", value));
            }
            case 13: {
                this.ensureSignatureLength(backupIndex, 8);
                Double value = Double.longBitsToDouble(ByteReader.getInt64(this.binarySignature, this.currentIndex));
                this.skipTokens(8);
                return new TypeInstance(typeRef, value.toString());
            }
        }
        return new TypeInstance(typeRef, this.readNumericValue(backupIndex, kind, typeRef));
    }

    private TypeInstance typeInstanceArray(HasBackupBlobIndex customAttribute, TypeRef typeRef, int backupIndex) {
        TypeSpec typeSpec = typeRef.getTypeSpec();
        this.ensureSignatureLength(backupIndex, 4);
        long arrayLength = ByteReader.getInt32(this.binarySignature, this.currentIndex);
        this.skipTokens(4);
        if (arrayLength == -1L) {
            return TypeInstance.CreateArrayInstnace(typeRef, 0);
        }
        assert (arrayLength <= Integer.MAX_VALUE);
        TypeInstance arrayInstance = TypeInstance.CreateArrayInstnace(typeRef, (int)arrayLength);
        if (typeSpec == null) {
            int i = 0;
            while ((long)i < arrayLength) {
                arrayInstance.getArrayInstance()[i] = this.fixedArgument(customAttribute, typeRef);
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < arrayLength) {
                arrayInstance.getArrayInstance()[i] = this.fixedArgument(customAttribute, typeSpec.getEnclosedTypeRef());
                ++i;
            }
        }
        return arrayInstance;
    }

    protected String readSerString(int backupBlobIndex) throws InvalidSignatureException {
        int length = this.decodeNullableIntegerInSignature();
        if (length < 0) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        return this.readString(backupBlobIndex, length);
    }

    protected String readString(int backupBlobIndex, int length) {
        String value;
        if (length >= 0) {
            this.ensureSignatureLength(backupBlobIndex, length);
        }
        try {
            value = new String(this.binarySignature, this.currentIndex, length, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            value = "Undecodeable UTF8 identifier in signature";
        }
        this.skipTokens(length);
        return value;
    }

    protected String readSerString() throws InvalidSignatureException {
        return this.readSerString(-1);
    }

    protected void ensureSignatureLength(int backupBlobIndex, int requiredAdditionalLength) {
        int iteration = 1;
        while (this.currentIndex + requiredAdditionalLength > this.binarySignature.length) {
            byte[] extensionblob = this.directory.getBlob(backupBlobIndex + this.binarySignature.length + iteration);
            assert (extensionblob != null);
            byte[] newSignature = new byte[this.binarySignature.length + extensionblob.length];
            System.arraycopy(this.binarySignature, 0, newSignature, 0, this.binarySignature.length);
            System.arraycopy(extensionblob, 0, newSignature, this.binarySignature.length, extensionblob.length);
            this.binarySignature = newSignature;
            ++iteration;
            this.malformedSignature = true;
        }
        if (this.malformedSignature) {
            Logger logger = Logger.getLogger("at.pollaknet.api.facile");
            logger.log(Level.WARNING, "Detected a malformed custom attribute signature. Correction has been applied.");
        }
    }

    protected long readNumericValue(int backupBlobIndex, int fixedTypeRefKind, TypeRef typeRef) throws InvalidSignatureException {
        int index = this.currentIndex;
        switch (fixedTypeRefKind) {
            case 4: {
                this.ensureSignatureLength(backupBlobIndex, 1);
                this.skipTokens(1);
                return ByteReader.getInt8(this.binarySignature, index);
            }
            case 2: 
            case 5: {
                this.ensureSignatureLength(backupBlobIndex, 1);
                this.skipTokens(1);
                return ByteReader.getUInt8(this.binarySignature, index);
            }
            case 6: {
                this.ensureSignatureLength(backupBlobIndex, 2);
                this.skipTokens(2);
                return ByteReader.getInt16(this.binarySignature, index);
            }
            case 3: 
            case 7: {
                this.ensureSignatureLength(backupBlobIndex, 2);
                this.skipTokens(2);
                return ByteReader.getUInt16(this.binarySignature, index);
            }
            case 8: {
                this.ensureSignatureLength(backupBlobIndex, 4);
                this.skipTokens(4);
                return ByteReader.getInt32(this.binarySignature, index);
            }
            case 9: {
                this.ensureSignatureLength(backupBlobIndex, 4);
                this.skipTokens(4);
                return ByteReader.getUInt32(this.binarySignature, index);
            }
            case 10: {
                this.ensureSignatureLength(backupBlobIndex, 8);
                this.skipTokens(8);
                return ByteReader.getInt64(this.binarySignature, index);
            }
            case 85: {
                if (typeRef != null) {
                    if (typeRef.getType() != null) {
                        int estimatedSize = this.estimateEnumSizeFromTypeFields(backupBlobIndex, typeRef.getType());
                        if (estimatedSize != 0) {
                            return this.readEnum(backupBlobIndex, index, estimatedSize);
                        }
                    } else {
                        for (String fullQualifiedEnumName : this.directory.getReferenceEnums().keySet()) {
                            if (!typeRef.getFullQualifiedName().equals(fullQualifiedEnumName)) continue;
                            return this.readEnum(backupBlobIndex, index, this.directory.getReferenceEnums().get(fullQualifiedEnumName).byteValue());
                        }
                        for (Assembly assembly : this.directory.getReferenceAssemblies()) {
                            for (Type type : assembly.getAllTypes()) {
                                int estimatedSize;
                                if (type.getName() == null || !type.getFullQualifiedName().equals(typeRef.getFullQualifiedName()) || (estimatedSize = this.estimateEnumSizeFromTypeFields(backupBlobIndex, type)) == 0) continue;
                                return this.readEnum(backupBlobIndex, index, estimatedSize);
                            }
                        }
                    }
                }
                return this.readEnum(backupBlobIndex, index, 4);
            }
        }
        assert (false) : "found unknown type while reading a numerical value";
        return 0L;
    }

    protected int estimateEnumSizeFromTypeFields(int backupBlobIndex, Type type) {
        Field[] fields;
        if (type == null || type.getFields() == null) {
            return 0;
        }
        for (Field f : fields = type.getFields()) {
            int estimatedSize;
            if (f.getConstant() == null || f.getConstant().getValue() == null || !this.estimatedEnumSizeIsValid(estimatedSize = f.getConstant().getValue().length)) continue;
            return estimatedSize;
        }
        return 0;
    }

    protected boolean estimatedEnumSizeIsValid(int estimatedSize) {
        switch (estimatedSize) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected long readEnum(int backupBlobIndex, int index, int byteSize) {
        switch (byteSize) {
            case 1: {
                this.ensureSignatureLength(backupBlobIndex, 1);
                this.skipTokens(1);
                return ByteReader.getUInt8(this.binarySignature, index);
            }
            case 2: {
                this.ensureSignatureLength(backupBlobIndex, 2);
                this.skipTokens(2);
                return ByteReader.getUInt16(this.binarySignature, index);
            }
            default: {
                this.ensureSignatureLength(backupBlobIndex, 4);
                this.skipTokens(4);
                return ByteReader.getUInt32(this.binarySignature, index);
            }
            case 8: 
        }
        this.ensureSignatureLength(backupBlobIndex, 8);
        this.skipTokens(8);
        return ByteReader.getInt64(this.binarySignature, index);
    }

    protected TypeRefEntry filedOrPropertyType() throws InvalidSignatureException {
        TypeRefEntry plainType = this.plainType();
        if (plainType != null) {
            return plainType;
        }
        TypeSpecEntry typeSpec = new TypeSpecEntry();
        this.type(typeSpec);
        this.directory.registerEmbeddedTypeSpec(typeSpec);
        return typeSpec;
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.binarySignature);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Arrays.equals(this.binarySignature, other.binarySignature);
    }
}

