/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab.signature;

import at.pollaknet.api.facile.exception.InvalidSignatureException;
import at.pollaknet.api.facile.metamodel.entries.ParamEntry;
import at.pollaknet.api.facile.metamodel.entries.PropertyEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeSpecEntry;
import at.pollaknet.api.facile.symtab.BasicTypesDirectory;
import at.pollaknet.api.facile.symtab.signature.Signature;
import at.pollaknet.api.facile.symtab.symbols.PropertySignature;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.Arrays;

public class PropertyEntrySignature
extends Signature
implements PropertySignature {
    private boolean hasThis;
    private ParamEntry[] parameter;
    private TypeRefEntry typeRef;
    private int parameterCount;

    public static PropertyEntrySignature decodeAndAttach(BasicTypesDirectory directory, PropertyEntry property) throws InvalidSignatureException {
        return new PropertyEntrySignature(directory, property);
    }

    public PropertyEntrySignature(BasicTypesDirectory directory, PropertyEntry property) throws InvalidSignatureException {
        this.setBinarySignature(property.getTypeSignature());
        this.setDirectory(directory);
        this.nextToken();
        this.hasThis = ByteReader.testFlags(this.currentToken, 32);
        if (!ByteReader.testFlags(this.currentToken, 8)) {
            throw new InvalidSignatureException(this.currentToken);
        }
        this.nextToken();
        this.parameterCount = this.decodeIntegerInSignature();
        TypeSpecEntry typeSpec = new TypeSpecEntry();
        if (!this.customModifiers(typeSpec)) {
            this.typeRef = this.plainType();
        }
        if (this.typeRef == null) {
            this.type(typeSpec);
            directory.registerEmbeddedTypeSpec(typeSpec);
            this.typeRef = typeSpec;
        }
        this.parameter = new ParamEntry[this.parameterCount];
        this.params(this.parameter, false);
        property.addPropertySignature(this);
    }

    @Override
    public boolean hasThis() {
        return this.hasThis;
    }

    public ParamEntry[] getParameters() {
        if (this.parameter == null) {
            return new ParamEntry[0];
        }
        return this.parameter;
    }

    @Override
    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(32);
        if (this.parameter != null && this.parameter.length > 0) {
            buffer.append("(");
            for (int i = 0; i < this.parameter.length; ++i) {
                if (this.parameter[i] == null || this.parameter[i].getTypeRef() == null) continue;
                if (i != 0) {
                    buffer.append(", ");
                }
                if (this.parameter[i].getTypeRef().getShortSystemName() != null) {
                    buffer.append(this.parameter[i].getTypeRef().getShortSystemName());
                } else {
                    buffer.append(this.parameter[i].getTypeRef().getFullQualifiedName());
                }
                buffer.append(" ");
                buffer.append(this.parameter[i].getName());
            }
            buffer.append(") : ");
        } else {
            buffer.append(" : ");
        }
        if (this.typeRef.getShortSystemName() != null) {
            buffer.append(this.typeRef.getShortSystemName());
        } else {
            buffer.append(this.typeRef.getFullQualifiedName());
        }
        return buffer.toString();
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31;
        result = 31 * result + (this.hasThis ? 1231 : 1237);
        result = 31 * result + this.parameterCount;
        result = 31 * result + (this.typeRef == null ? 0 : this.typeRef.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyEntrySignature other = (PropertyEntrySignature)obj;
        if (this.hasThis != other.hasThis) {
            return false;
        }
        if (!Arrays.equals(this.parameter, other.parameter)) {
            return false;
        }
        if (this.parameterCount != other.parameterCount) {
            return false;
        }
        return !(this.typeRef == null ? other.typeRef != null : !this.typeRef.equals(other.typeRef));
    }
}

