/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab.signature;

import at.pollaknet.api.facile.symtab.symbols.FullQualifiableSymbol;
import at.pollaknet.api.facile.symtab.symbols.Instance;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.Pair;
import java.util.Arrays;

public class Permission
implements FullQualifiableSymbol {
    private String fullQualifiedName;
    private Pair<String, Instance>[] properties;

    Permission(String fullQualifiedName, Pair<String, Instance>[] properties) {
        this.fullQualifiedName = fullQualifiedName;
        this.properties = properties;
    }

    @Override
    public String getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    @Override
    public String getName() {
        assert (this.fullQualifiedName != null);
        int index = this.fullQualifiedName.lastIndexOf(".");
        if (index > 0) {
            return this.fullQualifiedName.substring(index + 1);
        }
        return this.fullQualifiedName;
    }

    @Override
    public String getNamespace() {
        assert (this.fullQualifiedName != null);
        int index = this.fullQualifiedName.lastIndexOf(".");
        if (index > 0) {
            return this.fullQualifiedName.substring(0, index - 1);
        }
        return null;
    }

    public Pair<String, Instance>[] getProperties() {
        if (this.properties == null) {
            return new Pair[0];
        }
        return this.properties;
    }

    @Override
    public String getShortSystemName() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.fullQualifiedName);
        buffer.append("(");
        boolean hasEntries = false;
        for (Pair<String, Instance> pair : this.properties) {
            if (hasEntries) {
                buffer.append(", ");
            }
            buffer.append((String)pair.key);
            buffer.append(" = ");
            buffer.append(pair.value);
            hasEntries = true;
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.fullQualifiedName == null ? 0 : this.fullQualifiedName.hashCode());
        return 31 * result + Arrays.hashCode(this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permission other = (Permission)obj;
        if (this.fullQualifiedName == null ? other.fullQualifiedName != null : !this.fullQualifiedName.equals(other.fullQualifiedName)) {
            return false;
        }
        if (this.properties == null) {
            return other.properties == null;
        }
        if (other.properties == null) {
            return false;
        }
        if (this.properties.length != other.properties.length) {
            return false;
        }
        for (int i = 0; i < this.properties.length; ++i) {
            if (!ArrayUtils.stringsAreEqualN((String)this.properties[i].key, (String)other.properties[i].key)) {
                return false;
            }
            if (!(this.properties[i].value == null ? other.properties[i].value != null : !((Instance)this.properties[i].value).equals(other.properties[i].value))) continue;
            return false;
        }
        return true;
    }
}

