/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab.signature;

import at.pollaknet.api.facile.exception.InvalidSignatureException;
import at.pollaknet.api.facile.metamodel.entries.FieldEntry;
import at.pollaknet.api.facile.metamodel.entries.ParamEntry;
import at.pollaknet.api.facile.symtab.BasicTypesDirectory;
import at.pollaknet.api.facile.symtab.signature.Signature;
import at.pollaknet.api.facile.symtab.symbols.MarshalSignature;

public class ParamOrFieldMarshalSignature
extends Signature
implements MarshalSignature {
    private int numberOfArrayElements = -1;
    private String marshalerClassName = null;
    private String marshalerCookie = null;
    private int sizeParameterNumber = -1;

    public static ParamOrFieldMarshalSignature decodeAndAttach(BasicTypesDirectory directory, ParamEntry param) throws InvalidSignatureException {
        if (param.getBinaryMarshalTypeSignature() != null) {
            return new ParamOrFieldMarshalSignature(directory, param);
        }
        return null;
    }

    private ParamOrFieldMarshalSignature(BasicTypesDirectory directory, ParamEntry param) throws InvalidSignatureException {
        this.processSignature(directory, param.getBinaryMarshalTypeSignature());
        param.setMarshalSignature(this);
    }

    public static ParamOrFieldMarshalSignature decodeAndAttach(BasicTypesDirectory directory, FieldEntry field) throws InvalidSignatureException {
        if (field.getBinaryMarshalTypeSignature() != null) {
            return new ParamOrFieldMarshalSignature(directory, field);
        }
        return null;
    }

    private ParamOrFieldMarshalSignature(BasicTypesDirectory directory, FieldEntry field) throws InvalidSignatureException {
        this.processSignature(directory, field.getBinaryMarshalTypeSignature());
        field.setMarshalSignature(this);
    }

    private void processSignature(BasicTypesDirectory directory, byte[] signature) {
        this.setBinarySignature(signature);
        this.setDirectory(directory);
        this.nextToken();
        if (!this.nativeType()) {
            throw new InvalidSignatureException(this.currentToken);
        }
    }

    @Override
    public int getNativeType() {
        return this.binarySignature[0];
    }

    @Override
    public int getArrayElementsNativeType() {
        int i = 0;
        while (this.binarySignature[i] == 42) {
            ++i;
        }
        if (i == 0) {
            return -1;
        }
        return this.binarySignature[1];
    }

    @Override
    public boolean isArray() {
        switch (this.getNativeType()) {
            case 23: 
            case 30: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    public int[] getVariantType() {
        int i = 0;
        while (this.binarySignature[i] == 42) {
            ++i;
        }
        if (this.binarySignature[i] != 29) {
            return null;
        }
        this.currentIndex = i - 1;
        this.nextToken();
        int variant = this.decodeIntegerInSignature();
        if (variant < 0) {
            return null;
        }
        int[] variantArray = new int[1];
        int currentIndex = 0;
        variantArray[currentIndex] = variant;
        while ((variant == 4096 || variant == 8192 || variant == 16384) && this.hasNext()) {
            if (variantArray.length <= ++currentIndex) {
                int[] resizedArray = new int[variantArray.length + 1];
                System.arraycopy(variantArray, 0, resizedArray, 0, variantArray.length);
                variantArray = resizedArray;
            }
            variantArray[currentIndex] = variant = this.decodeIntegerInSignature();
        }
        return variantArray;
    }

    public boolean nativeType() {
        switch (this.currentToken) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                this.nextToken();
                break;
            }
            case 46: 
            case 47: {
                this.nextToken();
                break;
            }
            case 29: {
                this.nextToken();
                break;
            }
            case 23: 
            case 30: {
                this.nextToken();
                this.numberOfArrayElements = this.decodeIntegerInSignature();
                break;
            }
            case 42: {
                this.nextToken();
                boolean detectedType = this.nativeType();
                if (!detectedType) {
                    this.nextToken();
                }
                if (this.hasNext()) {
                    this.numberOfArrayElements = this.decodeIntegerInSignature();
                    if (this.numberOfArrayElements != 0) break;
                    if (this.hasNext()) {
                        this.sizeParameterNumber = this.decodeIntegerInSignature();
                        break;
                    }
                    this.sizeParameterNumber = 0;
                    break;
                }
                this.sizeParameterNumber = 0;
                break;
            }
            case 44: {
                this.nextToken();
                this.marshalerClassName = this.readSerString();
                this.marshalerCookie = this.readSerString();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        this.currentIndex = -1;
        this.nextToken();
        return this.formatType();
    }

    private String formatType() {
        switch (this.currentToken) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 43: 
            case 45: {
                return this.nativeToString(this.currentToken);
            }
            case 29: {
                return this.nativeToString(this.currentToken) + " " + this.variantToString(this.getVariantType());
            }
            case 23: 
            case 30: {
                return this.nativeToString(this.currentToken) + " " + this.numberOfArrayElements;
            }
            case 42: {
                this.nextToken();
                return this.formatType() + this.formatArrayParameter();
            }
            case 44: {
                return this.nativeToString(this.currentToken) + " \"" + this.marshalerClassName + "\", \"" + this.marshalerCookie + "\"";
            }
        }
        return "";
    }

    public String nativeToString(int nativeType) {
        switch (nativeType) {
            case 1: {
                return "void";
            }
            case 2: {
                return "bool";
            }
            case 3: {
                return "int8";
            }
            case 4: {
                return "unsigned int8";
            }
            case 5: {
                return "int16";
            }
            case 6: {
                return "unsigned int16";
            }
            case 7: {
                return "int32";
            }
            case 8: {
                return "unsigned int32";
            }
            case 9: {
                return "int64";
            }
            case 10: {
                return "unsigned int64";
            }
            case 11: {
                return "float";
            }
            case 12: {
                return "double";
            }
            case 13: {
                return "syschar";
            }
            case 14: {
                return "variant";
            }
            case 15: {
                return "currency";
            }
            case 16: {
                return "*";
            }
            case 17: {
                return "decimal";
            }
            case 18: {
                return "date";
            }
            case 19: {
                return "bstr";
            }
            case 20: {
                return "lpstr";
            }
            case 21: {
                return "lpwstr";
            }
            case 22: {
                return "lptstr";
            }
            case 23: {
                return "fixed systring";
            }
            case 24: {
                return "objectref";
            }
            case 25: {
                return "iunknown";
            }
            case 26: {
                return "idispatch";
            }
            case 27: {
                return "struct";
            }
            case 28: {
                return "interface";
            }
            case 29: {
                return "safearray";
            }
            case 30: {
                return "fixed array";
            }
            case 31: {
                return "int";
            }
            case 32: {
                return "unsigned int";
            }
            case 33: {
                return "nested struct";
            }
            case 34: {
                return "byvalstr";
            }
            case 35: {
                return "ansi bstr";
            }
            case 36: {
                return "tbstr";
            }
            case 37: {
                return "variant bool";
            }
            case 38: {
                return "method";
            }
            case 40: {
                return "as any";
            }
            case 43: {
                return "lpstruct";
            }
            case 44: {
                return "custom";
            }
            case 45: {
                return "error";
            }
            case 42: {
                return "array";
            }
        }
        return String.format("unknown_native_0x%x", nativeType);
    }

    @Override
    public String variantToString(int variant) {
        return this.variantToString(new int[]{variant});
    }

    @Override
    public String variantToString(int[] variant) {
        return this.variantToString(variant, 0);
    }

    private String variantToString(int[] variant, int index) {
        if (index >= variant.length) {
            return "";
        }
        switch (variant[index]) {
            case 0: {
                return "";
            }
            case 1: {
                return "null";
            }
            case 2: {
                return "int16";
            }
            case 3: {
                return "int32";
            }
            case 4: {
                return "float32";
            }
            case 5: {
                return "float64";
            }
            case 6: {
                return "currency";
            }
            case 7: {
                return "date";
            }
            case 8: {
                return "bstr";
            }
            case 9: {
                return "idispatch";
            }
            case 10: {
                return "error";
            }
            case 11: {
                return "bool";
            }
            case 12: {
                return "variant";
            }
            case 13: {
                return "iunknown";
            }
            case 14: {
                return "decimal";
            }
            case 16: {
                return "int8";
            }
            case 17: {
                return "unsigned int8";
            }
            case 18: {
                return "unsigned int16";
            }
            case 19: {
                return "unsigned int32";
            }
            case 20: {
                return "int64";
            }
            case 21: {
                return "unsigned in64";
            }
            case 22: {
                return "int";
            }
            case 23: {
                return "unsigned int";
            }
            case 24: {
                return "void";
            }
            case 25: {
                return "hresult";
            }
            case 26: {
                return "*";
            }
            case 27: {
                return "safearray";
            }
            case 28: {
                return "carray";
            }
            case 29: {
                return "userdefined";
            }
            case 30: {
                return "lpstr";
            }
            case 31: {
                return "plwstr";
            }
            case 36: {
                return "record";
            }
            case 64: {
                return "filetime";
            }
            case 65: {
                return "blob";
            }
            case 66: {
                return "stream";
            }
            case 67: {
                return "storage";
            }
            case 68: {
                return "streamed_object";
            }
            case 69: {
                return "stored_object";
            }
            case 70: {
                return "blob_object";
            }
            case 71: {
                return "cf";
            }
            case 72: {
                return "clsid";
            }
            case 4096: {
                return this.variantToString(variant, ++index) + " vector";
            }
            case 8192: {
                return this.variantToString(variant, ++index) + " []";
            }
            case 16384: {
                return this.variantToString(variant, ++index) + " &";
            }
        }
        return String.format("unknown_variant_0x%x", variant[index]);
    }

    private String formatArrayParameter() {
        if (this.isArray()) {
            String sizeString = this.numberOfArrayElements == -1 ? "" : "" + this.numberOfArrayElements;
            String sizeParameter = this.sizeParameterNumber == -1 ? "" : " + " + this.sizeParameterNumber;
            return " [" + sizeString + sizeParameter + "]";
        }
        return "";
    }

    @Override
    public int getNumberOfArrayElements() {
        return this.numberOfArrayElements;
    }

    @Override
    public String getMarshalerClassName() {
        return this.marshalerClassName;
    }

    @Override
    public String getMarshalerCookie() {
        return this.marshalerCookie;
    }

    @Override
    public int getSizeParameterNumber() {
        return this.sizeParameterNumber;
    }

    @Override
    public int hashCode() {
        return 37 * super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParamOrFieldMarshalSignature other = (ParamOrFieldMarshalSignature)obj;
        if (this.marshalerClassName == null ? other.marshalerClassName != null : !this.marshalerClassName.equals(other.marshalerClassName)) {
            return false;
        }
        if (this.marshalerCookie == null ? other.marshalerCookie != null : !this.marshalerCookie.equals(other.marshalerCookie)) {
            return false;
        }
        if (this.numberOfArrayElements != other.numberOfArrayElements) {
            return false;
        }
        return this.sizeParameterNumber == other.sizeParameterNumber;
    }
}

