/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab.signature;

import at.pollaknet.api.facile.exception.InvalidSignatureException;
import at.pollaknet.api.facile.metamodel.entries.MemberRefEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.ParamEntry;
import at.pollaknet.api.facile.metamodel.entries.StandAloneSigEntry;
import at.pollaknet.api.facile.symtab.BasicTypesDirectory;
import at.pollaknet.api.facile.symtab.signature.Signature;
import at.pollaknet.api.facile.symtab.symbols.MethodSignature;
import at.pollaknet.api.facile.symtab.symbols.Parameter;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;

public class MethodDefOrRefSignature
extends Signature
implements MethodSignature {
    private FixupElement[] fixupTable = new FixupElement[]{new FixupElement(".ctor", "System.Runtime.CompilerServices.RequiredAttributeAttribute", new byte[]{32, 0, 1}, new byte[]{32, 1, 1, 80})};
    private byte flags;
    private int parameterCount = 0;
    private int genericParameterCount = 0;
    private int sentinelPosition = -1;
    private TypeRef returnType;
    private ParamEntry[] parameter = null;

    @Override
    public byte getFlags() {
        return this.flags;
    }

    @Override
    public int getGenericParameterCount() {
        return this.genericParameterCount;
    }

    @Override
    public int getParameterCount() {
        return this.parameter.length;
    }

    @Override
    public Parameter[] getParameters() {
        if (this.parameter == null) {
            return new Parameter[0];
        }
        return this.parameter;
    }

    @Override
    public TypeRef getReturnType() {
        if (this.returnType == null && this.parameter != null && this.parameter.length > 0) {
            return this.parameter[0].getTypeRef();
        }
        return this.returnType;
    }

    @Override
    public Parameter getReturnParameter() {
        if (this.returnType == null && this.parameter != null && this.parameter.length > 0) {
            return this.parameter[0];
        }
        return null;
    }

    @Override
    public int getSentinelPosition() {
        return this.sentinelPosition;
    }

    public static MethodDefOrRefSignature decodeAndAttach(BasicTypesDirectory directory, MethodDefEntry methodDef) throws InvalidSignatureException {
        return new MethodDefOrRefSignature(directory, methodDef);
    }

    private MethodDefOrRefSignature(BasicTypesDirectory directory, MethodDefEntry methodDef) throws InvalidSignatureException {
        this.setBinarySignature(methodDef.getBinarySignature());
        this.setDirectory(directory);
        this.nextToken();
        this.flags = (byte)this.currentToken;
        this.nextToken();
        if (ByteReader.testFlags((int)this.flags, 16)) {
            this.genericParameterCount = this.decodeIntegerInSignature();
            assert (methodDef.getGenericParameters() != null);
            assert (this.genericParameterCount == methodDef.getGenericParameters().length);
        }
        this.parameterCount = this.decodeIntegerInSignature();
        this.parameter = methodDef.getParams();
        if (this.parameterCount != 0) {
            if (this.parameter == null || this.parameter.length == 0) {
                this.parameter = new ParamEntry[this.parameterCount];
            }
        } else if (this.parameter == null) {
            this.parameter = new ParamEntry[0];
        }
        if (this.parameterCount + 1 == this.parameter.length) {
            this.returnType = null;
            this.returnType(this.parameter[0]);
            this.params(this.parameter, true);
        } else {
            this.returnType = this.returnType();
            this.params(this.parameter, false);
        }
        methodDef.setMethodSignature(this);
        methodDef.setParams(this.parameter);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("(");
        boolean first = true;
        if (this.parameter != null) {
            int i;
            int n = i = this.returnType == null ? 1 : 0;
            while (i < this.parameter.length) {
                if (this.parameter[i] != null) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    buffer.append(this.formatParameter(i));
                    first = false;
                }
                ++i;
            }
        }
        buffer.append(") : ");
        if (this.returnType == null) {
            buffer.append(this.formatParameter(0));
        } else if (this.returnType.getShortSystemName() != null) {
            buffer.append(this.returnType.getShortSystemName());
        } else {
            buffer.append(this.returnType.getFullQualifiedName());
        }
        return buffer.toString();
    }

    private String formatParameter(int i) {
        StringBuffer buffer = new StringBuffer();
        int flags = this.parameter[i].getFlags();
        if (ByteReader.testFlags(flags, 2)) {
            buffer.append("[out] ");
        } else if (ByteReader.testFlags(flags, 1)) {
            buffer.append("[in] ");
        }
        if (ByteReader.testFlags(flags, 16)) {
            buffer.append("[opt] ");
        }
        if (ByteReader.testFlags(flags, 53216)) {
            buffer.append("[unused] ");
        }
        if (this.parameter[i].getTypeRef() != null) {
            if (this.parameter[i].getTypeRef().getShortSystemName() != null) {
                buffer.append(this.parameter[i].getTypeRef().getShortSystemName());
            } else {
                buffer.append(this.parameter[i].getTypeRef().getFullQualifiedName());
            }
        }
        if (this.parameter[i].getMarshalSignature() != null) {
            buffer.append(" marshal(");
            buffer.append(this.parameter[i].getMarshalSignature().toString());
            buffer.append(")");
        }
        if (this.parameter[i].getName() != null) {
            buffer.append(" ");
            buffer.append(this.parameter[i].getName());
        }
        return buffer.toString();
    }

    public static MethodDefOrRefSignature decode(BasicTypesDirectory directory, byte[] binarySignature, int currentIndex) {
        return new MethodDefOrRefSignature(directory, binarySignature, currentIndex);
    }

    public static MethodDefOrRefSignature decodeAndAttach(BasicTypesDirectory directory, MemberRefEntry memberRef) throws InvalidSignatureException {
        return new MethodDefOrRefSignature(directory, memberRef);
    }

    private MethodDefOrRefSignature(BasicTypesDirectory directory, MemberRefEntry memberRef) throws InvalidSignatureException {
        for (FixupElement element : this.fixupTable) {
            if (memberRef.getName() == null || !memberRef.getName().equals(element.methodName) || memberRef.getOwner().getTypeRef() == null || memberRef.getOwner().getTypeRef().getFullQualifiedName() == null || !memberRef.getOwner().getTypeRef().getFullQualifiedName().equals(element.fullQualifiedTypeName) || !ArrayUtils.arraysAreEqual(memberRef.getBinarySignature(), element.invalidSignature)) continue;
            memberRef.setBinarySignature(element.correctedSignature);
            break;
        }
        this.setBinarySignature(memberRef.getBinarySignature());
        this.setDirectory(directory);
        this.nextToken();
        this.flags = (byte)this.currentToken;
        this.nextToken();
        if (ByteReader.testFlags((int)this.flags, 16)) {
            this.genericParameterCount = this.decodeIntegerInSignature();
        }
        this.parameterCount = this.decodeIntegerInSignature();
        this.returnType = this.returnType();
        this.parameter = new ParamEntry[this.parameterCount];
        this.sentinelPosition = this.params(this.parameter, false);
        memberRef.setMethodRefSignature(this);
    }

    public static MethodDefOrRefSignature decode(BasicTypesDirectory directory, StandAloneSigEntry standAlone) throws InvalidSignatureException {
        assert (standAlone != null);
        assert (directory != null);
        return new MethodDefOrRefSignature(directory, standAlone);
    }

    public MethodDefOrRefSignature(BasicTypesDirectory directory, StandAloneSigEntry standAlone) throws InvalidSignatureException {
        this.setBinarySignature(standAlone.getBinarySignature());
        this.setDirectory(directory);
        this.nextToken();
        this.flags = (byte)this.currentToken;
        this.nextToken();
        this.parameterCount = this.decodeIntegerInSignature();
        this.returnType = this.returnType();
        this.parameter = new ParamEntry[this.parameterCount];
        this.sentinelPosition = this.params(this.parameter, false);
        standAlone.setMethodSignature(this);
    }

    public MethodDefOrRefSignature(BasicTypesDirectory directory, byte[] binarySignature, int currentIndex) {
        this.currentIndex = currentIndex - 1;
        this.setBinarySignature(binarySignature);
        this.setDirectory(directory);
        this.nextToken();
        this.flags = (byte)this.currentToken;
        this.nextToken();
        this.parameterCount = this.decodeIntegerInSignature();
        this.returnType = this.returnType();
        this.parameter = new ParamEntry[this.parameterCount];
        this.sentinelPosition = this.params(this.parameter, false);
        this.setBinarySignature(ByteReader.getBytes(binarySignature, currentIndex, this.currentIndex - currentIndex));
    }

    public static MethodDefOrRefSignature decodeAndAttach(BasicTypesDirectory directory, StandAloneSigEntry standAlone) throws InvalidSignatureException {
        return new MethodDefOrRefSignature(directory, standAlone);
    }

    class FixupElement {
        protected String methodName;
        protected String fullQualifiedTypeName;
        protected byte[] invalidSignature;
        protected byte[] correctedSignature;

        public FixupElement(String methodName, String fullQualifiedTypeName, byte[] invalidSignature, byte[] correctedSignature) {
            this.methodName = methodName;
            this.fullQualifiedTypeName = fullQualifiedTypeName;
            this.invalidSignature = invalidSignature;
            this.correctedSignature = correctedSignature;
        }
    }
}

