/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab.signature;

import at.pollaknet.api.facile.code.MethodBody;
import at.pollaknet.api.facile.exception.InvalidSignatureException;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeSpecEntry;
import at.pollaknet.api.facile.symtab.BasicTypesDirectory;
import at.pollaknet.api.facile.symtab.signature.Signature;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;

public class LocalVarSignature
extends Signature {
    public static LocalVarSignature decodeAndAttach(BasicTypesDirectory directory, MethodBody methodBody) throws InvalidSignatureException {
        return new LocalVarSignature(directory, methodBody);
    }

    private LocalVarSignature(BasicTypesDirectory directory, MethodBody methodBody) throws InvalidSignatureException {
        long token = methodBody.getLocalVarSignatureToken();
        if (token == 0L) {
            methodBody.setLocalVars(null);
            return;
        }
        assert (token >> 24 == 17L);
        assert ((token &= 0xFFFFFFL) <= Integer.MAX_VALUE);
        this.setBinarySignature(directory.getStandAloneSignatures()[(int)token - 1].getBinarySignature());
        this.setDirectory(directory);
        this.nextToken();
        if (this.currentToken != 7) {
            throw new InvalidSignatureException(this.currentToken, 7);
        }
        this.nextToken();
        int numberOfLocals = this.decodeIntegerInSignature();
        if (numberOfLocals < 1) {
            return;
        }
        assert (numberOfLocals < 65535);
        TypeRef[] localVars = new TypeRef[numberOfLocals];
        for (int i = 0; i < numberOfLocals; ++i) {
            localVars[i] = this.localVar();
        }
        methodBody.setLocalVars(localVars);
    }

    private TypeRef localVar() throws InvalidSignatureException {
        boolean isPlainType;
        if (this.currentToken == 22) {
            return this.plainType();
        }
        TypeSpecEntry typeSpec = new TypeSpecEntry();
        TypeRefEntry plainType = new TypeRefEntry();
        boolean bl = isPlainType = !this.customModifierAndConstraint(typeSpec);
        if (this.currentToken == 16) {
            this.nextToken();
            typeSpec.setTypeByRef(true);
            isPlainType = false;
        }
        if (isPlainType) {
            plainType = this.plainType();
        }
        if (plainType != null) {
            return plainType;
        }
        this.type(typeSpec);
        this.directory.registerEmbeddedTypeSpec(typeSpec);
        return typeSpec;
    }

    private boolean customModifierAndConstraint(TypeSpecEntry typeSpec) throws InvalidSignatureException {
        boolean hasModifierOrConstraint = false;
        while (this.currentToken == 32 || this.currentToken == 31 || this.currentToken == 69) {
            hasModifierOrConstraint = true;
            if (this.currentToken == 69) {
                this.nextToken();
                typeSpec.setAsPinned(true);
                continue;
            }
            if (this.currentToken == 32) {
                TypeSpecEntry optionalType = new TypeSpecEntry();
                this.nextToken();
                this.typeDefOrRefEncoded(optionalType);
                typeSpec.addOptionalModifier(optionalType);
                continue;
            }
            TypeSpecEntry requiredType = new TypeSpecEntry();
            this.nextToken();
            this.typeDefOrRefEncoded(requiredType);
            typeSpec.addRequiredModifier(requiredType);
        }
        return hasModifierOrConstraint;
    }
}

