/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab.signature;

import at.pollaknet.api.facile.exception.InvalidSignatureException;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.entries.CustomAttributeEntry;
import at.pollaknet.api.facile.metamodel.entries.MemberRefEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ICustomAttributeType;
import at.pollaknet.api.facile.symtab.BasicTypesDirectory;
import at.pollaknet.api.facile.symtab.TypeInstance;
import at.pollaknet.api.facile.symtab.signature.Signature;
import at.pollaknet.api.facile.symtab.symbols.Instance;
import at.pollaknet.api.facile.symtab.symbols.Parameter;
import at.pollaknet.api.facile.util.ByteReader;
import at.pollaknet.api.facile.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomAttributeValueSignature
extends Signature {
    private List<Instance> fixedArguments = new ArrayList<Instance>();
    private List<Pair<String, Instance>> namedFields = new ArrayList<Pair<String, Instance>>();
    private List<Pair<String, Instance>> namedProperties = new ArrayList<Pair<String, Instance>>();

    public static CustomAttributeValueSignature decodeAndAttach(BasicTypesDirectory directory, MetadataModel metaModel, CustomAttributeEntry customAttribute) throws InvalidSignatureException {
        return new CustomAttributeValueSignature(directory, metaModel, customAttribute);
    }

    private CustomAttributeValueSignature(BasicTypesDirectory directory, MetadataModel metaModel, CustomAttributeEntry customAttribute) throws InvalidSignatureException {
        this.setBinarySignature(customAttribute.getValue());
        this.setDirectory(directory);
        this.nextToken();
        this.prolog();
        this.fixedArgs(directory, customAttribute);
        if (this.hasNext()) {
            int numNamedArguments = ByteReader.getUInt16(this.binarySignature, this.currentIndex);
            this.nextToken();
            this.nextToken();
            for (int i = 0; i < numNamedArguments; ++i) {
                if (this.namedArgument(metaModel, customAttribute)) continue;
                i = numNamedArguments;
            }
        }
        if (this.fixedArguments.size() > 0) {
            Instance[] parameterInstances = new Instance[this.fixedArguments.size()];
            this.fixedArguments.toArray(parameterInstances);
            customAttribute.setFixedArguments(parameterInstances);
        }
        if (this.namedFields.size() > 0) {
            Pair[] namedInstances = new Pair[this.namedFields.size()];
            this.namedFields.toArray(namedInstances);
            customAttribute.setNamedFields(namedInstances);
        }
        if (this.namedProperties.size() > 0) {
            Pair[] namedInstances = new Pair[this.namedProperties.size()];
            this.namedProperties.toArray(namedInstances);
            customAttribute.setNamedProperties(namedInstances);
        }
    }

    private void prolog() {
        if (this.currentToken != 1) {
            throw new InvalidSignatureException(this.currentToken, 1);
        }
        this.nextToken();
        if (this.currentToken != 0) {
            throw new InvalidSignatureException(this.currentToken, 0);
        }
        this.nextToken();
    }

    private void fixedArgs(BasicTypesDirectory directory, CustomAttributeEntry customAttribute) {
        block11: {
            MethodDefEntry method;
            block9: {
                MemberRefEntry memberRef;
                block10: {
                    ICustomAttributeType customAttributeType = customAttribute.getCustomAttributeType();
                    if (customAttributeType == null) {
                        Logger.getLogger("at.pollaknet.api.facile").log(Level.WARNING, "Custom attribute without type reference. BlobIndex=" + customAttribute.getBinaryBlobIndex() + ". Derived from System.Attribute?");
                        return;
                    }
                    method = customAttributeType.getMethod();
                    if (method != null) break block9;
                    memberRef = customAttributeType.getMemberRef();
                    if (memberRef != null) break block10;
                    assert (false) : "Attached to a type ref!";
                    break block11;
                }
                if (memberRef.getMethodRefSignature() == null) break block11;
                Parameter[] parameter = memberRef.getMethodRefSignature().getParameters();
                if (parameter.length > 0) {
                    for (Parameter p : parameter) {
                        this.fixedArguments.add(this.fixedArgument(customAttribute, p.getTypeRef()));
                    }
                } else {
                    int backIndex = this.currentIndex;
                    TypeInstance newInstance = this.fixedArgument(customAttribute, directory.getType(14));
                    if (this.currentIndex + 2 == this.binarySignature.length) {
                        this.fixedArguments.add(newInstance);
                    } else {
                        this.currentIndex = backIndex;
                    }
                }
                break block11;
            }
            if (method.getMethodSignature() != null) {
                for (Parameter p : method.getMethodSignature().getParameters()) {
                    this.fixedArguments.add(this.fixedArgument(customAttribute, p.getTypeRef()));
                }
            }
        }
    }

    private boolean namedArgument(MetadataModel metaModel, CustomAttributeEntry customAttribute) throws InvalidSignatureException {
        List<Pair<String, Instance>> targetList;
        if (this.currentToken == 83) {
            targetList = this.namedFields;
        } else if (this.currentToken == 84) {
            targetList = this.namedProperties;
        } else {
            if (this.malformedSignature) {
                this.skipTokens(this.binarySignature.length - this.currentIndex);
                return false;
            }
            throw new InvalidSignatureException(this.currentToken);
        }
        this.nextToken();
        TypeRefEntry fieldOrPropertyTypeRef = null;
        if (this.currentToken == 81) {
            fieldOrPropertyTypeRef = this.directory.getType(28);
            this.nextToken();
        } else if (this.currentToken == 80) {
            fieldOrPropertyTypeRef = this.directory.getType(80);
            this.nextToken();
        } else {
            fieldOrPropertyTypeRef = this.filedOrPropertyType();
        }
        String name = this.readSerString();
        TypeInstance instance = this.fixedArgument(customAttribute, fieldOrPropertyTypeRef);
        targetList.add(new Pair<String, TypeInstance>(name, instance));
        return true;
    }
}

