/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab;

import at.pollaknet.api.facile.symtab.BasicTypesDirectory;
import at.pollaknet.api.facile.symtab.TypeKind;
import at.pollaknet.api.facile.symtab.symbols.Instance;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.Arrays;

public class TypeInstance
implements Instance {
    private TypeRef typeRef;
    private long numericValue;
    private String stringValue;
    private TypeInstance[] array = null;
    private TypeInstance boxedTypeInstance;

    private TypeInstance(TypeRef typeRef) {
        this.typeRef = typeRef;
    }

    public TypeInstance(TypeRef type, long value) {
        this(type);
        this.numericValue = value;
    }

    public TypeInstance(TypeRef type, String stringValue) {
        this(type);
        this.stringValue = stringValue;
    }

    public TypeInstance(TypeRef type, TypeInstance boxedTypeInstance) {
        this(type);
        this.boxedTypeInstance = boxedTypeInstance;
    }

    @Override
    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(TypeRef typeRef) {
        this.typeRef = typeRef;
    }

    @Override
    public long getValue() {
        return this.numericValue;
    }

    public void setValue(long value) {
        this.numericValue = value;
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public boolean isArray() {
        return this.array != null;
    }

    public TypeInstance[] getArrayInstance() {
        return this.array;
    }

    public static TypeInstance CreateArrayInstnace(TypeRef type, int arrayLength) {
        TypeInstance instance = new TypeInstance(type);
        instance.array = new TypeInstance[arrayLength];
        return instance;
    }

    @Override
    public TypeInstance getBoxedInstance() {
        return this.boxedTypeInstance;
    }

    public String toString() {
        if (this.getTypeRef().getElementTypeKind() == 2) {
            return this.getValue() != 0L ? "true" : "false";
        }
        StringBuffer buffer = new StringBuffer();
        if (this.array != null) {
            boolean first = true;
            buffer.append(this.getTypeRef().getFullQualifiedName());
            buffer.append("[");
            buffer.append(this.array.length);
            buffer.append("] {");
            for (TypeInstance i : this.array) {
                buffer.append(i.toString());
                if (first) {
                    first = false;
                    continue;
                }
                buffer.append(" ");
            }
            buffer.append("}");
            return buffer.toString();
        }
        if (this.boxedTypeInstance != null) {
            buffer.append(this.boxedTypeInstance.toString());
        } else {
            if (this.getTypeRef().getShortSystemName() != null) {
                buffer.append(this.getTypeRef().getName());
            } else {
                buffer.append(this.getTypeRef().getFullQualifiedName());
            }
            buffer.append("(");
            if (this.getStringValue() != null) {
                if (this.getTypeRef().getElementTypeKind() == 14) {
                    buffer.append("'");
                    buffer.append(this.getStringValue());
                    buffer.append("'");
                } else {
                    buffer.append(this.getStringValue());
                }
            } else if (this.getValue() == 0L && !ArrayUtils.contains(TypeKind.NUMERIC_TYPES, this.getTypeRef().getElementTypeKind())) {
                buffer.append("null");
            } else {
                buffer.append(this.getValue());
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 + Arrays.hashCode(this.array);
        result = 31 * result + (int)(this.numericValue ^ this.numericValue >>> 32);
        return 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeInstance other = (TypeInstance)obj;
        if (!Arrays.equals(this.array, other.array)) {
            return false;
        }
        if (this.boxedTypeInstance == null ? other.boxedTypeInstance != null : !this.boxedTypeInstance.equals(other.boxedTypeInstance)) {
            return false;
        }
        if (this.numericValue != other.numericValue) {
            return false;
        }
        if (this.stringValue == null ? other.stringValue != null : !this.stringValue.equals(other.stringValue)) {
            return false;
        }
        return !(this.typeRef == null ? other.typeRef != null : !this.typeRef.getFullQualifiedName().equals(other.typeRef.getFullQualifiedName()));
    }

    @Override
    public boolean isPotentialValueType() {
        Type type = this.typeRef.getType();
        if (type != null) {
            return type.getElementTypeKind() == 17 || type.isInheritedFrom("System.ValueType");
        }
        if (BasicTypesDirectory.getTypeKindByString(this.typeRef) != 0) {
            return false;
        }
        return this.typeRef.getTypeSpec() == null && this.boxedTypeInstance == null && this.array == null && this.stringValue == null;
    }
}

