/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab;

import at.pollaknet.api.facile.FacileReflector;
import at.pollaknet.api.facile.code.CilContainer;
import at.pollaknet.api.facile.code.MethodBody;
import at.pollaknet.api.facile.exception.InvalidMethodBodyException;
import at.pollaknet.api.facile.exception.InvalidSignatureException;
import at.pollaknet.api.facile.header.cli.CliHeader;
import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.metamodel.AbstractAttributable;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.AssemblyEntry;
import at.pollaknet.api.facile.metamodel.entries.ClassLayoutEntry;
import at.pollaknet.api.facile.metamodel.entries.ConstantEntry;
import at.pollaknet.api.facile.metamodel.entries.CustomAttributeEntry;
import at.pollaknet.api.facile.metamodel.entries.DeclSecurityEntry;
import at.pollaknet.api.facile.metamodel.entries.EventMapEntry;
import at.pollaknet.api.facile.metamodel.entries.FieldEntry;
import at.pollaknet.api.facile.metamodel.entries.FieldLayoutEntry;
import at.pollaknet.api.facile.metamodel.entries.FieldMarshalEntry;
import at.pollaknet.api.facile.metamodel.entries.FieldRVAEntry;
import at.pollaknet.api.facile.metamodel.entries.GenericParamConstraintEntry;
import at.pollaknet.api.facile.metamodel.entries.GenericParamEntry;
import at.pollaknet.api.facile.metamodel.entries.ImplMapEntry;
import at.pollaknet.api.facile.metamodel.entries.InterfaceImplEntry;
import at.pollaknet.api.facile.metamodel.entries.ManifestResourceEntry;
import at.pollaknet.api.facile.metamodel.entries.MemberRefEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodImplEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodSemanticsEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodSpecEntry;
import at.pollaknet.api.facile.metamodel.entries.NestedClassEntry;
import at.pollaknet.api.facile.metamodel.entries.ParamEntry;
import at.pollaknet.api.facile.metamodel.entries.PropertyEntry;
import at.pollaknet.api.facile.metamodel.entries.PropertyMapEntry;
import at.pollaknet.api.facile.metamodel.entries.StandAloneSigEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeSpecEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.INamespaceOwner;
import at.pollaknet.api.facile.pdb.PdbReader;
import at.pollaknet.api.facile.symtab.BasicTypesDirectory;
import at.pollaknet.api.facile.symtab.NamespaceContainer;
import at.pollaknet.api.facile.symtab.signature.CustomAttributeValueSignature;
import at.pollaknet.api.facile.symtab.signature.DeclSecuritySignature;
import at.pollaknet.api.facile.symtab.signature.FieldSignature;
import at.pollaknet.api.facile.symtab.signature.LocalVarSignature;
import at.pollaknet.api.facile.symtab.signature.MethodDefOrRefSignature;
import at.pollaknet.api.facile.symtab.signature.MethodSpecSignature;
import at.pollaknet.api.facile.symtab.signature.ParamOrFieldMarshalSignature;
import at.pollaknet.api.facile.symtab.signature.PropertyEntrySignature;
import at.pollaknet.api.facile.symtab.signature.TypeSpecSignature;
import at.pollaknet.api.facile.symtab.symbols.Method;
import at.pollaknet.api.facile.symtab.symbols.Parameter;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.TypeSpec;
import at.pollaknet.api.facile.symtab.symbols.aggregation.ResolutionScope;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SymbolTable {
    private BasicTypesDirectory directory;
    private AssemblyEntry assembly;
    private MetadataModel metaModel;
    private CilContainer codeContainer;
    private PdbReader pdbReader;
    private BlobStream blobStream;
    private CliHeader cliHeader;
    private boolean haltOnErrors;
    private boolean haltOnJniErrors;

    public SymbolTable(CliHeader cliHeader, MetadataModel metaModel, BlobStream blobStream, CilContainer codeContainer, PdbReader pdbReader, String pathToAssembly) {
        assert (metaModel != null);
        assert (codeContainer != null);
        assert (cliHeader != null);
        this.cliHeader = cliHeader;
        this.metaModel = metaModel;
        this.codeContainer = codeContainer;
        this.pdbReader = pdbReader;
        this.blobStream = blobStream;
        assert (metaModel.assembly != null);
        assert (metaModel.assembly[0] != null);
        int pos = pathToAssembly.lastIndexOf(System.getProperty("file.separator")) + 1;
        if (pos > 0 && pos < pathToAssembly.length()) {
            metaModel.assembly[0].setFileName(pathToAssembly.substring(pos));
        } else {
            metaModel.assembly[0].setFileName(pathToAssembly);
        }
    }

    public void build(FacileReflector facileReflector) {
        this.haltOnErrors = facileReflector.getHaltOnErrors();
        this.haltOnJniErrors = facileReflector.getHaltOnJniErrors();
        this.directory = new BasicTypesDirectory(this.metaModel, this.blobStream, facileReflector.getReferenceAssemblies(), facileReflector.getReferneceEnums());
        this.connectNestedClass();
        this.connectAllAssemblies();
        this.connectModule();
        this.connectModuleRef();
        this.connectFileRef();
        this.connectMethodImpls();
        this.connectTypes();
        this.connectGenericParameterAndConstraints();
        this.connectManifestResource();
        this.connectCustomAttribute();
        this.connectMethodSemantics();
        this.connectFields();
        this.connectFieldMarshal();
        this.connectClassLayout();
        this.connectConstant();
        this.connectDeclSecurity();
        this.connectFieldLayout();
        this.connectFieldRva();
        this.connectParam();
        this.connectImplMap();
        this.connectInterface();
        this.connectMethodDef(this.codeContainer, this.pdbReader);
        this.connectPropertyMapAndProperty();
        this.connectEventMapAndEvent();
        this.connectMethodSpec();
        this.connectMemberRef();
        this.connectStandAloneSignatures();
        this.connectCustomAttributes();
        this.connectExportedType();
        this.connectGenericTypeNames();
        this.connectSignatureEmbeddedTypes(this.metaModel.typeDef);
        this.connectSignatureEmbeddedTypes(this.metaModel.typeRef);
        this.connectSignatureEmbeddedTypes(this.metaModel.typeSpec);
        ArrayList<TypeSpecEntry> var = this.directory.getEmbeddedTypeSpecs();
        TypeRefEntry[] signatureEmbeddedTypeSpecs = var.toArray(new TypeSpecEntry[var.size()]);
        this.connectSignatureEmbeddedTypes(signatureEmbeddedTypeSpecs);
        this.finalizeAssembly((TypeSpecEntry[])signatureEmbeddedTypeSpecs);
    }

    public void connectGenericTypeNames() {
        for (ParamEntry paramEntry : this.metaModel.param) {
            paramEntry.linkGenericNameToType();
        }
        for (AbstractAttributable abstractAttributable : this.metaModel.typeSpec) {
            ((TypeSpecEntry)abstractAttributable).propagateGenericArguments();
        }
        for (AbstractAttributable abstractAttributable : this.metaModel.methodSpec) {
            TypeSpec[] genericInstances;
            TypeSpecEntry typeSpecEntry;
            Parameter[] genericParams;
            Method method = ((MethodSpecEntry)abstractAttributable).getMethod().getMethod();
            if (method == null || (genericParams = method.getGenericParameters()).length <= 0) continue;
            TypeRef typeRef = method.getMethodSignature().getReturnType();
            if (typeRef != null && (typeSpecEntry = (TypeSpecEntry)typeRef.getTypeSpec()) != null && typeSpecEntry.isGenericInstance() && typeSpecEntry.getName() == null) {
                typeSpecEntry.setName(genericParams[0].getName());
            }
            if ((genericInstances = method.getGenericInstances()).length <= 0) continue;
            for (int i = 0; i < genericInstances.length; ++i) {
                if (i >= genericParams.length || genericInstances[i].getName() != null) continue;
                ((TypeSpecEntry)genericInstances[i]).setName(genericParams[i].getName());
            }
        }
    }

    private void connectMethodImpls() {
        for (MethodImplEntry m : this.metaModel.methodImpl) {
            Method method = m.getImplementationBody().getMethod();
            if (m.getOwnerClass() != null) {
                m.getOwnerClass().addMethod((MethodDefEntry)method);
                continue;
            }
            if (!this.metaModel.containsNoDeletedData()) continue;
            if (this.haltOnErrors) {
                throw new NullPointerException("The owner of a method is null: " + m.toString());
            }
            Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "The owner of a method is null: " + m.toString());
        }
    }

    private void connectFields() {
        for (FieldEntry fieldEntry : this.metaModel.field) {
            try {
                FieldSignature.decodeAndAttach(this.directory, fieldEntry);
                ParamOrFieldMarshalSignature.decodeAndAttach(this.directory, fieldEntry);
                fieldEntry.linkGenericNameToType();
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + fieldEntry.toString());
            }
        }
    }

    private void connectCustomAttributes() {
        for (CustomAttributeEntry customAttribute : this.metaModel.customAttribute) {
            assert (customAttribute != null);
            if (customAttribute.getValue() == null) continue;
            try {
                CustomAttributeValueSignature.decodeAndAttach(this.directory, this.metaModel, customAttribute);
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + customAttribute.toString());
            }
        }
    }

    private void connectMemberRef() {
        for (MemberRefEntry memberRef : this.metaModel.memberRef) {
            assert (memberRef != null);
            assert (memberRef.getBinarySignature() != null);
            assert (memberRef.getBinarySignature().length > 0);
            try {
                if (memberRef.getBinarySignature()[0] == 6) {
                    FieldSignature.decodeAndAttach(this.directory, memberRef);
                    continue;
                }
                MethodDefOrRefSignature.decodeAndAttach(this.directory, memberRef);
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + memberRef.toString());
            }
        }
    }

    private void connectStandAloneSignatures() {
        for (StandAloneSigEntry standAlone : this.metaModel.standAloneSig) {
            assert (standAlone.getBinarySignature() != null);
            assert (standAlone.getBinarySignature().length > 0);
            try {
                switch (standAlone.getBinarySignature()[0]) {
                    case 6: {
                        FieldSignature.decodeAndAttach(this.directory, standAlone);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        MethodDefOrRefSignature.decodeAndAttach(this.directory, standAlone);
                        break;
                    }
                }
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + standAlone.toString());
            }
        }
    }

    private void connectMethodSpec() {
        for (MethodSpecEntry methodSpec : this.metaModel.methodSpec) {
            try {
                MethodSpecSignature.decodeAndAttach(this.directory, methodSpec);
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + methodSpec.toString());
            }
        }
    }

    private void connectFileRef() {
        this.assembly.setFileRefs(this.metaModel.file);
    }

    private void connectModuleRef() {
        this.assembly.setModuleRefs(this.metaModel.moduleRef);
    }

    private void connectGenericParameterAndConstraints() {
        for (GenericParamConstraintEntry genericParamConstraintEntry : this.metaModel.genericParamConstraint) {
            if (genericParamConstraintEntry.getOwner() != null) {
                genericParamConstraintEntry.getOwner().addConstraint(genericParamConstraintEntry.getConstraint());
                continue;
            }
            if (!this.metaModel.containsNoDeletedData()) continue;
            throw new NullPointerException("The owner of a generic parameter constraint is null!");
        }
        for (AbstractAttributable abstractAttributable : this.metaModel.genericParam) {
            if (((GenericParamEntry)abstractAttributable).getOwner() != null) {
                ((GenericParamEntry)abstractAttributable).getOwner().addGenericParam((GenericParamEntry)abstractAttributable);
                continue;
            }
            if (!this.metaModel.containsNoDeletedData()) continue;
            throw new NullPointerException("The owner of a generic parameter is null!");
        }
    }

    private void connectInterface() {
        for (InterfaceImplEntry interf : this.metaModel.interfaceImpl) {
            interf.getImplementationClass().addInterface(interf.getInterface().getTypeRef());
        }
    }

    private void connectImplMap() {
        for (ImplMapEntry impl : this.metaModel.implMap) {
            impl.getMemberForwarded().setNativeImplementation(impl);
        }
    }

    private void connectFieldRva() {
        for (FieldRVAEntry fieldRVA : this.metaModel.fieldRva) {
            fieldRVA.getField().setRelativeVirtualAddress(fieldRVA.getRelativeVirtualAddress());
        }
    }

    private void connectFieldLayout() {
        for (FieldLayoutEntry layout : this.metaModel.fieldLayout) {
            layout.getField().setFieldLayout(layout);
        }
    }

    private void connectDeclSecurity() {
        for (DeclSecurityEntry security : this.metaModel.declSecurity) {
            try {
                DeclSecuritySignature.decodeAndAttach(this.directory, security);
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + security.toString());
            }
        }
    }

    private void connectConstant() {
        for (ConstantEntry constant : this.metaModel.constant) {
            constant.getParent().setConstant(constant);
        }
    }

    private void connectClassLayout() {
        for (ClassLayoutEntry layout : this.metaModel.classLayout) {
            layout.getParent().setClassLayout(layout);
        }
    }

    private void connectMethodDef(CilContainer codeContainer, PdbReader pdbReader) {
        long prevRVA = -1L;
        String prevMethod = "[not set]";
        long nativeCodeRVA = 0L;
        long methodRVA = 0L;
        int containerSize = codeContainer.getCodeBuffer().length;
        int tokenCounter = 1;
        for (MethodDefEntry method : this.metaModel.methodDef) {
            methodRVA = method.getVirtualAddress();
            if (method.getParams() != null) {
                for (AbstractAttributable abstractAttributable : method.getParams()) {
                    ((ParamEntry)abstractAttributable).setOwner(method);
                }
            }
            if (method.getGenericParameters() != null) {
                for (AbstractAttributable abstractAttributable : method.getGenericParameters()) {
                    ((GenericParamEntry)abstractAttributable).setOwner(method);
                }
            }
            if (methodRVA != 0L) {
                MethodBody methodBody = null;
                if (this.metaModel.assemblyHasIlSection() || ByteReader.testFlags(method.getImplFlags(), 133)) {
                    methodBody = new MethodBody(tokenCounter);
                } else if (ByteReader.testFlags(method.getFlags(), 6144) && method.getName().toLowerCase().contains("_deleted")) {
                    try {
                        methodBody = new MethodBody(this.metaModel, codeContainer, methodRVA, tokenCounter);
                    }
                    catch (InvalidMethodBodyException e) {
                        String msg = String.format("Detected deleted method body: %s.%s%s Flags: 0x%04x ImplFlags: 0x%04x", method.getOwner().getTypeRef().getName(), method.getName(), method.getMethodSignature() == null ? "()" : method.getMethodSignature().toString(), method.getFlags(), method.getImplFlags());
                        Logger.getLogger("at.pollaknet.api.facile").log(Level.INFO, msg);
                        methodBody = new MethodBody(tokenCounter);
                    }
                } else {
                    try {
                        methodBody = new MethodBody(this.metaModel, codeContainer, methodRVA, tokenCounter);
                    }
                    catch (InvalidMethodBodyException e) {
                        String msg = String.format("Detected invalid method body: %s.%s%s Flags: 0x%04x ImplFlags: 0x%04x", method.getOwner().getTypeRef().getName(), method.getName(), method.getMethodSignature() == null ? "()" : method.getMethodSignature().toString(), method.getFlags(), method.getImplFlags());
                        Logger.getLogger("at.pollaknet.api.facile").log(Level.WARNING, msg);
                        methodBody = new MethodBody(tokenCounter);
                    }
                }
                try {
                    LocalVarSignature.decodeAndAttach(this.directory, methodBody);
                }
                catch (InvalidSignatureException e) {
                    if (this.haltOnErrors) {
                        throw e;
                    }
                    Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + methodBody.toString());
                }
                method.setMethodBody(methodBody);
                if (pdbReader != null) {
                    try {
                        method.setDebugInformation(pdbReader.getLineNumbersByRVA(nativeCodeRVA));
                    }
                    catch (Error e) {
                        if (this.haltOnJniErrors) {
                            throw e;
                        }
                        Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Failed to query line number information: " + method.toString() + " at RVA " + nativeCodeRVA);
                    }
                }
                if (methodRVA < prevRVA) {
                    Logger.getLogger("at.pollaknet.api.facile").log(pdbReader != null ? Level.SEVERE : Level.INFO, String.format("Method %s with VA 0x%x is extracted after method %s with RVA 0x%x.", method.getName(), methodRVA, prevMethod, prevRVA));
                }
                nativeCodeRVA += method.getMethodBody().getCodeSize();
            }
            if (method.getBinarySignature() != null) {
                try {
                    MethodDefOrRefSignature.decodeAndAttach(this.directory, method);
                }
                catch (InvalidSignatureException e) {
                    if (this.haltOnErrors) {
                        throw e;
                    }
                    Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + method.toString());
                }
            }
            ++tokenCounter;
            prevRVA = methodRVA;
            prevMethod = method.getName();
        }
    }

    private void connectModule() {
        if (this.metaModel.module.length > 0) {
            this.assembly.setModule(this.metaModel.module[0]);
            if (this.metaModel.module.length > 1) {
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, String.format("Unexpected number of module entries %d (allowed: 0 and 1).", this.metaModel.module.length));
            }
        }
    }

    private void connectAllAssemblies() {
        this.assembly = this.metaModel.assembly[0];
        this.assembly.setTypes(this.metaModel.typeDef);
        this.directory.getReferenceAssemblies().add(this.assembly);
        if (this.metaModel.assembly.length > 1) {
            Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, String.format("Unexpected number of assembly entries %d, multi assembly files are not supported yet. ", this.metaModel.assembly.length));
        }
        this.assembly.setAssemblyOs(this.metaModel.assemblyOs);
        this.assembly.setAssemblyProcessor(this.metaModel.assemblyProcessor);
        this.assembly.setAssemblyRefs(this.metaModel.assemblyRef);
        this.assembly.setAssemblyRefOs(this.metaModel.assemblyRefOs);
        this.assembly.setAssemblyRefProcessor(this.metaModel.assemblyRefProcessor);
    }

    private void finalizeAssembly(TypeSpecEntry[] signatureEmbeddedTypeSpecs) {
        Arrays.sort(this.metaModel.typeDef);
        Arrays.sort(this.metaModel.typeRef);
        Arrays.sort(this.metaModel.typeSpec);
        Arrays.sort(signatureEmbeddedTypeSpecs);
        this.assembly.setTypeRefs(this.metaModel.typeRef);
        this.assembly.setTypeSpecs(this.metaModel.typeSpec);
        this.assembly.setEmbeddedTypeSpecs(signatureEmbeddedTypeSpecs);
    }

    private void connectManifestResource() {
        long resourceDirectoryRVA = this.cliHeader.getAddrOfResourcesDirectory();
        byte[] buffer = this.codeContainer.getCodeBuffer();
        for (ManifestResourceEntry resource : this.metaModel.manifestResource) {
            long length;
            if (resource.getImplementation() != null) continue;
            long offset = resource.getOffset();
            int address = this.codeContainer.getPhysicalAddressOf(resourceDirectoryRVA + offset);
            if ((long)(address + 4) + (length = ByteReader.getUInt32(buffer, address)) <= (long)buffer.length) {
                resource.setResource(ByteReader.getBytes(buffer, address + 4, (int)length));
                continue;
            }
            String msg = "Unable to locate resource \"" + resource.getName() + "\" at address " + (address + 4) + ".";
            Logger.getLogger("at.pollaknet.api.facile").log(Level.INFO, msg);
        }
        this.assembly.setManifestResources(this.metaModel.manifestResource);
    }

    private void connectFieldMarshal() {
        for (FieldMarshalEntry marshal : this.metaModel.fieldMarshal) {
            marshal.getParent().setBinaryMarshalTypeSignature(marshal.getNativeType());
        }
    }

    private void connectMethodSemantics() {
        for (MethodSemanticsEntry semantics : this.metaModel.methodSemantics) {
            semantics.getMethod().setSemantics(semantics.getAssociation());
            semantics.getMethod().setSemanticsFlags(semantics.getSemantics());
        }
    }

    private void connectEventMapAndEvent() {
        for (EventMapEntry map : this.metaModel.eventMap) {
            map.getParent().setEvents(map.getEvents());
        }
    }

    private void connectPropertyMapAndProperty() {
        for (PropertyEntry propertyEntry : this.metaModel.property) {
            try {
                PropertyEntrySignature.decodeAndAttach(this.directory, propertyEntry);
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + propertyEntry.toString());
            }
        }
        for (RenderableCilElement renderableCilElement : this.metaModel.propertyMap) {
            if (((PropertyMapEntry)renderableCilElement).getParent() == null) continue;
            ((PropertyMapEntry)renderableCilElement).getParent().setProperties(((PropertyMapEntry)renderableCilElement).getProperties());
        }
    }

    private void connectTypes() {
        String namespace;
        HashMap<String, ArrayList<TypeDefEntry>> namespaceTypMap = new HashMap<String, ArrayList<TypeDefEntry>>();
        if (this.metaModel.typeDef.length > 0) {
            for (int index = 0; index < this.metaModel.typeDef.length; ++index) {
                this.directory.register(this.metaModel.typeDef[index]);
                if (!this.metaModel.typeDef[index].isExported() && this.metaModel.typeDef[index].getResolutionScope() == null) {
                    this.metaModel.typeDef[index].setResolutionScope(this.metaModel.module[0]);
                }
                if (!this.metaModel.typeDef[index].isNested()) {
                    ArrayList<TypeDefEntry> currentTypesInNamespace;
                    namespace = this.metaModel.typeDef[index].getNamespace();
                    if (namespace == null) {
                        this.metaModel.typeDef[index].setNamespace("");
                    }
                    if ((currentTypesInNamespace = (ArrayList<TypeDefEntry>)namespaceTypMap.get(namespace)) == null) {
                        currentTypesInNamespace = new ArrayList<TypeDefEntry>();
                        namespaceTypMap.put(namespace, currentTypesInNamespace);
                    }
                    currentTypesInNamespace.add(this.metaModel.typeDef[index]);
                }
                this.metaModel.typeDef[index].linkMethodsToType();
            }
        }
        Object[] namespaces = new NamespaceContainer[namespaceTypMap.values().size()];
        int index = 0;
        for (ArrayList typesInNamespace : namespaceTypMap.values()) {
            String nameOfNamespace = ((Type)typesInNamespace.get(0)).getNamespace();
            Object[] types = typesInNamespace.toArray(new Type[typesInNamespace.size()]);
            Arrays.sort(types);
            namespaces[index] = new NamespaceContainer(nameOfNamespace, (TypeRef[])types);
            ++index;
        }
        Arrays.sort(namespaces);
        this.metaModel.module[0].setNamespaces((NamespaceContainer[])namespaces);
        HashMap scopeMap = new HashMap();
        HashMap<String, ArrayList<TypeRefEntry>> namespaceTypeRefMap = null;
        ResolutionScope currentScope = null;
        ArrayList<TypeRefEntry> currentTypeRefNamespace = null;
        for (TypeRefEntry typeRef : this.metaModel.typeRef) {
            this.directory.register(typeRef);
            currentScope = typeRef.getResolutionScope();
            if (currentScope == null) {
                currentScope = this.metaModel.module[0];
            }
            if ((namespaceTypeRefMap = (HashMap<String, ArrayList<TypeRefEntry>>)scopeMap.get(currentScope)) == null) {
                namespaceTypeRefMap = new HashMap<String, ArrayList<TypeRefEntry>>();
                scopeMap.put(currentScope, namespaceTypeRefMap);
            }
            if ((namespace = typeRef.getNamespace()) == null) {
                typeRef.setNamespace(currentScope.getFullQualifiedName());
            }
            if ((currentTypeRefNamespace = (ArrayList<TypeRefEntry>)namespaceTypeRefMap.get(namespace)) == null) {
                currentTypeRefNamespace = new ArrayList<TypeRefEntry>();
                namespaceTypeRefMap.put(namespace, currentTypeRefNamespace);
            }
            currentTypeRefNamespace.add(typeRef);
        }
        for (ResolutionScope scope : scopeMap.keySet()) {
            if (scope == this.assembly.getModule()) continue;
            assert (namespaceTypeRefMap != null);
            namespaceTypeRefMap = (HashMap)scopeMap.get(scope);
            namespaces = new NamespaceContainer[namespaceTypeRefMap.size()];
            index = 0;
            for (ArrayList typesRefsInNamespace : namespaceTypeRefMap.values()) {
                String nameOfNamespace = ((TypeRef)typesRefsInNamespace.get(0)).getNamespace();
                Object[] types = typesRefsInNamespace.toArray(new TypeRef[typesRefsInNamespace.size()]);
                Arrays.sort(types);
                namespaces[index] = new NamespaceContainer(nameOfNamespace, (TypeRef[])types);
                ++index;
            }
            Arrays.sort(namespaces);
            ((INamespaceOwner)((Object)scope)).setNamespaces((NamespaceContainer[])namespaces);
        }
        for (TypeSpecEntry typeSpec : this.metaModel.typeSpec) {
            try {
                TypeSpecSignature.decodeAndAttach(this.directory, typeSpec);
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Failed to decode signature: " + typeSpec.toString());
            }
            typeSpec.setResolutionScope(this.assembly.getModule());
        }
    }

    private void connectSignatureEmbeddedTypes(TypeRefEntry[] typeRefs) {
        if (typeRefs != null && typeRefs.length > 0) {
            for (TypeRefEntry type : typeRefs) {
                type.adjustNamespace(this.assembly.getModule());
            }
        }
    }

    private void connectCustomAttribute() {
        for (CustomAttributeEntry customAttribute : this.metaModel.customAttribute) {
            if (customAttribute.getOwner() != null) {
                customAttribute.getOwner().addCustomAttribute(customAttribute);
                continue;
            }
            if (!this.metaModel.containsNoDeletedData()) continue;
            if (this.haltOnErrors) {
                throw new NullPointerException("The owner of a custom attribute is null: " + customAttribute.toString());
            }
            Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "The owner of a custom attribute is null: " + customAttribute.toString());
        }
    }

    private void connectParam() {
        for (ParamEntry param : this.metaModel.param) {
            try {
                ParamOrFieldMarshalSignature.decodeAndAttach(this.directory, param);
            }
            catch (InvalidSignatureException e) {
                if (this.haltOnErrors) {
                    throw e;
                }
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Faild to decode signature: " + param.toString());
            }
        }
    }

    private void connectNestedClass() {
        for (NestedClassEntry nested : this.metaModel.nestedClass) {
            nested.getNestedClass().setNested(true);
            nested.getEnclosingClass().addNestedClass(nested.getNestedClass());
            String namespace = nested.getEnclosingClass().getNamespace();
            namespace = namespace == null || namespace.equals("") ? nested.getEnclosingClass().getName() : namespace + "." + nested.getEnclosingClass().getName();
            nested.getNestedClass().setNamespace(namespace);
        }
    }

    private void connectExportedType() {
        Arrays.sort(this.metaModel.exportedType);
        this.assembly.getModule().setExportedTypes(this.metaModel.exportedType);
    }
}

