/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab;

import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.aggregation.Namespace;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.Arrays;

public class NamespaceContainer
implements Namespace {
    private String name = null;
    private String fullQualifiedName = null;
    private TypeRef[] typeRefs = null;
    private String[] address = null;

    NamespaceContainer(String fullQualifiedName, TypeRef[] typeRefs) {
        assert (fullQualifiedName != null);
        int dotPosition = fullQualifiedName.lastIndexOf(46);
        this.fullQualifiedName = fullQualifiedName;
        this.name = dotPosition < 0 ? fullQualifiedName : fullQualifiedName.substring(dotPosition + 1);
        this.address = fullQualifiedName.split("\\.");
        this.typeRefs = typeRefs;
    }

    @Override
    public String getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getAddress() {
        return this.address;
    }

    @Override
    public TypeRef[] getTypeRefs() {
        return this.typeRefs;
    }

    @Override
    public boolean isSubNamespace(Namespace namespace) {
        int subLength = this.address.length;
        int supLength = namespace.getAddress().length;
        if (subLength <= supLength) {
            return false;
        }
        String[] superAddress = namespace.getAddress();
        for (int level = 0; level < supLength; ++level) {
            if (this.address[level].equals(superAddress[level])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubNamespace(String namespace) {
        String[] superAddress = namespace.split("\\.");
        if (superAddress.length == 0) {
            return false;
        }
        int subLength = this.address.length;
        int supLength = superAddress.length;
        if (subLength <= supLength) {
            return false;
        }
        for (int level = 0; level < supLength; ++level) {
            if (this.address[level].equals(superAddress[level])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuperNamespace(Namespace namespace) {
        return namespace.isSubNamespace(this);
    }

    @Override
    public boolean isSuperNamespace(String namespace) {
        String[] subAddress = namespace.split("\\.");
        if (subAddress.length == 0) {
            return false;
        }
        int supLength = this.address.length;
        int subLength = subAddress.length;
        if (supLength >= subLength) {
            return false;
        }
        for (int level = 0; level < supLength; ++level) {
            if (this.address[level].equals(subAddress[level])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return this.fullQualifiedName;
    }

    @Override
    public String getShortSystemName() {
        return null;
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return null;
    }

    public String toString() {
        return "Namespace: " + (this.fullQualifiedName != null ? this.fullQualifiedName : "[no name set]");
    }

    @Override
    public int compareTo(Namespace namespace) {
        return ArrayUtils.compareStrings(namespace.getFullQualifiedName(), this.fullQualifiedName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.fullQualifiedName == null ? 0 : this.fullQualifiedName.hashCode());
        result = 31 * result + Arrays.hashCode(this.typeRefs);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceContainer other = (NamespaceContainer)obj;
        if (this.fullQualifiedName == null ? other.fullQualifiedName != null : !this.fullQualifiedName.equals(other.fullQualifiedName)) {
            return false;
        }
        return Arrays.equals(this.typeRefs, other.typeRefs);
    }
}

