/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.symtab;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.entries.AssemblyRefEntry;
import at.pollaknet.api.facile.metamodel.entries.GenericParamEntry;
import at.pollaknet.api.facile.metamodel.entries.StandAloneSigEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeSpecEntry;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.aggregation.ResolutionScope;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicTypesDirectory {
    private static final String MSCORLIB_IDENTIFIER_STRING = "mscorlib";
    private MetadataModel metaModel;
    private ResolutionScope coreLibScope;
    private HashMap<Integer, TypeRefEntry> typeRefs = new HashMap();
    private ArrayList<TypeSpecEntry> signatureEmbeddedTypeSpecs = new ArrayList();
    private BlobStream blobStream = null;
    private List<Assembly> referenceAssemblies = null;
    private Map<String, Byte> referenceEnums = null;

    public BasicTypesDirectory(MetadataModel metaModel, BlobStream blobStream, List<Assembly> referenceAssemblies, Map<String, Byte> referenceEnums) {
        this.metaModel = metaModel;
        this.blobStream = blobStream;
        this.referenceAssemblies = referenceAssemblies;
        this.referenceEnums = referenceEnums;
        for (AssemblyRefEntry entry : metaModel.assemblyRef) {
            if (entry.getName() == null || !entry.getName().equals(MSCORLIB_IDENTIFIER_STRING)) continue;
            this.coreLibScope = entry;
            break;
        }
        assert (metaModel.assembly[0] != null);
    }

    public List<Assembly> getReferenceAssemblies() {
        return this.referenceAssemblies;
    }

    public Map<String, Byte> getReferenceEnums() {
        return this.referenceEnums;
    }

    public boolean register(TypeRefEntry typeDefOrRef) {
        if (this.typeRefs.values().contains(typeDefOrRef) || typeDefOrRef.getFullQualifiedName() == null) {
            return false;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.String")) {
            typeDefOrRef.setElementKind(14);
            typeDefOrRef.setShortSystemName("string");
            this.typeRefs.put(14, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Boolean")) {
            typeDefOrRef.setElementKind(2);
            typeDefOrRef.setShortSystemName("bool");
            this.typeRefs.put(2, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Char")) {
            typeDefOrRef.setElementKind(3);
            typeDefOrRef.setShortSystemName("char");
            this.typeRefs.put(3, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.SByte")) {
            typeDefOrRef.setElementKind(4);
            typeDefOrRef.setShortSystemName("int8");
            this.typeRefs.put(4, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Byte")) {
            typeDefOrRef.setElementKind(5);
            typeDefOrRef.setShortSystemName("unsigned int8");
            this.typeRefs.put(5, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Int16")) {
            typeDefOrRef.setElementKind(6);
            typeDefOrRef.setShortSystemName("int16");
            this.typeRefs.put(6, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.UInt16")) {
            typeDefOrRef.setElementKind(7);
            typeDefOrRef.setShortSystemName("unsigned int16");
            this.typeRefs.put(7, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Int32")) {
            typeDefOrRef.setElementKind(8);
            typeDefOrRef.setShortSystemName("int32");
            this.typeRefs.put(8, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.UInt32")) {
            typeDefOrRef.setElementKind(9);
            typeDefOrRef.setShortSystemName("unsigned int32");
            this.typeRefs.put(9, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Int64")) {
            typeDefOrRef.setElementKind(10);
            typeDefOrRef.setShortSystemName("int64");
            this.typeRefs.put(10, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.UInt64")) {
            typeDefOrRef.setElementKind(11);
            typeDefOrRef.setShortSystemName("unsigned int64");
            this.typeRefs.put(11, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.TypedReference")) {
            typeDefOrRef.setElementKind(22);
            this.typeRefs.put(22, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Void")) {
            typeDefOrRef.setElementKind(1);
            typeDefOrRef.setShortSystemName("void");
            this.typeRefs.put(1, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Object")) {
            typeDefOrRef.setElementKind(28);
            typeDefOrRef.setShortSystemName("object");
            this.typeRefs.put(28, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Single")) {
            typeDefOrRef.setElementKind(12);
            typeDefOrRef.setShortSystemName("float32");
            this.typeRefs.put(12, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Double")) {
            typeDefOrRef.setElementKind(13);
            typeDefOrRef.setShortSystemName("float64");
            this.typeRefs.put(13, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.IntPtr")) {
            typeDefOrRef.setElementKind(15);
            typeDefOrRef.setShortSystemName("native int");
            this.typeRefs.put(24, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.UIntPtr")) {
            typeDefOrRef.setElementKind(15);
            typeDefOrRef.setShortSystemName("native unsigned int");
            this.typeRefs.put(25, typeDefOrRef);
            return true;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Type")) {
            typeDefOrRef.setElementKind(80);
            this.typeRefs.put(80, typeDefOrRef);
            return true;
        }
        return false;
    }

    public static int getTypeKindByString(TypeRef typeDefOrRef) {
        if (typeDefOrRef.getFullQualifiedName().equals("System.String")) {
            return 14;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Boolean")) {
            return 2;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Char")) {
            return 3;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.SByte")) {
            return 4;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Byte")) {
            return 5;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Int16")) {
            return 6;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.UInt16")) {
            return 7;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Int32")) {
            return 8;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.UInt32")) {
            return 9;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Int64")) {
            return 11;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.UInt64")) {
            return 11;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.TypedReference")) {
            return 22;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Void")) {
            return 1;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Object")) {
            return 28;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Single")) {
            return 12;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Double")) {
            return 13;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.Type")) {
            return 80;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.IntPtr")) {
            return 24;
        }
        if (typeDefOrRef.getFullQualifiedName().equals("System.UIntPtr")) {
            return 25;
        }
        return 0;
    }

    public TypeRefEntry getRegisteredType(TypeRefEntry typeDefOrRef) {
        int typeIdentifier = BasicTypesDirectory.getTypeKindByString(typeDefOrRef);
        TypeRefEntry type = this.typeRefs.get(new Integer(typeIdentifier));
        return type == null ? typeDefOrRef : type;
    }

    public TypeRefEntry getType(int typeIdentifier) {
        TypeRefEntry type = this.typeRefs.get(new Integer(typeIdentifier));
        if (type != null) {
            return type;
        }
        TypeRefEntry typeRef = null;
        switch (typeIdentifier) {
            case 2: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Boolean", "bool");
                break;
            }
            case 3: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Char", "char");
                break;
            }
            case 4: {
                typeRef = new TypeRefEntry(this.coreLibScope, "SByte", "int8");
                break;
            }
            case 5: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Byte", "uint8");
                break;
            }
            case 6: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Int16", "int16");
                break;
            }
            case 7: {
                typeRef = new TypeRefEntry(this.coreLibScope, "UInt16", "uint16");
                break;
            }
            case 8: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Int32", "int32");
                break;
            }
            case 9: {
                typeRef = new TypeRefEntry(this.coreLibScope, "UInt32", "uint32");
                break;
            }
            case 10: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Int64", "int64");
                break;
            }
            case 11: {
                typeRef = new TypeRefEntry(this.coreLibScope, "UInt64", "uint64");
                break;
            }
            case 12: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Single", "float32");
                break;
            }
            case 13: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Double", "float64");
                break;
            }
            case 24: {
                typeRef = new TypeRefEntry(this.coreLibScope, "IntPtr");
                break;
            }
            case 25: {
                typeRef = new TypeRefEntry(this.coreLibScope, "UIntPtr");
                break;
            }
            case 28: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Object", "object");
                break;
            }
            case 14: {
                typeRef = new TypeRefEntry(this.coreLibScope, "String", "string");
                break;
            }
            case 1: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Void", "void");
                break;
            }
            case 22: {
                typeRef = new TypeRefEntry(this.coreLibScope, "TypedReference");
                break;
            }
            case 80: {
                typeRef = new TypeRefEntry(this.coreLibScope, "Type");
                break;
            }
            default: {
                return null;
            }
        }
        this.register(typeRef);
        return typeRef;
    }

    public static int findSuperTypeKind(TypeRef typeRef) {
        TypeRef superType = typeRef;
        while (superType != null) {
            if (superType.getFullQualifiedName().equals("System.Enum")) {
                return 85;
            }
            Type type = superType.getType();
            if (type != null && type.getExtends() != null) {
                superType = type.getExtends();
                continue;
            }
            superType = null;
        }
        return typeRef.getElementTypeKind();
    }

    public TypeRefEntry[] getTypeRefs() {
        return this.metaModel.typeRef;
    }

    public TypeSpecEntry[] getTypeSpecs() {
        return this.metaModel.typeSpec;
    }

    public TypeDefEntry[] getTypeDefs() {
        return this.metaModel.typeDef;
    }

    public StandAloneSigEntry[] getStandAloneSignatures() {
        return this.metaModel.standAloneSig;
    }

    public GenericParamEntry[] getGenericParams() {
        return this.metaModel.genericParam;
    }

    public byte[] getBlob(int index) {
        return this.blobStream.getBlob(index);
    }

    public void registerEmbeddedTypeSpec(TypeSpecEntry embeddedTypeSpec) {
        if (!this.signatureEmbeddedTypeSpecs.contains(embeddedTypeSpec)) {
            this.signatureEmbeddedTypeSpecs.add(embeddedTypeSpec);
        }
    }

    public ArrayList<TypeSpecEntry> getEmbeddedTypeSpecs() {
        return this.signatureEmbeddedTypeSpecs;
    }
}

