/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.renderer;

import at.pollaknet.api.facile.code.ExceptionClause;
import at.pollaknet.api.facile.renderer.ILAsmRenderer;
import at.pollaknet.api.facile.symtab.symbols.Event;
import at.pollaknet.api.facile.symtab.symbols.ExportedType;
import at.pollaknet.api.facile.symtab.symbols.Field;
import at.pollaknet.api.facile.symtab.symbols.Method;
import at.pollaknet.api.facile.symtab.symbols.MethodSignature;
import at.pollaknet.api.facile.symtab.symbols.Parameter;
import at.pollaknet.api.facile.symtab.symbols.Property;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.meta.ManifestResource;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ILAsmFlagsRenderer {
    public static String renderMethodImplFlags(Method method) {
        if (method == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(64);
        int implFlags = method.getImplFlags();
        if (ByteReader.testFlags(implFlags, 3, 0)) {
            buffer.append("cil ");
        } else if (ByteReader.testFlags(implFlags, 3, 1)) {
            buffer.append("native ");
        } else if (ByteReader.testFlags(implFlags, 3, 2)) {
            buffer.append("optil ");
        } else if (ByteReader.testFlags(implFlags, 3, 3)) {
            buffer.append("runtime ");
        }
        if (ByteReader.testFlags(implFlags, 4, 0)) {
            buffer.append("managed ");
        } else if (ByteReader.testFlags(implFlags, 4, 4)) {
            buffer.append("unmanaged ");
        }
        if (ByteReader.testFlags(implFlags, 16)) {
            buffer.append("forwardref ");
        }
        if (ByteReader.testFlags(implFlags, 128)) {
            buffer.append("preservesig ");
        }
        if (ByteReader.testFlags(implFlags, 4096)) {
            buffer.append("internalcall ");
        }
        if (ByteReader.testFlags(implFlags, 32)) {
            buffer.append("synchronized ");
        }
        if (ByteReader.testFlags(implFlags, 8)) {
            buffer.append("noinlining ");
        }
        return buffer.toString();
    }

    public static String renderMethodFlags(Method method) {
        if (method == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(64);
        int flags = method.getFlags();
        if (ByteReader.testFlags(flags, 16)) {
            buffer.append("static ");
        }
        switch (flags & 7) {
            case 1: {
                buffer.append("private ");
                break;
            }
            case 6: {
                buffer.append("public ");
                break;
            }
            case 4: {
                buffer.append("family ");
                break;
            }
            case 3: {
                buffer.append("assembly ");
                break;
            }
            case 2: {
                buffer.append("famandassem ");
                break;
            }
            case 5: {
                buffer.append("famorassem ");
                break;
            }
            case 0: {
                buffer.append("privatescope ");
                break;
            }
        }
        if (ByteReader.testFlags(flags, 32)) {
            buffer.append("final ");
        }
        if (ByteReader.testFlags(flags, 64)) {
            buffer.append("virtual ");
        }
        if (ByteReader.testFlags(flags, 1024)) {
            buffer.append("abstract ");
        }
        if (ByteReader.testFlags(flags, 128)) {
            buffer.append("hidebysig ");
        }
        if (ByteReader.testFlags(flags, 256, 256)) {
            buffer.append("newslot ");
        }
        if (ByteReader.testFlags(flags, 32768)) {
            buffer.append("reqsecobj ");
        }
        if (ByteReader.testFlags(flags, 2048)) {
            buffer.append("specialname ");
        }
        if (ByteReader.testFlags(flags, 4096)) {
            buffer.append("rtspecialname ");
        }
        if (ByteReader.testFlags(flags, 8)) {
            buffer.append("unmanagedexp ");
        }
        if (ByteReader.testFlags(flags, 8192)) {
            if (method.getNativeImplementation() == null) {
                Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Found PInvokeImpl without valid name!");
                buffer.append("pinvokeimpl [UNABLE_TO_RESOLVE] ");
            } else {
                buffer.append("pinvokeimpl ");
                buffer.append(method.getNativeImplementation().getImportName());
                buffer.append(" ");
            }
        }
        return buffer.toString();
    }

    public static String renderParameterFlags(Parameter parameter) {
        if (parameter == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int flags = parameter.getFlags();
        if (ByteReader.testFlags(flags, 2)) {
            buffer.append("[out] ");
        } else if (ByteReader.testFlags(flags, 1)) {
            buffer.append("[in] ");
        }
        if (ByteReader.testFlags(flags, 16)) {
            buffer.append("[opt] ");
        }
        if (ByteReader.testFlags(flags, 53216)) {
            buffer.append("[unused] ");
        }
        if (ByteReader.testFlags(flags, 4096)) {
            buffer.append("[defval] ");
        }
        return buffer.toString();
    }

    public static String renderFieldFlags(Field field) {
        if (field == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int flags = field.getFlags();
        switch (flags & 7) {
            case 3: {
                buffer.append("assembly");
                break;
            }
            case 1: {
                buffer.append("private");
                break;
            }
            case 6: {
                buffer.append("public");
                break;
            }
            case 5: {
                buffer.append("famorassem");
                break;
            }
            case 2: {
                buffer.append("famandassem");
                break;
            }
            case 4: {
                buffer.append("family");
                break;
            }
            default: {
                buffer.append("privatescope");
            }
        }
        if (ByteReader.testFlags(flags, 16)) {
            buffer.append(" static");
        }
        if (ByteReader.testFlags(flags, 32)) {
            buffer.append(" initonly");
        }
        if (ByteReader.testFlags(flags, 128)) {
            buffer.append(" notserialized");
        }
        if (ByteReader.testFlags(flags, 512)) {
            buffer.append(" specialname");
        }
        return buffer.toString();
    }

    public static String renderTypeFlags(Type type) {
        if (type == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        long flags = type.getFlags();
        switch ((int)(flags & 7L)) {
            case 5: {
                buffer.append("nested assembly ");
                break;
            }
            case 2: {
                buffer.append("nested public ");
                break;
            }
            case 3: {
                buffer.append("nested private ");
                break;
            }
            case 4: {
                buffer.append("nested family ");
                break;
            }
            case 7: {
                buffer.append("nested famorassem ");
                break;
            }
            case 6: {
                buffer.append("nested famandassem ");
                break;
            }
            case 0: {
                buffer.append("private ");
                break;
            }
            case 1: {
                buffer.append("public ");
                break;
            }
        }
        if (type.isInheritedFrom("System.ValueType")) {
            buffer.append("value ");
        } else if (type.isInheritedFrom("System.Enum")) {
            buffer.append("enum ");
        }
        if (type.isInterface()) {
            buffer.append("interface ");
        }
        if (ByteReader.testFlags(flags, 256L)) {
            buffer.append("sealed ");
        }
        if (ByteReader.testFlags(flags, 128L)) {
            buffer.append("abstract ");
        }
        if (ByteReader.testFlags(flags, 24L, 0L)) {
            buffer.append("auto ");
        } else {
            if (ByteReader.testFlags(flags, 8L)) {
                buffer.append("sequential ");
            }
            if (ByteReader.testFlags(flags, 16L)) {
                buffer.append("explicit ");
            }
        }
        if (ByteReader.testFlags(flags, 196608L, 0L)) {
            buffer.append("ansi ");
        } else if (ByteReader.testFlags(flags, 196608L, 65536L)) {
            buffer.append("unicode ");
        } else if (ByteReader.testFlags(flags, 196608L, 131072L)) {
            buffer.append("autochar ");
        } else if (ByteReader.testFlags(flags, 196608L, 196608L)) {
            String name = type.getFullQualifiedName();
            if (name == null || name.equals("")) {
                name = "[Unknown Type]";
            }
            Logger.getLogger("at.pollaknet.api.facile").log(Level.SEVERE, "Flags with unknown notation detected in " + name + "!");
        }
        if (ByteReader.testFlags(flags, 4096L)) {
            buffer.append("import ");
        }
        if (ByteReader.testFlags(flags, 8192L)) {
            buffer.append("serializeable ");
        }
        if (ByteReader.testFlags(flags, 0x100000L)) {
            buffer.append("beforefieldinit ");
        }
        if (ByteReader.testFlags(flags, 1024L)) {
            buffer.append("specialname ");
        }
        if (ByteReader.testFlags(flags, 2048L)) {
            buffer.append("rtspecialname ");
        }
        return buffer.toString();
    }

    public static String renderMethodSignatureFlags(MethodSignature signature) {
        if (signature == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        byte flags = signature.getFlags();
        switch (flags & 0x60) {
            case 32: {
                buffer.append("instance ");
                break;
            }
            case 64: {
                buffer.append("explicit ");
                break;
            }
        }
        switch (flags & 0x17) {
            case 0: {
                buffer.append("default ");
                break;
            }
            case 5: {
                buffer.append("vararg ");
                break;
            }
            case 1: {
                buffer.append("unmanaged cdecl ");
                break;
            }
            case 4: {
                buffer.append("unmanaged fastcall ");
                break;
            }
            case 2: {
                buffer.append("unmanaged stdcall ");
                break;
            }
            case 3: {
                buffer.append("unmanaged thiscall ");
                break;
            }
        }
        return buffer.toString();
    }

    public static String renderExportedTypeFlags(ExportedType exportedType) {
        if (exportedType == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        long flags = exportedType.getFlags();
        if (ByteReader.testAny(flags, 2L)) {
            buffer.append("nested public ");
        } else if (ByteReader.testAny(flags, 2L)) {
            buffer.append("public ");
        } else if (ByteReader.testAny(flags, 0x200000L)) {
            buffer.append("public ");
        }
        return buffer.toString();
    }

    public static String renderManifestResourceFlags(ManifestResource manifestResource) {
        if (manifestResource == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        long flags = manifestResource.getFlags();
        if (ByteReader.testAny(flags, 1L)) {
            buffer.append("nested public ");
        } else if (ByteReader.testAny(flags, 2L)) {
            buffer.append("public ");
        }
        return buffer.toString();
    }

    public static String renderPropertyFlags(Property property) {
        if (property == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        long flags = property.getFlags();
        if (ByteReader.testFlags(flags, 512L)) {
            buffer.append("specialname ");
        }
        if (ByteReader.testFlags(flags, 1024L)) {
            buffer.append("rtspecialname ");
        }
        return buffer.toString();
    }

    public static String renderExceptionClauseFlags(ILAsmRenderer r, ExceptionClause e) {
        if (r == null || e == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        long flags = e.getFlags();
        if (flags == 0L) {
            buffer.append("catch ");
            if (e.getExceptionType() == null) {
                buffer.append("[mscorlib]System.Exception");
            } else {
                buffer.append(r.renderAsReference(e.getExceptionType()));
            }
            buffer.append(" handler ");
        } else if (flags == 1L) {
            buffer.append(String.format("filter IL_%04x handler", e.getFilterOffset()));
        } else if (flags == 2L) {
            buffer.append("finally handler ");
        } else {
            buffer.append("fault handler ");
        }
        return buffer.toString();
    }

    public static String renderEventFlags(Event event) {
        if (event == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int flags = event.getFlags();
        if (ByteReader.testFlags(flags, 512)) {
            buffer.append("specialname ");
        }
        if (ByteReader.testFlags(flags, 1024)) {
            buffer.append("rtspecialname ");
        }
        return buffer.toString();
    }
}

