/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.pdb.dia;

import at.pollaknet.api.facile.exception.NativeImplementationException;
import at.pollaknet.api.facile.pdb.DebugInformation;
import at.pollaknet.api.facile.pdb.PdbReader;
import at.pollaknet.api.facile.pdb.UnexpectedPdbContent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class NativePdbReader
implements PdbReader {
    private static final boolean ENABLE_DEBUG = false;
    private static final String CLASS_NAME = "NativePdbReader";
    private static boolean nativeLibraryLoaded;
    private static final int SUCCESS = 0;
    private static final int ERROR_COM_INIT_FAILED = -1;
    private static final int ERROR_DIA_INIT_FAILED = -2;
    private static final int ERROR_OUT_OF_MEMORY = -3;
    private static final int ERROR_PDB_NOT_FOUND = -4;
    private static final int ERROR_DIA_SESSION_FAILED = -5;
    private static final int ERROR_NO_GLOBAL_SCOPE_FOUND = -6;
    private static final int ERROR_FIELD_NOT_FOUND = -7;
    private long nativeHandle = 0L;

    private native int openPdb(String var1);

    @Override
    public native DebugInformation getLineNumbersByRVA(long var1);

    private native void closePdb();

    public NativePdbReader() throws NativeImplementationException {
        if (!nativeLibraryLoaded) {
            throw new NativeImplementationException("Unable to locate NativePdbReader.dll in the bin folder of the dia package!");
        }
    }

    @Override
    public void open(String pathToPdbFile) throws NativeImplementationException, FileNotFoundException, UnexpectedPdbContent {
        int returnCode = this.openPdb(pathToPdbFile);
        if (returnCode != 0) {
            this.close();
            switch (returnCode) {
                case -1: {
                    throw new NativeImplementationException("Initialization of the COM interface failed.");
                }
                case -2: {
                    throw new NativeImplementationException("Initialization of the msdia interface failed.");
                }
                case -3: {
                    throw new OutOfMemoryError();
                }
                case -4: {
                    throw new FileNotFoundException(pathToPdbFile);
                }
                case -5: {
                    throw new UnexpectedPdbContent("Unable to open a valid dia session.");
                }
                case -6: {
                    throw new UnexpectedPdbContent("No global scope found.");
                }
                case -7: {
                    throw new NativeImplementationException("The field \"long nativeHandle\" inside the PdbReader class is missing.");
                }
            }
            throw new NativeImplementationException("An unknown error occurred!");
        }
    }

    @Override
    public boolean close() {
        if (this.nativeHandle != 0L) {
            this.closePdb();
            assert (this.nativeHandle == 0L);
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private static String extractFromJar(String fileNameInArchive, String archivePath) throws SecurityException, IOException {
        URL url = new URL(archivePath);
        InputStream inputStream = url.openStream();
        ZipInputStream zipStream = new ZipInputStream(inputStream);
        ZipEntry entry = null;
        do {
            if (entry == null) continue;
            zipStream.closeEntry();
        } while ((entry = zipStream.getNextEntry()) != null && !entry.getName().endsWith(fileNameInArchive));
        if (entry == null) {
            zipStream.closeEntry();
            zipStream.close();
            inputStream.close();
            throw new FileNotFoundException("Unable to locate " + fileNameInArchive + " in " + archivePath);
        }
        String directory = System.getProperty("user.home") + System.getProperty("file.separator") + ".facileTemp";
        File dir = new File(directory);
        dir.mkdirs();
        archivePath = directory + System.getProperty("file.separator") + CLASS_NAME + ".dll";
        FileOutputStream outputStream = new FileOutputStream(archivePath);
        int c = zipStream.read();
        while (c != -1) {
            outputStream.write(c);
            c = zipStream.read();
        }
        zipStream.closeEntry();
        zipStream.close();
        inputStream.close();
        outputStream.close();
        return "file:/" + archivePath;
    }

    static {
        String binaryName;
        URL dllUrl;
        nativeLibraryLoaded = false;
        String archDataModel = System.getProperty("sun.arch.data.model");
        if (!archDataModel.equals("32") || !archDataModel.equals("64")) {
            String string = archDataModel = System.getProperty("os.arch").endsWith("64") ? "64" : "32";
        }
        if ((dllUrl = NativePdbReader.class.getResource(binaryName = "bin" + archDataModel + System.getProperty("file.separator") + CLASS_NAME + archDataModel + ".dll")) == null) {
            Logger logger = Logger.getLogger("at.pollaknet.api.facile");
            logger.log(Level.SEVERE, "Unable to locate " + binaryName);
        } else {
            Logger logger;
            String dllPath = dllUrl.toString();
            if (dllPath.startsWith("bundleresource:")) {
                try {
                    Class<?> converter = Class.forName("org.eclipse.core.runtime.internal.adaptor.URLConverterImpl");
                    Object instance = converter.newInstance();
                    for (Method m : converter.getMethods()) {
                        if (!m.getName().equals("toFileURL")) continue;
                        dllUrl = (URL)m.invoke(instance, dllUrl);
                        dllPath = dllUrl.toString();
                    }
                }
                catch (Exception e) {
                    logger = Logger.getLogger("at.pollaknet.api.facile");
                    logger.log(Level.SEVERE, e.getMessage());
                }
            } else if (dllPath.startsWith("jar:file:")) {
                dllPath = dllPath.substring(4);
                dllPath = dllPath.substring(0, dllPath.lastIndexOf(33));
                try {
                    dllPath = NativePdbReader.extractFromJar(binaryName, dllPath);
                }
                catch (SecurityException e) {
                    logger = Logger.getLogger("at.pollaknet.api.facile");
                    logger.log(Level.SEVERE, "SecurityException: unable to access \"" + dllPath + "\": " + e.getMessage());
                }
                catch (Exception e) {
                    logger = Logger.getLogger("at.pollaknet.api.facile");
                    logger.log(Level.SEVERE, e.getMessage());
                }
            }
            try {
                if (!dllPath.startsWith("file:")) {
                    throw new Exception("Unknown resource format: " + dllPath);
                }
                dllPath = dllPath.contains(" ") ? dllPath.substring(6) : dllUrl.toURI().getPath().substring(1);
                System.load(dllPath);
                nativeLibraryLoaded = true;
            }
            catch (UnsatisfiedLinkError e) {
                logger = Logger.getLogger("at.pollaknet.api.facile");
                logger.log(Level.SEVERE, "UnsatisfiedLinkError: Unable to locate " + dllPath + ": " + e.getMessage());
            }
            catch (URISyntaxException e) {
                logger = Logger.getLogger("at.pollaknet.api.facile");
                logger.log(Level.SEVERE, "URISyntaxException: Unable to convert the NativePdbReader" + archDataModel + ".dll location (\"" + dllPath + "\") to a valid URI: " + e.getMessage());
            }
            catch (Exception e) {
                logger = Logger.getLogger("at.pollaknet.api.facile");
                logger.log(Level.SEVERE, e.getMessage());
            }
        }
    }
}

