/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.pdb;

import at.pollaknet.api.facile.pdb.DebugInformation;
import at.pollaknet.api.facile.pdb.Instruction;
import at.pollaknet.api.facile.pdb.InstructionInfo;
import java.util.ArrayList;

public class LineNumberInfo
implements DebugInformation {
    private String sourceFileName;
    private ArrayList<InstructionInfo> instructionList = new ArrayList();

    public void addInstruction(long lineNumber, long colNumber, long colEndNumber, long programCounter) {
        this.instructionList.add(new Instruction(lineNumber, colNumber, colEndNumber, programCounter));
    }

    @Override
    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    @Override
    public InstructionInfo[] getInstructionInfos() {
        if (this.instructionList == null || this.instructionList.size() == 0) {
            return new InstructionInfo[0];
        }
        return this.instructionList.toArray(new InstructionInfo[this.instructionList.size()]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.instructionList.size() * 22);
        if (this.sourceFileName != null) {
            buffer.append(this.sourceFileName);
        } else {
            buffer.append("<Unknown source file>");
        }
        buffer.append(" {");
        for (InstructionInfo s : this.instructionList) {
            buffer.append(String.format("PC(0x%x)@Line(%d) ", s.getProgramCounter(), s.getLineNumber()));
        }
        buffer.append("}");
        return buffer.toString();
    }
}

