/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.entries.TypeDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ITypeDefOrRef;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.signature.ArrayShape;
import at.pollaknet.api.facile.symtab.symbols.MethodSignature;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.TypeSpec;
import at.pollaknet.api.facile.symtab.symbols.aggregation.MethodAndFieldParent;
import at.pollaknet.api.facile.symtab.symbols.aggregation.ResolutionScope;
import at.pollaknet.api.facile.symtab.symbols.scopes.ModuleRef;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.ArrayList;
import java.util.Arrays;

public class TypeSpecEntry
extends TypeRefEntry
implements ITypeDefOrRef,
IHasCustomAttribute,
MethodAndFieldParent,
TypeSpec,
TypeRef {
    private static final int FLAGS_IS_POINTER = 1;
    private static final int FLAGS_IS_FUNCTION_POINTER = 2;
    private static final int FLAGS_IS_VALUE_TYPE = 4;
    private static final int FLAGS_IS_CLASS = 8;
    private static final int FLAGS_IS_SINGLE_DIM_ARRAY = 16;
    private static final int FLAGS_IS_GENERAL_ARRAY = 32;
    private static final int FLAGS_IS_TYPE_BY_REF = 64;
    private static final int FLAGS_IS_GENERIC_INSTANCE = 128;
    private static final int FLAGS_IS_PINNED = 256;
    private static final int FLAGS_IS_BOXED = 512;
    private byte[] binarySignature;
    private TypeRefEntry enclosedType = null;
    private ArrayList<TypeSpec> optionalModifiers = null;
    private ArrayList<TypeSpec> requiredModifiers = null;
    private int flags;
    private MethodSignature functionPointer = null;
    private int genericNumber = -1;
    private boolean genericBelongsToMethod = false;
    private ArrayShape arrayShape = null;
    private TypeRefEntry[] genericArguments = null;
    private boolean isBasicType = false;
    private int pointer = 0;

    @Override
    public void setName(String name) {
        if (this.name == null) {
            super.setName(name);
        } else {
            assert (this.enclosedType != null);
            this.enclosedType.setName(name);
        }
    }

    public byte[] getBinarySignature() {
        return this.binarySignature;
    }

    public void setSignature(byte[] binarySignature) {
        this.binarySignature = binarySignature;
    }

    @Override
    public String toString() {
        return String.format("TypeSpec: %s ResoltionScope: %s", this.getFullQualifiedName(), this.resolutionScope == null ? "[not set]" : this.resolutionScope.getName());
    }

    @Override
    public String getNamespace() {
        if (this.namespace == null && this.enclosedType != null) {
            return this.enclosedType.getNamespace();
        }
        return this.namespace;
    }

    @Override
    public String getName() {
        if (this.name == null && this.enclosedType != null) {
            return this.enclosedType.getName();
        }
        return this.name;
    }

    @Override
    public String getFullQualifiedName() {
        String namespace = this.getNamespace();
        if (namespace == null || namespace.length() == 0) {
            return this.getName();
        }
        return this.getNamespace() + this.namespaceSeparator + this.getName();
    }

    @Override
    public void adjustNamespace(ModuleRef moduleRef) {
        TypeRefEntry enclosedTypeRef = this;
        while (((TypeRefEntry)enclosedTypeRef).getTypeSpec() != null && ((TypeRefEntry)enclosedTypeRef).getTypeSpec().getEnclosedTypeRef() != null) {
            enclosedTypeRef = ((TypeRefEntry)enclosedTypeRef).getTypeSpec().getEnclosedTypeRef();
        }
        this.adjustNamespace(enclosedTypeRef, moduleRef);
    }

    @Override
    public String getExtName() {
        String shortName;
        StringBuffer buffer = new StringBuffer();
        if (this.getName() != null) {
            buffer.append(this.getName());
        } else if (this.enclosedType != null) {
            TypeSpecEntry enclosedTypeSpec = this.enclosedType.getTypeSpec();
            if (enclosedTypeSpec != null) {
                buffer.append(enclosedTypeSpec.getExtName());
            } else {
                shortName = this.enclosedType.getShortSystemName();
                buffer.append(shortName != null ? shortName : this.enclosedType.getName());
            }
            if (this.isSingleDimensionalZeroBasedArray()) {
                buffer.append("[]");
            } else if (this.isGeneralArray()) {
                buffer.append("[");
                for (int i = 1; i < this.getArrayShape().getRank(); ++i) {
                    buffer.append(",");
                }
                buffer.append("]");
            } else if (!this.isBasicType) {
                TypeRef typeRef;
                ResolutionScope resolutionScope;
                if (this.isTypeByRef()) {
                    buffer.append(" &");
                }
                if (this.isPointer()) {
                    buffer.append(" *");
                }
                if (this.requiredModifiers != null) {
                    for (TypeSpec spec : this.requiredModifiers) {
                        resolutionScope = spec.getResolutionScope();
                        typeRef = spec;
                        while ((resolutionScope == null || resolutionScope.isInAssembly()) && typeRef.getTypeSpec() != null && typeRef.getTypeSpec().getEnclosedTypeRef() != null) {
                            typeRef = typeRef.getTypeSpec().getEnclosedTypeRef();
                            resolutionScope = typeRef.getResolutionScope();
                        }
                        buffer.append(" modreq(");
                        if (resolutionScope != null && !resolutionScope.isInAssembly()) {
                            buffer.append("[");
                            buffer.append(resolutionScope.getName());
                            buffer.append("] ");
                        }
                        buffer.append(spec.getExtName());
                        buffer.append(")");
                    }
                }
                if (this.optionalModifiers != null) {
                    for (TypeSpec spec : this.optionalModifiers) {
                        resolutionScope = spec.getResolutionScope();
                        typeRef = spec;
                        while ((resolutionScope == null || resolutionScope.isInAssembly()) && typeRef.getTypeSpec() != null && typeRef.getTypeSpec().getEnclosedTypeRef() != null) {
                            typeRef = typeRef.getTypeSpec().getEnclosedTypeRef();
                            resolutionScope = typeRef.getResolutionScope();
                        }
                        buffer.append(" modopt(");
                        if (resolutionScope != null && !resolutionScope.isInAssembly()) {
                            buffer.append("[");
                            buffer.append(resolutionScope.getName());
                            buffer.append("] ");
                        }
                        buffer.append(spec.getExtName());
                        buffer.append(")");
                    }
                }
            }
        } else if (this.binarySignature != null) {
            buffer.append("[Signature: ");
            buffer.append(ArrayUtils.formatByteArray(this.binarySignature));
            buffer.append("]");
        } else {
            buffer.append("[Signature: null]");
        }
        if (this.genericArguments != null) {
            buffer.append("<");
            for (int i = 0; i < this.genericArguments.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                if (this.genericArguments[i].getTypeSpec() != null && this.genericArguments[i].getTypeSpec().getGenericParameterNumber() >= 0) {
                    buffer.append("!");
                }
                buffer.append((shortName = this.genericArguments[i].getShortSystemName()) != null ? shortName : this.genericArguments[i].getFullQualifiedName());
            }
            buffer.append(">");
        }
        return buffer.toString();
    }

    @Override
    public String getExtFullQualifiedName() {
        String shortName;
        StringBuffer buffer = new StringBuffer();
        if (this.name != null) {
            buffer.append(this.getFullQualifiedName());
        } else if (this.enclosedType != null) {
            TypeSpecEntry enclosedTypeSpec = this.enclosedType.getTypeSpec();
            if (enclosedTypeSpec != null) {
                buffer.append(enclosedTypeSpec.getExtFullQualifiedName());
            } else {
                shortName = this.enclosedType.getShortSystemName();
                buffer.append(shortName != null ? shortName : this.enclosedType.getFullQualifiedName());
            }
            if (this.isSingleDimensionalZeroBasedArray()) {
                buffer.append("[]");
            } else if (this.isGeneralArray()) {
                buffer.append("[");
                for (int i = 1; i < this.getArrayShape().getRank(); ++i) {
                    buffer.append(",");
                }
                buffer.append("]");
            } else if (!this.isBasicType()) {
                TypeRef typeRef;
                ResolutionScope resolutionScope;
                if (this.isTypeByRef()) {
                    buffer.append(" &");
                }
                if (this.isPointer()) {
                    buffer.append(" *");
                }
                if (this.requiredModifiers != null) {
                    for (TypeSpec spec : this.requiredModifiers) {
                        resolutionScope = spec.getResolutionScope();
                        typeRef = spec;
                        while ((resolutionScope == null || resolutionScope.isInAssembly()) && typeRef.getTypeSpec() != null && typeRef.getTypeSpec().getEnclosedTypeRef() != null) {
                            typeRef = typeRef.getTypeSpec().getEnclosedTypeRef();
                            resolutionScope = typeRef.getResolutionScope();
                        }
                        buffer.append(" modreq(");
                        if (resolutionScope != null && !resolutionScope.isInAssembly()) {
                            buffer.append("[");
                            buffer.append(resolutionScope.getName());
                            buffer.append("] ");
                        }
                        buffer.append(spec.getExtFullQualifiedName());
                        buffer.append(")");
                    }
                }
                if (this.optionalModifiers != null) {
                    for (TypeSpec spec : this.optionalModifiers) {
                        resolutionScope = spec.getResolutionScope();
                        typeRef = spec;
                        while ((resolutionScope == null || resolutionScope.isInAssembly()) && typeRef.getTypeSpec() != null && typeRef.getTypeSpec().getEnclosedTypeRef() != null) {
                            typeRef = typeRef.getTypeSpec().getEnclosedTypeRef();
                            resolutionScope = typeRef.getResolutionScope();
                        }
                        buffer.append(" modopt(");
                        if (resolutionScope != null && !resolutionScope.isInAssembly()) {
                            buffer.append("[");
                            buffer.append(resolutionScope.getName());
                            buffer.append("] ");
                        }
                        buffer.append(spec.getExtFullQualifiedName());
                        buffer.append(")");
                    }
                }
            }
        } else if (this.binarySignature != null) {
            buffer.append("[Signature: ");
            buffer.append(ArrayUtils.formatByteArray(this.binarySignature));
            buffer.append("]");
        } else {
            buffer.append("[Signature: null]");
        }
        if (this.genericArguments != null) {
            buffer.append("<");
            for (int i = 0; i < this.genericArguments.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                if (this.genericArguments[i].getTypeSpec() != null && this.genericArguments[i].getTypeSpec().getGenericParameterNumber() >= 0) {
                    buffer.append("!");
                }
                buffer.append((shortName = this.genericArguments[i].getShortSystemName()) != null ? shortName : this.genericArguments[i].getFullQualifiedName());
            }
            buffer.append(">");
        }
        return buffer.toString();
    }

    public void addOptionalModifier(TypeSpec optionalOrReqType) {
        if (this.optionalModifiers == null) {
            this.optionalModifiers = new ArrayList(4);
        }
        this.optionalModifiers.add(optionalOrReqType);
    }

    @Override
    public TypeSpec[] buildOptionalModifierArray() {
        if (this.optionalModifiers == null || this.optionalModifiers.size() == 0) {
            return new TypeSpec[0];
        }
        TypeSpec[] modifiers = new TypeSpec[this.optionalModifiers.size()];
        this.optionalModifiers.toArray(modifiers);
        return modifiers;
    }

    public void addRequiredModifier(TypeSpec modifier) {
        if (this.requiredModifiers == null) {
            this.requiredModifiers = new ArrayList(4);
        }
        this.requiredModifiers.add(modifier);
    }

    @Override
    public TypeSpec[] buildRequiredModifierArray() {
        if (this.requiredModifiers == null || this.requiredModifiers.size() == 0) {
            return new TypeSpec[0];
        }
        TypeSpec[] modifiers = new TypeSpec[this.requiredModifiers.size()];
        this.requiredModifiers.toArray(modifiers);
        return modifiers;
    }

    @Override
    public TypeRefEntry getTypeRef() {
        return this;
    }

    @Override
    public TypeRefEntry getEnclosedTypeRef() {
        return this.enclosedType;
    }

    @Override
    public TypeRefEntry getMostInnerEnclosedTypeRef() {
        if (this.enclosedType == null) {
            return this;
        }
        TypeRefEntry typeRef = this.enclosedType;
        TypeSpecEntry typeSpec = this.enclosedType.getTypeSpec();
        while (typeSpec != null && typeSpec.getEnclosedTypeRef() != null) {
            typeRef = typeSpec.getEnclosedTypeRef();
            typeSpec = typeRef.getTypeSpec();
        }
        return typeRef;
    }

    @Override
    public TypeSpecEntry getMostInnerEnclosedTypeSpec() {
        if (this.enclosedType == null) {
            return this;
        }
        TypeSpecEntry typeSpec = this.enclosedType.getTypeSpec();
        if (typeSpec == null) {
            return this;
        }
        while (typeSpec.getEnclosedTypeRef() != null && typeSpec.getEnclosedTypeRef().getTypeSpec() != null) {
            typeSpec = typeSpec.getEnclosedTypeRef().getTypeSpec();
        }
        return typeSpec;
    }

    public void setEnclosedTypeRef(TypeRefEntry type) {
        this.enclosedType = type;
    }

    public void setTypeByRef(boolean typeByRef) {
        this.flags = typeByRef ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    @Override
    public boolean isTypeByRef() {
        return ByteReader.testFlags(this.flags, 64);
    }

    public void setSingleDimensionalZeroBasedArray(boolean isArray) {
        this.flags = isArray ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    @Override
    public boolean isSingleDimensionalZeroBasedArray() {
        return ByteReader.testFlags(this.flags, 16);
    }

    public void setGeneralArray(boolean isArray) {
        this.flags = isArray ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    @Override
    public boolean isGeneralArray() {
        return ByteReader.testFlags(this.flags, 32);
    }

    @Override
    public boolean isArray() {
        return ByteReader.testAny(this.flags, 48);
    }

    public void setAsClass(boolean clazz) {
        this.flags = clazz ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public boolean isClass() {
        return ByteReader.testFlags(this.flags, 8);
    }

    public void setAsFunctionPointer(boolean functionPointer) {
        this.flags = functionPointer ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    public boolean isFunctionPointer() {
        return ByteReader.testFlags(this.flags, 2);
    }

    public void setAsValueType(boolean valueType) {
        this.flags = valueType ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public boolean isValueType() {
        return ByteReader.testFlags(this.flags, 4);
    }

    public void incPointer() {
        this.flags |= 1;
        ++this.pointer;
    }

    public int getPointers() {
        return this.pointer;
    }

    @Override
    public boolean isPointer() {
        return ByteReader.testFlags(this.flags, 1);
    }

    public void setAsGenericInstance(boolean generic) {
        this.flags = generic ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }

    @Override
    public boolean isGeneric() {
        return ByteReader.testFlags(this.flags, 128);
    }

    @Override
    public boolean isGenericInstance() {
        return this.genericNumber >= 0;
    }

    public void setAsPinned(boolean pinned) {
        this.flags = pinned ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    @Override
    public boolean isPinned() {
        return ByteReader.testFlags(this.flags, 256);
    }

    public void setAsBoxed(boolean boxed) {
        this.flags = boxed ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    @Override
    public boolean isBoxed() {
        return ByteReader.testFlags(this.flags, 512);
    }

    public void evaluateBasicType() {
        this.isBasicType = !(this.enclosedType != null || this.optionalModifiers != null && this.optionalModifiers.size() != 0 || this.requiredModifiers != null && this.requiredModifiers.size() != 0 || this.flags != 0 || this.functionPointer != null || this.genericNumber != -1 || this.arrayShape != null || this.genericArguments != null);
    }

    public void setFunctionPointer(MethodSignature function) {
        this.functionPointer = function;
    }

    @Override
    public MethodSignature getFunctionPointer() {
        return this.functionPointer;
    }

    public void setAsGenericParameter(int genericNumber, boolean belongsToMethod) {
        this.genericNumber = genericNumber;
        this.genericBelongsToMethod = belongsToMethod;
    }

    @Override
    public int getGenericParameterNumber() {
        return this.genericNumber;
    }

    @Override
    public boolean isGenericMethodParameter() {
        return this.genericBelongsToMethod;
    }

    public void setArrayShape(ArrayShape arrayShape) {
        this.arrayShape = arrayShape;
    }

    @Override
    public ArrayShape getArrayShape() {
        return this.arrayShape;
    }

    public void setGenericArguments(TypeRefEntry[] genericTypes) {
        assert (this.genericArguments == null);
        this.genericArguments = genericTypes;
    }

    public TypeRefEntry[] getGenericArguments() {
        return this.genericArguments;
    }

    @Override
    public TypeSpecEntry getTypeSpec() {
        return this;
    }

    @Override
    public boolean isBasicType() {
        return this.isBasicType;
    }

    public void propagateGenericArguments() {
        block2: {
            TypeDefEntry type;
            block3: {
                if (this.enclosedType == null || this.genericArguments == null) break block2;
                TypeSpecEntry typeSpec = this.enclosedType.getTypeSpec();
                type = this.enclosedType.getType();
                if (typeSpec == null) break block3;
                typeSpec.propagateGenericArguments();
                for (int i = 0; i < this.genericArguments.length; ++i) {
                    if (this.genericArguments[i].getName() != null) continue;
                    this.genericArguments[i] = typeSpec.genericArguments[i];
                }
                break block2;
            }
            if (type == null) break block2;
            for (int i = 0; i < this.genericArguments.length; ++i) {
                if (this.genericArguments[i].getName() != null) continue;
                this.genericArguments[i].setName(type.getGenericParameters()[i].getName());
            }
        }
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return renderer.renderAsReference(this);
    }

    @Override
    public int compareTo(TypeRef other) {
        if (other == null || other.getTypeSpec() == null) {
            return Integer.MAX_VALUE;
        }
        return ArrayUtils.compareStrings(other.getFullQualifiedName(), this.getFullQualifiedName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.binarySignature);
        result = 31 * result + this.flags;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeSpecEntry other = (TypeSpecEntry)obj;
        if (!Arrays.equals(this.binarySignature, other.binarySignature)) {
            return false;
        }
        return this.flags == other.flags;
    }
}

