/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.AbstractMethodRefSignature;
import at.pollaknet.api.facile.metamodel.entries.MemberRefEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeSpecEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ICustomAttributeType;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.INamespaceOwner;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ITypeDefOrRef;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.NamespaceContainer;
import at.pollaknet.api.facile.symtab.TypeKind;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.aggregation.MethodAndFieldParent;
import at.pollaknet.api.facile.symtab.symbols.aggregation.Namespace;
import at.pollaknet.api.facile.symtab.symbols.aggregation.ResolutionScope;
import at.pollaknet.api.facile.symtab.symbols.meta.AttributableSymbol;
import at.pollaknet.api.facile.symtab.symbols.scopes.AssemblyRef;
import at.pollaknet.api.facile.symtab.symbols.scopes.Module;
import at.pollaknet.api.facile.symtab.symbols.scopes.ModuleRef;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.Arrays;

public class TypeRefEntry
extends AbstractMethodRefSignature
implements ResolutionScope,
INamespaceOwner,
ITypeDefOrRef,
IHasCustomAttribute,
MethodAndFieldParent,
TypeRef,
AttributableSymbol,
ICustomAttributeType {
    protected ResolutionScope resolutionScope;
    protected String name = null;
    protected String namespace = null;
    protected String shortName = null;
    private int kind;
    protected char namespaceSeparator = (char)46;
    private NamespaceContainer[] namespaces = new NamespaceContainer[0];

    public TypeRefEntry() {
    }

    public TypeRefEntry(ResolutionScope systemScope, String name) {
        this.setName(name);
        this.setNamespace("System");
        this.setResolutionScope(systemScope);
    }

    public TypeRefEntry(ResolutionScope systemScope, String name, String shortName) {
        this.setName(name);
        this.setNamespace("System");
        this.setResolutionScope(systemScope);
        this.setShortSystemName(shortName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        assert (this.name == null);
        this.name = name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String nameSpace) {
        this.namespace = nameSpace;
    }

    public void setResolutionScope(ResolutionScope resolutionScope) {
        this.resolutionScope = resolutionScope;
    }

    @Override
    public ResolutionScope getResolutionScope() {
        return this.resolutionScope;
    }

    @Override
    public String getFullQualifiedName() {
        if (this.namespace == null || this.namespace.equals("")) {
            return this.name;
        }
        return this.namespace + this.namespaceSeparator + this.name;
    }

    public String toString() {
        return String.format("TypeRef: %s ResolutionScope: %s", this.getFullQualifiedName(), this.getResolutionScope() != null ? this.getResolutionScope().getName() : "[not set]");
    }

    @Override
    public TypeDefEntry getType() {
        return null;
    }

    @Override
    public TypeRefEntry getTypeRef() {
        return this;
    }

    @Override
    public AssemblyRef getAssemblyRef() {
        ResolutionScope resolutionScope = this.getResolutionScope();
        return resolutionScope == null || resolutionScope == this ? null : resolutionScope.getAssemblyRef();
    }

    @Override
    public Module getModule() {
        ResolutionScope resolutionScope = this.getResolutionScope();
        return resolutionScope == null || resolutionScope == this ? null : resolutionScope.getModule();
    }

    @Override
    public ModuleRef getModuleRef() {
        ResolutionScope resolutionScope = this.getResolutionScope();
        return resolutionScope == null || resolutionScope == this ? null : resolutionScope.getModuleRef();
    }

    @Override
    public MethodDefEntry getMethod() {
        return null;
    }

    @Override
    public MemberRefEntry getMemberRef() {
        return null;
    }

    @Override
    public TypeSpecEntry getTypeSpec() {
        return null;
    }

    @Override
    public int getElementTypeKind() {
        return this.kind;
    }

    public void setElementKind(int kind) {
        this.kind = kind;
    }

    @Override
    public void setNamespaces(NamespaceContainer[] namespaces) {
        this.namespaces = namespaces;
    }

    public NamespaceContainer[] getNamespaces() {
        return this.namespaces;
    }

    @Override
    public boolean isInAssembly() {
        if (this.resolutionScope == null) {
            return true;
        }
        return this.resolutionScope.isInAssembly();
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return renderer.renderAsReference(this);
    }

    public void setShortSystemName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getShortSystemName() {
        return this.shortName;
    }

    @Override
    public int compareTo(TypeRef other) {
        return ArrayUtils.compareStrings(other.getFullQualifiedName(), this.getFullQualifiedName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 + this.kind;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.resolutionScope == null ? 0 : (this.resolutionScope.getName() == null ? 0 : this.resolutionScope.getName().hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeRefEntry other = (TypeRefEntry)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (!Arrays.equals(this.namespaces, other.namespaces)) {
            return false;
        }
        if (this.resolutionScope == null) {
            return other.resolutionScope == null;
        }
        if (other.resolutionScope == null) {
            return false;
        }
        if (this.resolutionScope.getName() != null) {
            return this.resolutionScope.getName().equals(other.resolutionScope.getName());
        }
        return true;
    }

    @Override
    public boolean isClass() {
        return !ArrayUtils.contains(TypeKind.NUMERIC_TYPES, this.kind) && !this.isValueType();
    }

    @Override
    public boolean isValueType() {
        return this.kind == 17 || this.getType() != null && this.getType().isInheritedFrom("System.ValueType");
    }

    public void adjustNamespace(ModuleRef moduleRef) {
        this.adjustNamespace(this, moduleRef);
    }

    protected void adjustNamespace(TypeRefEntry typeRef, ModuleRef moduleRef) {
        if (typeRef.getResolutionScope() == null) {
            return;
        }
        Module parentModule = typeRef.getResolutionScope().getModule();
        if (parentModule == null) {
            return;
        }
        String parentModuleNamespace = parentModule.getFullQualifiedName();
        String moduleRefNamespace = moduleRef.getFullQualifiedName();
        if (parentModuleNamespace != null && moduleRefNamespace != null && parentModuleNamespace.equals(moduleRefNamespace)) {
            return;
        }
        String enclosedFullQualifiedName = typeRef.getFullQualifiedName();
        String enclosedNamespace = typeRef.getNamespace();
        Namespace[] definedNamespaces = parentModule.getNamespaces();
        if (enclosedNamespace != null && definedNamespaces != null && definedNamespaces.length > 0) {
            int longestMatch = -1;
            for (int i = 0; i < definedNamespaces.length; ++i) {
                if (enclosedNamespace.equals(definedNamespaces[i].getNamespace())) {
                    return;
                }
                if (!definedNamespaces[i].isSuperNamespace(enclosedNamespace) || longestMatch >= 0 && definedNamespaces[longestMatch].getAddress().length >= definedNamespaces[i].getAddress().length) continue;
                longestMatch = i;
            }
            if (longestMatch > 0) {
                int lengthWithDot = definedNamespaces[longestMatch].getNamespace().length() + 1;
                if (enclosedFullQualifiedName.length() > lengthWithDot) {
                    String[] nameParts = enclosedFullQualifiedName.split("\\.|\\/");
                    String[] currentAddress = definedNamespaces[longestMatch].getAddress();
                    String modifiedNamespace = definedNamespaces[longestMatch].getNamespace();
                    for (int i = currentAddress.length; i < nameParts.length - 1; ++i) {
                        modifiedNamespace = i == currentAddress.length ? modifiedNamespace + '.' + nameParts[i] : modifiedNamespace + '/' + nameParts[i];
                    }
                    typeRef.setNamespace(modifiedNamespace);
                }
                this.namespaceSeparator = (char)47;
            }
        }
    }
}

