/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.entries.ClassLayoutEntry;
import at.pollaknet.api.facile.metamodel.entries.ConstantEntry;
import at.pollaknet.api.facile.metamodel.entries.DeclSecurityEntry;
import at.pollaknet.api.facile.metamodel.entries.FieldEntry;
import at.pollaknet.api.facile.metamodel.entries.GenericParamEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.PropertyEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasDeclSecurity;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ITypeDefOrRef;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ITypeOrMethodDef;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.signature.Permission;
import at.pollaknet.api.facile.symtab.symbols.ClassLayout;
import at.pollaknet.api.facile.symtab.symbols.Event;
import at.pollaknet.api.facile.symtab.symbols.Parameter;
import at.pollaknet.api.facile.symtab.symbols.Property;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.aggregation.MethodAndFieldParent;
import at.pollaknet.api.facile.symtab.symbols.meta.DeclarativeSecurity;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.ByteReader;
import java.util.ArrayList;
import java.util.Arrays;

public class TypeDefEntry
extends TypeRefEntry
implements ITypeDefOrRef,
IHasCustomAttribute,
IHasDeclSecurity,
MethodAndFieldParent,
ITypeOrMethodDef,
Type {
    private byte internalFlags;
    private static final byte INT_FLAGS_SORTED_FIELDS = 1;
    private static final byte INT_FLAGS_SORTED_METHODS = 2;
    private static final byte INT_FLAGS_SORTED_PROPERTIES = 4;
    private static final byte INT_FLAGS_SORTED_EVENTS = 8;
    private static final byte INT_FLAGS_IS_EXPORTED = 16;
    private static final byte INT_FLAGS_IS_NESTED = 32;
    private long flags;
    private ITypeDefOrRef extendz;
    private FieldEntry[] fields;
    private MethodDefEntry[] methods;
    private ClassLayoutEntry classLayout;
    private ConstantEntry[] constantEntries;
    private DeclSecurityEntry declSecurityEntry;
    private Property[] properties;
    private Event[] events;
    private ArrayList<TypeRef> implementedInterfaces = null;
    private ArrayList<Type> enclosingClasses = null;
    private ArrayList<GenericParamEntry> genericParams = null;
    private ArrayList<MethodDefEntry> additionalMethods = null;

    @Override
    public boolean isClass() {
        return ByteReader.testFlags(this.flags, 0L);
    }

    @Override
    public boolean isInterface() {
        return ByteReader.testFlags(this.flags, 32L);
    }

    @Override
    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    @Override
    public TypeRef getExtends() {
        if (this.extendz == null) {
            return null;
        }
        return this.extendz.getTypeRef();
    }

    public void setExtends(ITypeDefOrRef extendz) {
        this.extendz = extendz;
    }

    public FieldEntry[] getFields() {
        if (this.fields == null) {
            return new FieldEntry[0];
        }
        if (!ByteReader.testFlags(this.internalFlags, (byte)1)) {
            ByteReader.setFlags(this.internalFlags, (byte)1, true);
            Arrays.sort(this.fields);
        }
        return this.fields;
    }

    public void setFields(FieldEntry[] fields) {
        if (fields != null) {
            for (FieldEntry field : fields) {
                field.setParent(this);
            }
            this.fields = fields;
        }
    }

    public boolean addMethod(MethodDefEntry method) {
        if (this.additionalMethods == null) {
            this.additionalMethods = new ArrayList(4);
        }
        return this.additionalMethods.add(method);
    }

    public void setMethods(MethodDefEntry[] methods) {
        this.methods = methods;
    }

    public MethodDefEntry[] getMethods() {
        if (this.methods == null) {
            return new MethodDefEntry[0];
        }
        if (!ByteReader.testFlags(this.internalFlags, (byte)2)) {
            ByteReader.setFlags(this.internalFlags, (byte)2, true);
            Arrays.sort(this.methods);
        }
        return this.methods;
    }

    @Override
    public String toString() {
        return String.format("TypeDef: %s%s (NumberOfFields: %d NumberOfMethods: %d; Flags: 0x%08x)", this.getFullQualifiedName(), this.extendz == null ? "" : " extends " + this.extendz.getFullQualifiedName(), this.fields == null ? 0 : this.fields.length, this.methods == null ? 0 : this.methods.length, this.flags);
    }

    @Override
    public ClassLayout getClassLayout() {
        return this.classLayout;
    }

    public ConstantEntry[] getConstants() {
        if (this.constantEntries == null) {
            return new ConstantEntry[0];
        }
        return this.constantEntries;
    }

    public void setConstantEntries(ConstantEntry[] constantEntries) {
        this.constantEntries = constantEntries;
    }

    public void setClassLayout(ClassLayoutEntry classLayout) {
        this.classLayout = classLayout;
    }

    @Override
    public void setDeclarativeSecurity(DeclSecurityEntry declSecurityEntry) {
        this.declSecurityEntry = declSecurityEntry;
    }

    @Override
    public DeclarativeSecurity getDeclarativeSecurity() {
        return this.declSecurityEntry;
    }

    @Override
    public Property[] getProperties() {
        if (this.properties == null) {
            return new Property[0];
        }
        if (!ByteReader.testFlags(this.internalFlags, (byte)4)) {
            ByteReader.setFlags(this.internalFlags, (byte)4, true);
            Arrays.sort(this.properties);
        }
        return this.properties;
    }

    public void setProperties(PropertyEntry[] properties) {
        this.properties = properties;
        if (this.fields != null) {
            for (PropertyEntry property : properties) {
                property.setParent(this);
            }
            this.properties = properties;
        }
    }

    @Override
    public Event[] getEvents() {
        if (this.events == null) {
            return new Event[0];
        }
        if (!ByteReader.testFlags(this.internalFlags, (byte)8)) {
            ByteReader.setFlags(this.internalFlags, (byte)8, true);
            Arrays.sort(this.events);
        }
        return this.events;
    }

    public void setEvents(Event[] events) {
        this.events = events;
    }

    @Override
    public boolean isExported() {
        return ByteReader.testFlags(this.internalFlags, (byte)16);
    }

    public void setExported(boolean isExported) {
        this.internalFlags = ByteReader.setFlags(this.internalFlags, (byte)16, isExported);
    }

    @Override
    public TypeRef[] getInterfaces() {
        if (this.implementedInterfaces == null || this.implementedInterfaces.size() == 0) {
            return new TypeRef[0];
        }
        Object[] interfaces = new TypeRef[this.implementedInterfaces.size()];
        this.implementedInterfaces.toArray(interfaces);
        Arrays.sort(interfaces);
        return interfaces;
    }

    public boolean addInterface(TypeRef i) {
        if (this.implementedInterfaces == null) {
            this.implementedInterfaces = new ArrayList(4);
        }
        return this.implementedInterfaces.add(i);
    }

    @Override
    public Type[] getEnclosingClasses() {
        if (this.enclosingClasses == null || this.enclosingClasses.size() == 0) {
            return new Type[0];
        }
        Object[] classes = new Type[this.enclosingClasses.size()];
        this.enclosingClasses.toArray(classes);
        Arrays.sort(classes);
        return classes;
    }

    public boolean addNestedClass(TypeDefEntry type) {
        if (this.enclosingClasses == null) {
            this.enclosingClasses = new ArrayList(4);
        }
        return this.enclosingClasses.add(type);
    }

    @Override
    public boolean isNested() {
        return ByteReader.testFlags(this.internalFlags, (byte)32);
    }

    public void setNested(boolean nested) {
        this.internalFlags = ByteReader.setFlags(this.internalFlags, (byte)32, nested);
    }

    public GenericParamEntry[] getGenericParameters() {
        if (this.genericParams == null || this.genericParams.size() == 0) {
            return new GenericParamEntry[0];
        }
        GenericParamEntry[] params = new GenericParamEntry[this.genericParams.size()];
        this.genericParams.toArray(params);
        return params;
    }

    @Override
    public boolean addGenericParam(GenericParamEntry p) {
        if (this.genericParams == null) {
            this.genericParams = new ArrayList(4);
        }
        return this.genericParams.add(p);
    }

    @Override
    public TypeDefEntry getType() {
        return this;
    }

    @Override
    public MethodDefEntry getMethod() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String toExtendedString() {
        StringBuffer buffer = new StringBuffer(128);
        if (this.getDeclarativeSecurity() != null) {
            void var4_9;
            if (this.getDeclarativeSecurity().getAction() != 0) {
                buffer.append("Declarative Security Permission: [SecurityPermission(SecurityAction Code ");
                buffer.append(this.getDeclarativeSecurity().getAction());
                buffer.append(")]\n");
            }
            Permission[] permissionArray = this.getDeclarativeSecurity().getPermissions();
            int n = permissionArray.length;
            boolean bl = false;
            while (var4_9 < n) {
                Permission p = permissionArray[var4_9];
                buffer.append("Declarative Security Permission: [");
                buffer.append(p.toString());
                buffer.append("]\n");
                ++var4_9;
            }
            if (this.getDeclarativeSecurity().getXMLPermissionSet() != null) {
                buffer.append("Declarative Security Permission (XML): ");
                buffer.append(this.getDeclarativeSecurity().getXMLPermissionSet().replaceAll("\n", ""));
                buffer.append("\n");
            }
        }
        buffer.append("TypeDef: ");
        buffer.append(this.getFullQualifiedName());
        if (this.genericParams != null && this.genericParams.size() > 0) {
            buffer.append("<");
            boolean first = true;
            for (Parameter parameter : this.genericParams) {
                if (!first) {
                    buffer.append(", ");
                }
                buffer.append(parameter.getName());
                first = false;
            }
            buffer.append(">");
        }
        if (this.extendz != null) {
            buffer.append(" extends ");
            buffer.append(this.extendz.getFullQualifiedName());
        }
        if (this.implementedInterfaces != null && this.implementedInterfaces.size() > 0) {
            buffer.append(" implements ");
            boolean first = true;
            for (TypeRef typeRef : this.implementedInterfaces) {
                if (!first) {
                    buffer.append(", ");
                }
                buffer.append(typeRef.getFullQualifiedName());
                first = false;
            }
        }
        buffer.append("\n\t(NumberOfFields: ");
        buffer.append(this.fields == null ? 0 : this.fields.length);
        buffer.append(" NumberOfMethods: ");
        buffer.append(this.methods == null ? 0 : this.methods.length);
        buffer.append(String.format(" Flags: 0x%08x)", this.flags));
        return buffer.toString();
    }

    public void linkMethodsToType() {
        if (this.methods != null) {
            for (MethodDefEntry m : this.methods) {
                m.setOwner(this);
            }
        }
    }

    @Override
    public boolean isInheritedFrom(TypeRef type) {
        if (type.getFullQualifiedName().equals(this.getFullQualifiedName())) {
            return true;
        }
        if (this.extendz != null) {
            if (this.extendz.getType() != null) {
                return this.extendz.getType().isInheritedFrom(type);
            }
            if (this.extendz.getFullQualifiedName().equals(type.getFullQualifiedName())) {
                return true;
            }
        }
        for (TypeRef i : this.getInterfaces()) {
            if (!i.getFullQualifiedName().equals(type.getFullQualifiedName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInheritedFrom(String fullQualifiedName) {
        if (fullQualifiedName.equals(this.getFullQualifiedName())) {
            return true;
        }
        if (this.extendz != null) {
            if (this.extendz.getType() != null) {
                return this.extendz.getType().isInheritedFrom(fullQualifiedName);
            }
            if (this.extendz.getFullQualifiedName().equals(fullQualifiedName)) {
                return true;
            }
        }
        for (TypeRef i : this.getInterfaces()) {
            if (!i.getFullQualifiedName().equals(fullQualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return renderer.renderAsReference(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.fields);
        result = 31 * result + (int)(this.flags ^ this.flags >>> 32);
        result = 31 * result + this.internalFlags;
        result = 31 * result + Arrays.hashCode(this.methods);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeDefEntry other = (TypeDefEntry)obj;
        if (this.internalFlags != other.internalFlags) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (!Arrays.equals(this.methods, other.methods)) {
            return false;
        }
        if (!Arrays.equals(this.fields, other.fields)) {
            return false;
        }
        if (!Arrays.equals(this.properties, other.properties)) {
            return false;
        }
        if (!Arrays.equals(this.events, other.events)) {
            return false;
        }
        if (!Arrays.equals(this.constantEntries, other.constantEntries)) {
            return false;
        }
        if (this.classLayout == null ? other.classLayout != null : !this.classLayout.equals(other.classLayout)) {
            return false;
        }
        if (this.extendz == null) {
            if (other.extendz != null) {
                return false;
            }
        } else {
            if (other.extendz == null) {
                return false;
            }
            if (!this.extendz.getFullQualifiedName().equals(other.extendz.getFullQualifiedName())) {
                return false;
            }
        }
        if (this.implementedInterfaces == null) {
            if (other.implementedInterfaces != null) {
                return false;
            }
        } else {
            if (other.implementedInterfaces == null) {
                return false;
            }
            if (this.implementedInterfaces.size() != other.implementedInterfaces.size()) {
                return false;
            }
            for (i = 0; i < this.implementedInterfaces.size(); ++i) {
                if (this.implementedInterfaces.get(i).getFullQualifiedName().equals(other.implementedInterfaces.get(i).getFullQualifiedName())) continue;
                return false;
            }
        }
        if (this.enclosingClasses == null) {
            if (other.enclosingClasses != null) {
                return false;
            }
        } else {
            if (other.enclosingClasses == null) {
                return false;
            }
            if (this.enclosingClasses.size() != other.enclosingClasses.size()) {
                return false;
            }
            for (i = 0; i < this.enclosingClasses.size(); ++i) {
                if (this.enclosingClasses.get(i).getFullQualifiedName().equals(other.enclosingClasses.get(i).getFullQualifiedName())) continue;
                return false;
            }
        }
        if (this.genericParams == null ? other.genericParams != null : !this.genericParams.equals(other.genericParams)) {
            return false;
        }
        return !(this.additionalMethods == null ? other.additionalMethods != null : !this.additionalMethods.equals(other.additionalMethods));
    }

    @Override
    public int compareTo(TypeRef other) {
        if (other == null || other.getType() == null) {
            return Integer.MAX_VALUE;
        }
        return ArrayUtils.compareStrings(other.getFullQualifiedName(), this.getFullQualifiedName());
    }
}

