/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.AbstractAttributable;
import at.pollaknet.api.facile.metamodel.entries.ConstantEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeDefEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasConstant;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasSemantics;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.signature.PropertyEntrySignature;
import at.pollaknet.api.facile.symtab.symbols.Constant;
import at.pollaknet.api.facile.symtab.symbols.Event;
import at.pollaknet.api.facile.symtab.symbols.Field;
import at.pollaknet.api.facile.symtab.symbols.Parameter;
import at.pollaknet.api.facile.symtab.symbols.Property;
import at.pollaknet.api.facile.symtab.symbols.meta.AttributableSymbol;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;

public class PropertyEntry
extends AbstractAttributable
implements IHasConstant,
IHasCustomAttribute,
IHasSemantics,
AttributableSymbol,
Property {
    private int flags;
    private String name;
    private byte[] typeSignature;
    private ConstantEntry constantEntry;
    private PropertyEntrySignature propertySignature;
    private ArrayList<MethodDefEntry> methods;
    private TypeDefEntry parent;

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getTypeSignature() {
        return this.typeSignature;
    }

    public void setTypeSignature(byte[] typeSignature) {
        this.typeSignature = typeSignature;
    }

    @Override
    public void setConstant(ConstantEntry constantEntry) {
        this.constantEntry = constantEntry;
    }

    @Override
    public Constant getConstant() {
        return this.constantEntry;
    }

    public String toString() {
        return String.format("Property: %s (Flags: 0x%x) TypeSignature: %s", this.name, this.flags, this.typeSignature == null ? "[not set]" : ArrayUtils.formatByteArray(this.typeSignature));
    }

    @Override
    public Event getEvent() {
        return null;
    }

    @Override
    public Field getField() {
        return null;
    }

    @Override
    public Parameter getParameter() {
        return null;
    }

    @Override
    public Property getProperty() {
        return this;
    }

    public void addPropertySignature(PropertyEntrySignature propertySignature) {
        this.propertySignature = propertySignature;
    }

    @Override
    public PropertyEntrySignature getPropertySignature() {
        return this.propertySignature;
    }

    @Override
    public boolean addMethod(MethodDefEntry method) {
        if (this.methods == null) {
            this.methods = new ArrayList(4);
        }
        return this.methods.add(method);
    }

    public MethodDefEntry[] getMethods() {
        if (this.methods == null || this.methods.size() == 0) {
            return new MethodDefEntry[0];
        }
        return this.methods.toArray(new MethodDefEntry[this.methods.size()]);
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return null;
    }

    @Override
    public int compareTo(Property o) {
        return ArrayUtils.compareStrings(o.getName(), this.getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.flags;
        result = 31 * result + Arrays.hashCode(this.typeSignature);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyEntry other = (PropertyEntry)obj;
        if (this.constantEntry == null ? other.constantEntry != null : !this.constantEntry.equals(other.constantEntry)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.propertySignature == null ? other.propertySignature != null : !this.propertySignature.equals(other.propertySignature));
    }

    @Override
    public String getFullQualifiedName() {
        if (this.parent != null) {
            return this.parent.getFullQualifiedName() + "." + this.name;
        }
        return this.name;
    }

    public void setParent(TypeDefEntry typeDefEntry) {
        this.parent = typeDefEntry;
    }

    @Override
    public TypeDefEntry getParent() {
        return this.parent;
    }
}

