/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.AbstractAttributable;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.CustomAttributeEntry;
import at.pollaknet.api.facile.metamodel.entries.ExportedTypeEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.INamespaceOwner;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.NamespaceContainer;
import at.pollaknet.api.facile.symtab.symbols.ExportedType;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.aggregation.Namespace;
import at.pollaknet.api.facile.symtab.symbols.aggregation.ResolutionScope;
import at.pollaknet.api.facile.symtab.symbols.scopes.AssemblyRef;
import at.pollaknet.api.facile.symtab.symbols.scopes.Module;
import at.pollaknet.api.facile.symtab.symbols.scopes.ModuleRef;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.Arrays;

public class ModuleEntry
extends AbstractAttributable
implements IHasCustomAttribute,
ResolutionScope,
INamespaceOwner,
Module {
    private String name;
    private int generation;
    private byte[] mvId;
    private byte[] encId;
    private byte[] encBaseId;
    private NamespaceContainer[] namespaces;
    private ExportedTypeEntry[] exportedTypes;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullQualifiedName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    @Override
    public byte[] getMvId() {
        return this.mvId;
    }

    public void setMvId(byte[] mvId) {
        this.mvId = mvId;
    }

    @Override
    public byte[] getEncId() {
        return this.encId;
    }

    public void setEncId(byte[] encId) {
        this.encId = encId;
    }

    @Override
    public byte[] getEncBaseId() {
        return this.encBaseId;
    }

    public void setEncBaseId(byte[] encBaseId) {
        this.encBaseId = encBaseId;
    }

    public String toString() {
        return String.format("Module: %s Generation: %d MvId: %s EncId: %s EncBaseId: %s", this.name, this.generation, ArrayUtils.formatByteArray(this.mvId), this.encId == null ? "[not set]" : ArrayUtils.formatByteArray(this.encId), this.encBaseId == null ? "[not set]" : ArrayUtils.formatByteArray(this.encBaseId));
    }

    public String toExtendedString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getCustomAttributes() != null) {
            for (CustomAttributeEntry customAttributeEntry : this.getCustomAttributes()) {
                buffer.append(customAttributeEntry.toExtendedString());
                buffer.append("\n");
            }
        }
        buffer.append("Module: ");
        buffer.append(this.name);
        buffer.append(" Generation: ");
        buffer.append(this.generation);
        buffer.append(" MvId: ");
        buffer.append(this.mvId == null ? "[not set]" : ArrayUtils.formatByteArray(this.mvId));
        buffer.append(" EncId: ");
        buffer.append(this.encId == null ? "[not set]" : ArrayUtils.formatByteArray(this.encId));
        buffer.append(" EncBaseId: ");
        buffer.append(this.encBaseId == null ? "[not set]" : ArrayUtils.formatByteArray(this.encBaseId));
        buffer.append("\n\tExportedTypes:");
        for (RenderableCilElement renderableCilElement : this.exportedTypes) {
            if (((AbstractAttributable)((Object)renderableCilElement)).getCustomAttributes() != null) {
                for (CustomAttributeEntry c : ((AbstractAttributable)((Object)renderableCilElement)).getCustomAttributes()) {
                    buffer.append(c.toExtendedString());
                    buffer.append("\n\t\t");
                }
            }
            buffer.append("\n\t\t");
            buffer.append(((ExportedTypeEntry)renderableCilElement).toString());
        }
        return buffer.toString();
    }

    @Override
    public AssemblyRef getAssemblyRef() {
        return null;
    }

    @Override
    public Module getModule() {
        return this;
    }

    @Override
    public ModuleRef getModuleRef() {
        return this;
    }

    @Override
    public TypeRef getTypeRef() {
        return null;
    }

    @Override
    public void setNamespaces(NamespaceContainer[] namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public Namespace[] getNamespaces() {
        return this.namespaces;
    }

    @Override
    public boolean isInAssembly() {
        return true;
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public String getShortSystemName() {
        return null;
    }

    public void setExportedTypes(ExportedTypeEntry[] exportedTypes) {
        this.exportedTypes = exportedTypes;
    }

    @Override
    public ExportedType[] getExportedTypes() {
        if (this.exportedTypes == null) {
            return new ExportedType[0];
        }
        return this.exportedTypes;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.mvId);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleEntry other = (ModuleEntry)obj;
        if (!Arrays.equals(this.encBaseId, other.encBaseId)) {
            return false;
        }
        if (!Arrays.equals(this.encId, other.encId)) {
            return false;
        }
        if (!Arrays.equals(this.exportedTypes, other.exportedTypes)) {
            return false;
        }
        if (this.generation != other.generation) {
            return false;
        }
        if (!Arrays.equals(this.mvId, other.mvId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return Arrays.equals(this.namespaces, other.namespaces);
    }

    @Override
    public int compareTo(ModuleRef m) {
        if (m == null || m.getClass() != this.getClass()) {
            return Integer.MAX_VALUE;
        }
        return ArrayUtils.compareStrings(m.getFullQualifiedName(), this.getFullQualifiedName());
    }
}

