/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.code.MethodBody;
import at.pollaknet.api.facile.metamodel.AbstractGenericInstanceContainer;
import at.pollaknet.api.facile.metamodel.entries.CustomAttributeEntry;
import at.pollaknet.api.facile.metamodel.entries.DeclSecurityEntry;
import at.pollaknet.api.facile.metamodel.entries.GenericParamEntry;
import at.pollaknet.api.facile.metamodel.entries.MemberRefEntry;
import at.pollaknet.api.facile.metamodel.entries.ParamEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ICustomAttributeType;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasDeclSecurity;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasSemantics;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IMemberForwarded;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IMethodDefOrRef;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ITypeOrMethodDef;
import at.pollaknet.api.facile.pdb.DebugInformation;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.signature.Permission;
import at.pollaknet.api.facile.symtab.symbols.Event;
import at.pollaknet.api.facile.symtab.symbols.Field;
import at.pollaknet.api.facile.symtab.symbols.Method;
import at.pollaknet.api.facile.symtab.symbols.MethodSignature;
import at.pollaknet.api.facile.symtab.symbols.NativeImplementation;
import at.pollaknet.api.facile.symtab.symbols.Property;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.TypeSpec;
import at.pollaknet.api.facile.symtab.symbols.aggregation.MethodAndFieldParent;
import at.pollaknet.api.facile.symtab.symbols.meta.DeclarativeSecurity;
import at.pollaknet.api.facile.symtab.symbols.scopes.ModuleRef;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Arrays;

public class MethodDefEntry
extends AbstractGenericInstanceContainer
implements IHasCustomAttribute,
IHasDeclSecurity,
ITypeOrMethodDef,
MethodAndFieldParent,
IMethodDefOrRef,
IMemberForwarded,
ICustomAttributeType,
Method {
    private static final GenericParamEntry[] EMPTY = new GenericParamEntry[0];
    private long relativeVirtualAddress = -1L;
    private int implFlags;
    private int flags;
    private String name;
    private byte[] binarySignature;
    private ParamEntry[] params;
    private DeclSecurityEntry declSecurityEntry;
    private Event event;
    private Property property;
    private MethodBody methodBody;
    private NativeImplementation nativeImpl;
    private ArrayList<GenericParamEntry> genericParams = null;
    private DebugInformation debugInformation;
    private MethodSignature methodDefSignature;
    private MethodAndFieldParent owner;
    private int semanticsFlags;

    public long getVirtualAddress() {
        return this.relativeVirtualAddress;
    }

    public void setRelativeVirtualAddress(long virtualAddress) {
        this.relativeVirtualAddress = virtualAddress;
    }

    @Override
    public int getImplFlags() {
        return this.implFlags;
    }

    public void setImplFlags(int implFlags) {
        this.implFlags = implFlags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public byte[] getBinarySignature() {
        return this.binarySignature;
    }

    public void setSignature(byte[] signature) {
        this.binarySignature = signature;
    }

    public ParamEntry[] getParams() {
        return this.params;
    }

    public void setParams(ParamEntry[] params) {
        this.params = params;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public void setDeclarativeSecurity(DeclSecurityEntry declSecurityEntry) {
        this.declSecurityEntry = declSecurityEntry;
    }

    @Override
    public DeclarativeSecurity getDeclarativeSecurity() {
        return this.declSecurityEntry;
    }

    public String toString() {
        return String.format("MethodDef: %s (RVA: 0x%x Flags: 0x%04x ImplFlags 0x%04x) NumberOfParams: %d Signature: %s MethodBody: %s DebugInfo: %s", this.name, this.relativeVirtualAddress, this.flags, this.implFlags, this.params == null ? 0 : this.params.length, this.binarySignature == null ? "[not set]" : ArrayUtils.formatByteArray(this.binarySignature), this.methodBody == null ? "[not set]" : "(" + this.methodBody.getCodeSize() + " bytes)", this.debugInformation == null ? "[not set]" : this.debugInformation.toString());
    }

    public String toExtendedString() {
        StringBuffer buffer = new StringBuffer(128);
        if (this.getDeclarativeSecurity() != null) {
            if (this.getDeclarativeSecurity().getAction() != 0) {
                buffer.append("Declarative Security Permission: [SecurityPermission(SecurityAction Code ");
                buffer.append(this.getDeclarativeSecurity().getAction());
                buffer.append(")]\n");
            }
            for (Permission p : this.getDeclarativeSecurity().getPermissions()) {
                buffer.append("Declarative Security Permission: [");
                buffer.append(p.toString());
                buffer.append("]\n");
            }
            if (this.getDeclarativeSecurity().getXMLPermissionSet() != null) {
                buffer.append("Declarative Security Permission (XML): ");
                buffer.append(this.getDeclarativeSecurity().getXMLPermissionSet().replaceAll("\n", ""));
                buffer.append("\n");
            }
        }
        if (this.getCustomAttributes() != null) {
            for (CustomAttributeEntry c : this.getCustomAttributes()) {
                buffer.append(c.toExtendedString());
                buffer.append("\n");
            }
        }
        buffer.append("MethodDef: ");
        buffer.append(this.name);
        if (this.methodDefSignature == null) {
            buffer.append("()");
        } else {
            buffer.append(this.methodDefSignature.toString());
        }
        buffer.append(String.format(" (Flags: 0x%04x ImplFlags 0x%04x)", this.flags, this.implFlags));
        buffer.append(" MethodBody: ");
        if (this.methodBody == null) {
            buffer.append("[not set]");
        } else {
            buffer.append("(");
            buffer.append(this.methodBody.getCodeSize());
            buffer.append(" bytes, locals: ");
            buffer.append(this.methodBody.getLocalVars() == null ? 0 : this.methodBody.getLocalVars().length);
            buffer.append(")");
        }
        if (this.debugInformation == null) {
            buffer.append(" DebugInfo: [not set]");
        } else {
            buffer.append("\n\tDebugInfo: ");
            buffer.append(this.debugInformation.toString());
        }
        return buffer.toString();
    }

    @Override
    public Event getEventInformation() {
        return this.event;
    }

    @Override
    public Property getPropertyInformation() {
        return this.property;
    }

    @Override
    public boolean hasSemantics() {
        return this.event != null || this.property != null;
    }

    @Override
    public boolean isEventMethod() {
        return this.event != null;
    }

    @Override
    public boolean isPropertyMethod() {
        return this.property != null;
    }

    public void setSemantics(IHasSemantics semantics) {
        this.event = semantics.getEvent();
        this.property = semantics.getProperty();
        semantics.addMethod(this);
    }

    public void setMethodBody(MethodBody methodBody) {
        this.methodBody = methodBody;
    }

    @Override
    public MethodBody getMethodBody() {
        return this.methodBody;
    }

    @Override
    public NativeImplementation getNativeImplementation() {
        return this.nativeImpl;
    }

    @Override
    public void setNativeImplementation(NativeImplementation nativeImpl) {
        this.nativeImpl = nativeImpl;
    }

    public GenericParamEntry[] getGenericParameters() {
        if (this.genericParams == null || this.genericParams.size() == 0) {
            return EMPTY;
        }
        GenericParamEntry[] params = new GenericParamEntry[this.genericParams.size()];
        this.genericParams.toArray(params);
        return params;
    }

    @Override
    public boolean addGenericParam(GenericParamEntry p) {
        if (this.genericParams == null) {
            this.genericParams = new ArrayList(4);
        }
        return this.genericParams.add(p);
    }

    public void setDebugInformation(DebugInformation lineNumberInfo) {
        this.debugInformation = lineNumberInfo;
    }

    @Override
    public DebugInformation getDebugInformation() {
        return this.debugInformation;
    }

    public void setMethodSignature(MethodSignature methodDefSignature) {
        this.methodDefSignature = methodDefSignature;
    }

    @Override
    public MethodSignature getMethodSignature() {
        return this.methodDefSignature;
    }

    public void setNumberOfParameters(int parameterCount) {
        if (this.params != null && this.params.length > parameterCount && parameterCount >= 0) {
            ParamEntry[] truncatedParams = new ParamEntry[parameterCount];
            System.arraycopy(this.params, 0, truncatedParams, 0, parameterCount);
            this.params = truncatedParams;
        }
    }

    @Override
    public MethodDefEntry getMethod() {
        return this;
    }

    @Override
    public Type getType() {
        return null;
    }

    @Override
    public MemberRefEntry getMemberRef() {
        return null;
    }

    @Override
    public ModuleRef getModuleRef() {
        return null;
    }

    @Override
    public TypeRef getTypeRef() {
        return null;
    }

    @Override
    public Field getField() {
        return null;
    }

    @Override
    public MethodAndFieldParent getOwner() {
        return this.owner;
    }

    @Override
    public TypeSpec getTypeSpec() {
        return null;
    }

    public void setOwner(MethodAndFieldParent owner) {
        this.owner = owner;
    }

    public void setSemanticsFlags(int semantics) {
        this.semanticsFlags = semantics;
    }

    @Override
    public int getSemanticsFlags() {
        return this.semanticsFlags;
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return renderer.renderAsReference(this);
    }

    @Override
    public int compareTo(Method o) {
        return ArrayUtils.compareStrings(o.getName(), this.getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.flags;
        result = 31 * result + this.implFlags;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodDefEntry other = (MethodDefEntry)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.implFlags != other.implFlags) {
            return false;
        }
        if (this.semanticsFlags != other.semanticsFlags) {
            return false;
        }
        if (this.methodDefSignature == null ? other.methodDefSignature != null : !this.methodDefSignature.equals(other.methodDefSignature)) {
            return false;
        }
        if (this.methodBody == null ? other.methodBody != null : !this.methodBody.equals(other.methodBody)) {
            return false;
        }
        if (this.event == null ? other.event != null : !this.event.equals(other.event)) {
            return false;
        }
        if (this.declSecurityEntry == null ? other.declSecurityEntry != null : !this.declSecurityEntry.equals(other.declSecurityEntry)) {
            return false;
        }
        if (this.genericParams == null ? other.genericParams != null : !this.genericParams.equals(other.genericParams)) {
            return false;
        }
        if (this.nativeImpl == null ? other.nativeImpl != null : !this.nativeImpl.equals(other.nativeImpl)) {
            return false;
        }
        if (!Arrays.equals(this.params, other.params)) {
            return false;
        }
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }
}

