/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.AbstractAttributable;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.TypeDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeSpecEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ITypeDefOrRef;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ITypeOrMethodDef;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.symbols.GenericParameter;
import at.pollaknet.api.facile.symtab.symbols.MarshalSignature;
import at.pollaknet.api.facile.symtab.symbols.Method;
import at.pollaknet.api.facile.symtab.symbols.Parameter;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.ArrayList;
import java.util.List;

public class GenericParamEntry
extends AbstractAttributable
implements RenderableCilElement,
Parameter,
IHasCustomAttribute,
GenericParameter {
    private int number;
    private int flags;
    private ITypeOrMethodDef owner;
    private String name;
    private List<ITypeDefOrRef> typeConstraints = new ArrayList<ITypeDefOrRef>();
    private ITypeOrMethodDef deprecatedMethodOrTypeConstraint = null;

    @Override
    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public ITypeOrMethodDef getOwner() {
        return this.owner;
    }

    public void setOwner(ITypeOrMethodDef owner) {
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return String.format("GenericParam: %s (Number: %d Flags: 0x%04x) Owner: %s", this.name, this.number, this.flags, this.owner == null ? "[DELETED]" : this.owner.getName());
    }

    public void addConstraint(ITypeDefOrRef constraint) {
        if (constraint.getName() == null) {
            assert (constraint.getTypeSpec() != null);
            constraint.setName(this.getName());
        } else {
            TypeSpecEntry typeSpec = constraint.getTypeSpec();
            if (typeSpec != null) {
                TypeRefEntry[] typeRef = typeSpec.getGenericArguments();
                if (typeRef != null && this.number < typeRef.length && typeRef[this.number].getName() == null) {
                    typeRef[this.number].setName(this.getName());
                }
            } else {
                GenericParamEntry[] genericParams;
                TypeDefEntry type = constraint.getType();
                if (type != null && this.number < (genericParams = type.getGenericParameters()).length && genericParams[this.number].getName() == null) {
                    genericParams[this.number].setName(this.getName());
                }
            }
        }
        this.typeConstraints.add(constraint);
    }

    @Override
    public TypeRef getTypeRef() {
        return null;
    }

    @Override
    public TypeRef[] getConstraints() {
        if (this.typeConstraints.size() == 0) {
            return EMPTY;
        }
        TypeRef[] result = new TypeRef[this.typeConstraints.size()];
        int i = 0;
        for (ITypeDefOrRef ref : this.typeConstraints) {
            result[i++] = ref.getTypeRef();
        }
        return result;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public MarshalSignature getMarshalSignature() {
        return null;
    }

    @Override
    public byte[] getBinaryMarshalTypeSignature() {
        return null;
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return null;
    }

    public void setMethod(ITypeOrMethodDef typeOrMethodDef) {
        this.deprecatedMethodOrTypeConstraint = typeOrMethodDef;
    }

    @Override
    public Method getDeprecatedMethodConstraint() {
        return this.deprecatedMethodOrTypeConstraint.getMethod();
    }

    @Override
    public Type getDeprecatedTypeConstraint() {
        return this.deprecatedMethodOrTypeConstraint.getType();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.flags;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.number;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericParamEntry other = (GenericParamEntry)obj;
        if (this.deprecatedMethodOrTypeConstraint == null ? other.deprecatedMethodOrTypeConstraint != null : !this.deprecatedMethodOrTypeConstraint.equals(other.deprecatedMethodOrTypeConstraint)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.number != other.number) {
            return false;
        }
        if (this.typeConstraints.size() != other.typeConstraints.size()) {
            return false;
        }
        return this.typeConstraints.equals(other.typeConstraints);
    }

    @Override
    public int compareTo(Parameter p) {
        if (p == null || p.getClass() != this.getClass()) {
            return Integer.MAX_VALUE;
        }
        return ArrayUtils.compareStrings(p.getName(), this.getName());
    }
}

