/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.AbstractAttributable;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasSemantics;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ITypeDefOrRef;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.symbols.Event;
import at.pollaknet.api.facile.symtab.symbols.Property;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.ArrayList;

public class EventEntry
extends AbstractAttributable
implements IHasCustomAttribute,
IHasSemantics,
Event {
    private int eventFlags;
    private String name;
    private ITypeDefOrRef eventType;
    private ArrayList<MethodDefEntry> methods;

    @Override
    public int getFlags() {
        return this.eventFlags;
    }

    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEventType(ITypeDefOrRef eventType) {
        this.eventType = eventType;
    }

    public String toString() {
        return String.format("Event: %s (Flags: 0x%04x Type: %s)", this.name, this.eventFlags, this.eventType.getFullQualifiedName());
    }

    @Override
    public TypeRef getTypeRef() {
        if (this.eventType == null) {
            return null;
        }
        return this.eventType.getTypeRef();
    }

    @Override
    public Event getEvent() {
        return this;
    }

    @Override
    public Property getProperty() {
        return null;
    }

    @Override
    public boolean addMethod(MethodDefEntry method) {
        if (this.methods == null) {
            this.methods = new ArrayList(4);
        }
        return this.methods.add(method);
    }

    public MethodDefEntry[] getMethods() {
        if (this.methods == null || this.methods.size() == 0) {
            return new MethodDefEntry[0];
        }
        return this.methods.toArray(new MethodDefEntry[this.methods.size()]);
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return null;
    }

    @Override
    public int compareTo(Event o) {
        return ArrayUtils.compareStrings(o.getName(), this.name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.eventFlags;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventEntry other = (EventEntry)obj;
        if (this.eventFlags != other.eventFlags) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.eventType == null ? other.eventType != null : !this.eventType.equals(other.eventType));
    }
}

