/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.HasBackupBlobIndex;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.aggregation.ICustomAttributeType;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.symbols.Instance;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.aggregation.MethodAndFieldParent;
import at.pollaknet.api.facile.symtab.symbols.meta.CustomAttribute;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import at.pollaknet.api.facile.symtab.symbols.scopes.Module;
import at.pollaknet.api.facile.util.ArrayUtils;
import at.pollaknet.api.facile.util.Pair;
import java.util.Arrays;

public class CustomAttributeEntry
implements RenderableCilElement,
CustomAttribute,
HasBackupBlobIndex {
    private IHasCustomAttribute owner;
    private ICustomAttributeType customAttributeType;
    private byte[] value;
    private Instance[] fixedArguments;
    private Pair<String, Instance>[] namedFields;
    private Pair<String, Instance>[] namedProperties;
    private int blobIndex;

    public IHasCustomAttribute getOwner() {
        return this.owner;
    }

    public void setOwner(IHasCustomAttribute parent) {
        this.owner = parent;
    }

    public void setCustomAttributeType(ICustomAttributeType customAttributeType) {
        this.customAttributeType = customAttributeType;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setBinaryBlobIndex(int blobIndex) {
        this.blobIndex = blobIndex;
    }

    @Override
    public int getBinaryBlobIndex() {
        return this.blobIndex;
    }

    public String toString() {
        return String.format("CustomAttribute: %s Type: %s Value: %s", this.owner == null ? "[DELETED]" : this.owner.getName(), this.customAttributeType.getName(), this.value == null ? "[not set]" : ArrayUtils.formatByteArray(this.value));
    }

    public ICustomAttributeType getCustomAttributeType() {
        return this.customAttributeType;
    }

    public void setFixedArguments(Instance[] fixedArguments) {
        this.fixedArguments = fixedArguments;
    }

    public void setNamedFields(Pair<String, Instance>[] namedFields) {
        this.namedFields = namedFields;
    }

    public void setNamedProperties(Pair<String, Instance>[] namedProperties) {
        this.namedProperties = namedProperties;
    }

    @Override
    public Instance[] getFixedArguments() {
        if (this.fixedArguments == null) {
            return new Instance[0];
        }
        return this.fixedArguments;
    }

    @Override
    public Pair<String, Instance>[] getNamedFields() {
        if (this.namedFields == null) {
            return new Pair[0];
        }
        return this.namedFields;
    }

    @Override
    public Pair<String, Instance>[] getNamedProperties() {
        if (this.namedProperties == null) {
            return new Pair[0];
        }
        return this.namedProperties;
    }

    public String toExtendedString() {
        StringBuffer buffer = new StringBuffer();
        boolean hasEntries = false;
        MethodAndFieldParent parent = null;
        if (this.customAttributeType == null) {
            buffer.append("// INVALID ");
        }
        if (this.owner == null) {
            if (buffer.length() == 0) {
                buffer.append("// DELETED CustomAttribute: [");
            } else {
                buffer.append("& DELETED CustomAttribute: [");
            }
        } else {
            buffer.append("CustomAttribute: [");
            if (this.owner instanceof Assembly) {
                buffer.append("assembly: ");
            } else if (this.owner instanceof Module) {
                buffer.append("module: ");
            }
        }
        if (this.customAttributeType != null) {
            if (this.customAttributeType.getMethod() != null) {
                parent = this.customAttributeType.getMethod().getOwner();
            } else {
                assert (this.customAttributeType.getMemberRef() != null);
                parent = this.customAttributeType.getMemberRef().getOwner();
            }
        }
        if (parent != null) {
            assert (parent.getTypeRef().getFullQualifiedName() != null);
            buffer.append(parent.getTypeRef().getFullQualifiedName());
        }
        if (this.fixedArguments == null && this.namedFields == null && this.namedProperties == null) {
            buffer.append("]");
        } else {
            buffer.append("(");
            if (this.fixedArguments != null) {
                for (Instance instance : this.fixedArguments) {
                    CustomAttributeEntry.formatFixedAttribute(buffer, instance, hasEntries);
                    hasEntries = true;
                }
            }
            if (this.namedFields != null) {
                for (Pair<String, Instance> pair : this.namedFields) {
                    CustomAttributeEntry.formatNamedProperty(buffer, pair, hasEntries);
                    hasEntries = true;
                }
            }
            if (this.namedProperties != null) {
                for (Pair<String, Instance> pair : this.namedProperties) {
                    CustomAttributeEntry.formatNamedProperty(buffer, pair, hasEntries);
                    hasEntries = true;
                }
            }
            buffer.append(")]");
        }
        return buffer.toString();
    }

    private static void formatFixedAttribute(StringBuffer buffer, Instance instance, boolean hasEntries) {
        if (hasEntries) {
            buffer.append(", ");
        }
        buffer.append(instance);
    }

    private static void formatNamedProperty(StringBuffer buffer, Pair<String, Instance> pair, boolean hasEntries) {
        if (hasEntries) {
            buffer.append(", ");
        }
        buffer.append((String)pair.key);
        buffer.append(" = ");
        buffer.append(pair.value);
    }

    @Override
    public TypeRef getTypeRef() {
        if (this.customAttributeType.getMethod() != null) {
            return this.customAttributeType.getMethod().getOwner().getTypeRef();
        }
        assert (this.customAttributeType.getMemberRef() != null);
        return this.customAttributeType.getMemberRef().getOwner().getTypeRef();
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return null;
    }

    @Override
    public int hashCode() {
        return 31 * (31 + this.blobIndex) + Arrays.hashCode(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomAttributeEntry other = (CustomAttributeEntry)obj;
        if (this.customAttributeType == null ? other.customAttributeType != null : !this.customAttributeType.equals(other.customAttributeType)) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }

    @Override
    public int compareTo(CustomAttribute a) {
        return ArrayUtils.compareStrings(a.getTypeRef().getFullQualifiedName(), this.getTypeRef().getFullQualifiedName());
    }
}

