/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.AbstractAttributable;
import at.pollaknet.api.facile.metamodel.entries.CustomAttributeEntry;
import at.pollaknet.api.facile.metamodel.entries.ModuleRefEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.INamespaceOwner;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.NamespaceContainer;
import at.pollaknet.api.facile.symtab.symbols.ExportedType;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.aggregation.ResolutionScope;
import at.pollaknet.api.facile.symtab.symbols.meta.Implementation;
import at.pollaknet.api.facile.symtab.symbols.scopes.AssemblyRef;
import at.pollaknet.api.facile.symtab.symbols.scopes.FileRef;
import at.pollaknet.api.facile.symtab.symbols.scopes.Module;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.Arrays;

public class AssemblyRefEntry
extends AbstractAttributable
implements IHasCustomAttribute,
Implementation,
ResolutionScope,
AssemblyRef,
INamespaceOwner {
    private int majorVersion;
    private int minorVersion;
    private int buildNumber;
    private int revisionNumber;
    private long flags;
    private byte[] publicKey;
    private String name;
    private String culture;
    private byte[] hashValue;
    private ModuleRefEntry moduleRefEntry;

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(int revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    @Override
    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCulture() {
        return this.culture;
    }

    public void setCulture(String culture) {
        this.culture = culture;
    }

    @Override
    public byte[] getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(byte[] hashValue) {
        this.hashValue = hashValue;
    }

    public String toString() {
        return String.format("AssemblyRef: %s %s Version: %d.%d Build: %d Revision: %d (Flags: 0x%08x) HashValue: %s PublicKey: %s", this.name, this.culture == null ? "[neutral]" : this.culture, this.majorVersion, this.minorVersion, this.buildNumber, this.revisionNumber, this.flags, this.hashValue == null ? "[not set]" : ArrayUtils.formatByteArray(this.hashValue), this.publicKey == null ? "[not set]" : ArrayUtils.formatByteArray(this.publicKey));
    }

    public String toExtendedString() {
        StringBuffer buffer = new StringBuffer(2048);
        if (this.getCustomAttributes() != null) {
            for (CustomAttributeEntry c : this.getCustomAttributes()) {
                buffer.append(c.toExtendedString());
                buffer.append("\n");
            }
        }
        this.getModuleRef();
        buffer.append(this.toString());
        buffer.append("\n");
        buffer.append(this.moduleRefEntry.toExtendedString());
        return buffer.toString();
    }

    @Override
    public AssemblyRef getAssemblyRef() {
        return this;
    }

    @Override
    public Module getModule() {
        return null;
    }

    @Override
    public ModuleRefEntry getModuleRef() {
        if (this.moduleRefEntry == null) {
            this.moduleRefEntry = new ModuleRefEntry();
            if (this.name != null && this.name.equals("mscorlib")) {
                this.moduleRefEntry.setName("CommonLanguageRuntimeLibrary");
            } else {
                this.moduleRefEntry.setName("Stub [Module]");
            }
        }
        return this.moduleRefEntry;
    }

    @Override
    public TypeRef getTypeRef() {
        return null;
    }

    @Override
    public FileRef getFileRef() {
        return null;
    }

    @Override
    public void setNamespaces(NamespaceContainer[] namespaces) {
        this.getModuleRef().setNamespaces(namespaces);
    }

    @Override
    public boolean isInAssembly() {
        return false;
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return null;
    }

    @Override
    public String getFullQualifiedName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public String getShortSystemName() {
        return null;
    }

    @Override
    public ExportedType getExportedType() {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.flags ^ this.flags >>> 32);
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + this.revisionNumber;
        result = 31 * result + this.buildNumber;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssemblyRefEntry other = (AssemblyRefEntry)obj;
        if (this.buildNumber != other.buildNumber) {
            return false;
        }
        if (this.culture == null ? other.culture != null : !this.culture.equals(other.culture)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (!Arrays.equals(this.hashValue, other.hashValue)) {
            return false;
        }
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        if (this.moduleRefEntry != other.moduleRefEntry) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.publicKey, other.publicKey)) {
            return false;
        }
        return this.revisionNumber == other.revisionNumber;
    }
}

