/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.metamodel.entries;

import at.pollaknet.api.facile.metamodel.AbstractAttributable;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.AssemblyOsEntry;
import at.pollaknet.api.facile.metamodel.entries.AssemblyProcessorEntry;
import at.pollaknet.api.facile.metamodel.entries.AssemblyRefEntry;
import at.pollaknet.api.facile.metamodel.entries.AssemblyRefOsEntry;
import at.pollaknet.api.facile.metamodel.entries.AssemblyRefProcessorEntry;
import at.pollaknet.api.facile.metamodel.entries.CustomAttributeEntry;
import at.pollaknet.api.facile.metamodel.entries.DeclSecurityEntry;
import at.pollaknet.api.facile.metamodel.entries.FieldEntry;
import at.pollaknet.api.facile.metamodel.entries.FileEntry;
import at.pollaknet.api.facile.metamodel.entries.ManifestResourceEntry;
import at.pollaknet.api.facile.metamodel.entries.MethodDefEntry;
import at.pollaknet.api.facile.metamodel.entries.ModuleEntry;
import at.pollaknet.api.facile.metamodel.entries.ModuleRefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeDefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.entries.TypeSpecEntry;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasCustomAttribute;
import at.pollaknet.api.facile.metamodel.entries.aggregation.IHasDeclSecurity;
import at.pollaknet.api.facile.renderer.LanguageRenderer;
import at.pollaknet.api.facile.symtab.signature.Permission;
import at.pollaknet.api.facile.symtab.symbols.FullQualifiableSymbol;
import at.pollaknet.api.facile.symtab.symbols.Type;
import at.pollaknet.api.facile.symtab.symbols.TypeRef;
import at.pollaknet.api.facile.symtab.symbols.TypeSpec;
import at.pollaknet.api.facile.symtab.symbols.meta.ManifestResource;
import at.pollaknet.api.facile.symtab.symbols.scopes.Assembly;
import at.pollaknet.api.facile.util.ArrayUtils;
import java.util.Arrays;

public class AssemblyEntry
extends AbstractAttributable
implements IHasCustomAttribute,
IHasDeclSecurity,
Assembly {
    private long hasAlgorithmId;
    private int majorVersion;
    private int minorVersion;
    private int buildNumber;
    private int revisionNumber;
    private long flags;
    private byte[] publicKey;
    private String name;
    private String culture;
    private DeclSecurityEntry declSecurityEntry;
    private AssemblyOsEntry[] assemblyOs;
    private AssemblyProcessorEntry[] assemblyProcessor;
    private AssemblyRefEntry[] assemblyRefs;
    private AssemblyRefOsEntry[] assemblyRefOs;
    private AssemblyRefProcessorEntry[] assemblyRefProcessor;
    private ModuleEntry module;
    private ModuleRefEntry[] moduleRefs;
    private ManifestResourceEntry[] manifestResources;
    private TypeDefEntry[] types;
    private TypeRefEntry[] typeRefs;
    private TypeSpecEntry[] typeSpecs;
    private TypeSpecEntry[] embeddedTypeSpecs;
    private FileEntry[] fileRefs;
    private String filename;

    @Override
    public long getHasAlgorithmId() {
        return this.hasAlgorithmId;
    }

    public void setHasAlgorithmId(long hasAlgorithmId) {
        this.hasAlgorithmId = hasAlgorithmId;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(int revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    @Override
    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCulture() {
        return this.culture;
    }

    public void setCulture(String culture) {
        this.culture = culture;
    }

    @Override
    public String toString() {
        return String.format("Assembly: %s %s Version: %d.%d Build: %d Revision: %d (Flags: 0x%08x HashAlgoID: 0x%x) PublicKey: %s", this.name, this.culture == null ? "[neutral]" : this.culture, this.majorVersion, this.minorVersion, this.buildNumber, this.revisionNumber, this.flags, this.hasAlgorithmId, this.publicKey == null ? "[not set]" : ArrayUtils.formatByteArray(this.publicKey));
    }

    @Override
    public void setDeclarativeSecurity(DeclSecurityEntry declSecurityEntry) {
        this.declSecurityEntry = declSecurityEntry;
    }

    @Override
    public DeclSecurityEntry getDeclarativeSecurity() {
        return this.declSecurityEntry;
    }

    @Override
    public String toExtendedString() {
        StringBuffer buffer = new StringBuffer(2048);
        if (this.getDeclarativeSecurity() != null) {
            if (this.getDeclarativeSecurity().getAction() != 0) {
                buffer.append("Declarative Security Permission: [assembly: SecurityPermission(SecurityAction Code ");
                buffer.append(this.getDeclarativeSecurity().getAction());
                buffer.append(")]\n");
            }
            for (Permission permission : this.getDeclarativeSecurity().getPermissions()) {
                buffer.append("Declarative Security Permission: [assembly: ");
                buffer.append(permission.toString());
                buffer.append("]\n");
            }
            if (this.getDeclarativeSecurity().getXMLPermissionSet() != null) {
                buffer.append("Declarative Security Permission (XML): ");
                buffer.append(this.getDeclarativeSecurity().getXMLPermissionSet().replaceAll("\n", ""));
                buffer.append("\n");
            }
        }
        buffer.append(this.toString());
        buffer.append("\n");
        buffer.append(this.module.toExtendedString());
        buffer.append("\nTypes:");
        for (FullQualifiableSymbol fullQualifiableSymbol : this.types) {
            buffer.append("\n\t");
            if (((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes() != null) {
                for (CustomAttributeEntry customAttributeEntry : ((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes()) {
                    buffer.append(customAttributeEntry.toExtendedString());
                    buffer.append("\n\t");
                }
            }
            buffer.append(((TypeDefEntry)fullQualifiableSymbol).toExtendedString().replaceAll("\n", "\n\t"));
            if (((TypeDefEntry)fullQualifiableSymbol).getFields() != null) {
                for (RenderableCilElement renderableCilElement : ((TypeDefEntry)fullQualifiableSymbol).getFields()) {
                    if (renderableCilElement != null) {
                        buffer.append("\n\t\t");
                        buffer.append(((FieldEntry)renderableCilElement).toExtendedString().replaceAll("\n", "\n\t\t"));
                        continue;
                    }
                    buffer.append("\n\t\t[no field found]");
                }
            }
            if (((TypeDefEntry)fullQualifiableSymbol).getMethods() == null) continue;
            for (RenderableCilElement renderableCilElement : ((TypeDefEntry)fullQualifiableSymbol).getMethods()) {
                if (renderableCilElement != null) {
                    buffer.append("\n\t\t");
                    buffer.append(((MethodDefEntry)renderableCilElement).toExtendedString().replaceAll("\n", "\n\t\t"));
                    continue;
                }
                buffer.append("\n\t\t[no method found]");
            }
        }
        buffer.append("\n\tTypeRefs:");
        for (FullQualifiableSymbol fullQualifiableSymbol : this.typeRefs) {
            if (((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes() != null) {
                for (RenderableCilElement renderableCilElement : ((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes()) {
                    buffer.append(((CustomAttributeEntry)renderableCilElement).toExtendedString());
                    buffer.append("\n\t\t");
                }
            }
            buffer.append("\n\t\t");
            buffer.append(((TypeRefEntry)fullQualifiableSymbol).toString().replaceAll("\n", "\n\t\t"));
        }
        buffer.append("\n\tTypeSpecs:");
        for (FullQualifiableSymbol fullQualifiableSymbol : this.typeSpecs) {
            if (((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes() != null) {
                for (RenderableCilElement renderableCilElement : ((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes()) {
                    buffer.append(((CustomAttributeEntry)renderableCilElement).toExtendedString());
                    buffer.append("\n\t\t");
                }
            }
            buffer.append("\n\t\t");
            buffer.append(((TypeSpecEntry)fullQualifiableSymbol).toString().replaceAll("\n", "\n\t\t"));
        }
        buffer.append("\n\tTypeSpecs (embedded in signatures):");
        for (FullQualifiableSymbol fullQualifiableSymbol : this.embeddedTypeSpecs) {
            if (((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes() != null) {
                for (RenderableCilElement renderableCilElement : ((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes()) {
                    buffer.append(((CustomAttributeEntry)renderableCilElement).toExtendedString());
                    buffer.append("\n\t\t");
                }
            }
            buffer.append("\n\t\t");
            buffer.append(((TypeSpecEntry)fullQualifiableSymbol).toString().replaceAll("\n", "\n\t\t"));
        }
        buffer.append("\n\tAssemblyRefs:");
        for (FullQualifiableSymbol fullQualifiableSymbol : this.assemblyRefs) {
            if (((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes() != null) {
                for (RenderableCilElement renderableCilElement : ((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes()) {
                    buffer.append(((CustomAttributeEntry)renderableCilElement).toExtendedString());
                    buffer.append("\n\t\t");
                }
            }
            buffer.append("\n\t\t");
            buffer.append(((AssemblyRefEntry)fullQualifiableSymbol).toExtendedString().replaceAll("\n", "\n\t\t"));
        }
        buffer.append("\n\tModuleRefs:");
        for (FullQualifiableSymbol fullQualifiableSymbol : this.moduleRefs) {
            if (((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes() != null) {
                for (RenderableCilElement renderableCilElement : ((AbstractAttributable)((Object)fullQualifiableSymbol)).getCustomAttributes()) {
                    buffer.append(((CustomAttributeEntry)renderableCilElement).toExtendedString());
                    buffer.append("\n\t\t");
                }
            }
            buffer.append("\n\t\t");
            buffer.append(((ModuleRefEntry)fullQualifiableSymbol).toExtendedString().replaceAll("\n", "\n\t\t"));
        }
        buffer.append("\n\tManifestResources:");
        for (ManifestResourceEntry manifestResourceEntry : this.manifestResources) {
            if (manifestResourceEntry.getCustomAttributes() != null) {
                for (RenderableCilElement renderableCilElement : manifestResourceEntry.getCustomAttributes()) {
                    buffer.append(((CustomAttributeEntry)renderableCilElement).toExtendedString());
                    buffer.append("\n\t\t");
                }
            }
            buffer.append("\n\t\t");
            buffer.append(manifestResourceEntry.toString());
        }
        buffer.append("\n\tFileRefs:");
        for (FileEntry fileEntry : this.fileRefs) {
            if (fileEntry.getCustomAttributes() != null) {
                for (RenderableCilElement renderableCilElement : fileEntry.getCustomAttributes()) {
                    buffer.append(((CustomAttributeEntry)renderableCilElement).toExtendedString());
                    buffer.append("\n\t\t");
                }
            }
            buffer.append("\n\t\t");
            buffer.append(fileEntry.toString());
        }
        return buffer.toString();
    }

    @Override
    public Type[] getAllTypes() {
        return this.types;
    }

    @Override
    public TypeRef[] getAllTypeRefs() {
        return this.typeRefs;
    }

    @Override
    public TypeSpec[] getAllTypeSpecs() {
        return this.typeSpecs;
    }

    @Override
    public TypeSpec[] getEmbeddedTypeSpecs() {
        return this.embeddedTypeSpecs;
    }

    @Override
    public ModuleEntry getModule() {
        return this.module;
    }

    @Override
    public ManifestResource[] getManifestResources() {
        return this.manifestResources;
    }

    public AssemblyOsEntry[] getAssemblyOS() {
        return this.assemblyOs;
    }

    public void setAssemblyOs(AssemblyOsEntry[] assemblyOs) {
        this.assemblyOs = assemblyOs;
    }

    public AssemblyProcessorEntry[] getAssemblyProcessors() {
        return this.assemblyProcessor;
    }

    public void setAssemblyProcessor(AssemblyProcessorEntry[] assemblyProcessor) {
        this.assemblyProcessor = assemblyProcessor;
    }

    public AssemblyRefEntry[] getAssemblyRefs() {
        return this.assemblyRefs;
    }

    public void setAssemblyRefs(AssemblyRefEntry[] assemblyRefs) {
        this.assemblyRefs = assemblyRefs;
    }

    public AssemblyRefOsEntry[] getAssemblyOSRefs() {
        return this.assemblyRefOs;
    }

    public void setAssemblyRefOs(AssemblyRefOsEntry[] assemblyRefOs) {
        this.assemblyRefOs = assemblyRefOs;
    }

    public AssemblyRefProcessorEntry[] getAssemblyProcessorRefs() {
        return this.assemblyRefProcessor;
    }

    public void setAssemblyRefProcessor(AssemblyRefProcessorEntry[] assemblyRefProcessor) {
        this.assemblyRefProcessor = assemblyRefProcessor;
    }

    public ModuleRefEntry[] getModuleRefs() {
        return this.moduleRefs;
    }

    public FileEntry[] getFileRefs() {
        return this.fileRefs;
    }

    public void setModuleRefs(ModuleRefEntry[] moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public void setModule(ModuleEntry module) {
        this.module = module;
    }

    public void setManifestResources(ManifestResourceEntry[] manifestResources) {
        this.manifestResources = manifestResources;
    }

    public void setTypes(TypeDefEntry[] types) {
        this.types = types;
    }

    public void setTypeRefs(TypeRefEntry[] typeRefs) {
        this.typeRefs = typeRefs;
    }

    public void setTypeSpecs(TypeSpecEntry[] typeSpecs) {
        this.typeSpecs = typeSpecs;
    }

    public void setFileRefs(FileEntry[] fileRefs) {
        this.fileRefs = fileRefs;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String render(LanguageRenderer renderer) {
        return renderer.render(this);
    }

    @Override
    public String renderAsReference(LanguageRenderer renderer) {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.buildNumber;
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.hashCode(this.publicKey);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssemblyEntry other = (AssemblyEntry)obj;
        if (this.buildNumber != other.buildNumber) {
            return false;
        }
        if (this.culture == null ? other.culture != null : !this.culture.equals(other.culture)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.hasAlgorithmId != other.hasAlgorithmId) {
            return false;
        }
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        if (this.minorVersion != other.minorVersion) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.revisionNumber != other.revisionNumber) {
            return false;
        }
        if (!Arrays.equals(this.publicKey, other.publicKey)) {
            return false;
        }
        if (!Arrays.equals(this.manifestResources, other.manifestResources)) {
            return false;
        }
        if (this.declSecurityEntry == null ? other.declSecurityEntry != null : !this.declSecurityEntry.equals(other.declSecurityEntry)) {
            return false;
        }
        if (!Arrays.equals(this.fileRefs, other.fileRefs)) {
            return false;
        }
        if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
            return false;
        }
        return Arrays.equals(this.moduleRefs, other.moduleRefs);
    }

    public void setEmbeddedTypeSpecs(TypeSpecEntry[] signatureEmbeddedTypeSpecs) {
        this.embeddedTypeSpecs = signatureEmbeddedTypeSpecs;
    }
}

