/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.coffpe;

import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ByteReader;

public class PESectionHeader
implements IDataHeader,
Comparable<PESectionHeader> {
    public static final int HEADER_SIZE = 40;
    public static final long CHARACTERISTICS_FLAGS_SCALE_TLS_INDEX = 16L;
    public static final long CHARACTERISTICS_FLAGS_CONTAINS_EXECUTABLE_CODE = 32L;
    public static final long CHARACTERISTICS_FLAGS_CONTAINS_INITIALIZED_DATA = 64L;
    public static final long CHARACTERISTICS_FLAGS_CONTAINS_UNINITIALIZED_DATA = 128L;
    public static final long CHARACTERISTICS_FLAGS_HAS_COMMENTS = 512L;
    public static final long CHARACTERISTICS_FLAGS_RESET_SPECULATIVE_EXCEPTIONS = 16384L;
    public static final long CHARACTERISTICS_FLAGS_HAS_EXTENDED_RELOCATIONS = 0x1000000L;
    public static final long CHARACTERISTICS_FLAGS_MEMORY_DISCARDABLE = 0x2000000L;
    public static final long CHARACTERISTICS_FLAGS_MEMORY_DONT_CACHE = 0x4000000L;
    public static final long CHARACTERISTICS_FLAGS_MEMORY_DONT_PAGE = 0x8000000L;
    public static final long CHARACTERISTICS_FLAGS_MEMORY_SHARED = 0x10000000L;
    public static final long CHARACTERISTICS_FLAGS_MEMORY_EXECUTE = 0x20000000L;
    public static final long CHARACTERISTICS_FLAGS_MEMORY_READ = 0x40000000L;
    public static final long CHARACTERISTICS_FLAGS_MEMORY_WRITE = Integer.MIN_VALUE;
    private String sectionName;
    private long virtualSize;
    private long relativeVirtualAddress;
    private long sizeOfRawData;
    private long pointerToRawData;
    private long pointerToRelocations;
    private long pointerToLineNumbers;
    private int numberOfRelocations;
    private int numberOfLineNumbers;
    private long characteristics;
    private int headerSize = 0;

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        this.headerSize = offset;
        this.sectionName = new String(ByteReader.getBytes(data, offset, 8));
        this.virtualSize = ByteReader.getUInt32(data, offset += 8);
        this.relativeVirtualAddress = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfRawData = ByteReader.getUInt32(data, offset += 4);
        this.pointerToRawData = ByteReader.getUInt32(data, offset += 4);
        this.pointerToRelocations = ByteReader.getUInt32(data, offset += 4);
        this.pointerToLineNumbers = ByteReader.getUInt32(data, offset += 4);
        this.numberOfRelocations = ByteReader.getUInt16(data, offset += 4);
        this.numberOfLineNumbers = ByteReader.getUInt16(data, offset += 2);
        this.characteristics = ByteReader.getUInt32(data, offset += 2);
        this.headerSize = (offset += 4) - this.headerSize;
        assert (this.headerSize == 40);
        return this.headerSize;
    }

    @Override
    public int getSize() {
        return 40;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public long getVirtualSize() {
        return this.virtualSize;
    }

    public long getRelativeVirtualAddress() {
        return this.relativeVirtualAddress;
    }

    public long getPointerToRawData() {
        return this.pointerToRawData;
    }

    public long getSizeOfRawData() {
        return this.sizeOfRawData;
    }

    public long getPointerToRelocations() {
        return this.pointerToRelocations;
    }

    public long getPointerToLineNumbers() {
        return this.pointerToLineNumbers;
    }

    public int getNumberOfRelocations() {
        return this.numberOfRelocations;
    }

    public int getNumberOfLineNumbers() {
        return this.numberOfLineNumbers;
    }

    public long getCharacteristicsFlags() {
        return this.characteristics;
    }

    @Override
    public int compareTo(PESectionHeader otherHeader) {
        return (int)(this.relativeVirtualAddress - otherHeader.getRelativeVirtualAddress());
    }

    public String toString() {
        return "PE Section Header\n  Section Name: ...............\"" + this.sectionName.replaceAll("\\p{Cntrl}", "_") + "\"" + String.format("\n  Virtual Size: ...............%010d", this.virtualSize) + String.format("\n  Relative Virtual Address: ...0x%08x", this.relativeVirtualAddress) + String.format("\n  Size of Raw Data: ...........%010d", this.sizeOfRawData) + String.format("\n  Pointer to Raw Data: ........0x%08x", this.pointerToRawData) + String.format("\n  Pointer to Relocations: .....0x%08x", this.pointerToRelocations) + String.format("\n  Pointer to Line Numbers: ....0x%08x", this.pointerToLineNumbers) + String.format("\n  Number of Relocations: ......%010d", this.numberOfRelocations) + String.format("\n  Number of Line Numbers: .....%010d", this.numberOfLineNumbers) + String.format("\n  Characteristics: ............0x%08x", this.characteristics);
    }
}

