/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.coffpe;

import at.pollaknet.api.facile.exception.SizeExceededException;
import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ByteReader;

public class PEOptionalHeader
implements IDataHeader {
    public static final int MAGIC_NUMBER_PE32_PLUS = 523;
    public static final int MAGIC_NUMBER_PE32 = 267;
    public static final int SUBSYSTEM_UNKNOWN = 0;
    public static final int SUBSYSTEM_NATIVE = 1;
    public static final int SUBSYSTEM_WINDOWS_GUI = 2;
    public static final int SUBSYSTEM_WINDOWS_CUI = 3;
    public static final int SUBSYSTEM_POSIX_CUI = 7;
    public static final int SUBSYSTEM_WINDOWS_CE_GUI = 9;
    public static final int SUBSYSTEM_EFI_APPLICATION = 10;
    public static final int SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER = 11;
    public static final int SUBSYSTEM_EFI_RUNTIME_DRIVER = 12;
    public static final int SUBSYSTEM_EFI_ROM = 13;
    public static final int SUBSYSTEM_XBOX = 14;
    public static final int DLL_CHARACTERISTICS_FLAGS_DYNAMIC_BASE = 64;
    public static final int DLL_CHARACTERISTICS_FLAGS_FORCE_INTEGRITY = 128;
    public static final int DLL_CHARACTERISTICS_FLAGS_NX_COMPATIBLE = 256;
    public static final int DLL_CHARACTERISTICS_FLAGS_NO_ISOLATION = 512;
    public static final int DLL_CHARACTERISTICS_FLAGS_NO_SEH = 1024;
    public static final int DLL_CHARACTERISTICS_FLAGS_NO_BIND = 2048;
    public static final int DLL_CHARACTERISTICS_FLAGS_WDM_DRIVER = 8192;
    public static final int DLL_CHARACTERISTICS_FLAGS_TERMINAL_SERVER_AWARE = 32768;
    private int magicVersionNumber;
    private int majorLinkerVersion;
    private int minorLinkerVersion;
    private long sizeOfCode;
    private long sizeOfInitializedData;
    private long sizeOfUninitializedData;
    private long addrOfEntryPoint;
    private long baseOfCode;
    private long baseOfData;
    private long imageBase;
    private long sectionAlignment;
    private long fileAlignment;
    private int majorOSVersion;
    private int minorOSVersion;
    private int majorImageVersion;
    private int minorImageVersion;
    private int majorSubsystemVersion;
    private int minorSubsystemVersion;
    private long win32VersionValue;
    private long sizeOfImage;
    private long sizeOfHeaders;
    private long checksum;
    private int subsystem;
    private int DLLCharacteristics;
    private long sizeOfStackReserve;
    private long sizeOfStackCommit;
    private long sizeOfHeapReserve;
    private long sizeOfHeapCommit;
    private long sizeOfStackReserveHigh;
    private long sizeOfStackCommitHigh;
    private long sizeOfHeapReserveHigh;
    private long sizeOfHeapCommitHigh;
    private long loaderFlags;
    private long numberOfDataDirectoryEntries;
    private int headerSize = 0;

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException {
        this.headerSize = offset;
        this.magicVersionNumber = ByteReader.getUInt16(data, offset);
        if (this.magicVersionNumber != 267 && this.magicVersionNumber != 523) {
            throw new UnexpectedHeaderDataException("Magic number check failed: " + this.magicVersionNumber + "(expected " + 267 + " or " + 523 + ")");
        }
        this.majorLinkerVersion = ByteReader.getUInt8(data, offset += 2);
        this.minorLinkerVersion = ByteReader.getUInt8(data, ++offset);
        this.sizeOfCode = ByteReader.getUInt32(data, ++offset);
        this.sizeOfInitializedData = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfUninitializedData = ByteReader.getUInt32(data, offset += 4);
        this.addrOfEntryPoint = ByteReader.getUInt32(data, offset += 4);
        this.baseOfCode = ByteReader.getUInt32(data, offset += 4);
        this.baseOfData = ByteReader.getUInt32(data, offset += 4);
        this.imageBase = ByteReader.getUInt32(data, offset += 4);
        this.sectionAlignment = ByteReader.getUInt32(data, offset += 4);
        this.fileAlignment = ByteReader.getUInt32(data, offset += 4);
        this.majorOSVersion = ByteReader.getUInt16(data, offset += 4);
        this.minorOSVersion = ByteReader.getUInt16(data, offset += 2);
        this.majorImageVersion = ByteReader.getUInt16(data, offset += 2);
        this.minorImageVersion = ByteReader.getUInt16(data, offset += 2);
        this.majorSubsystemVersion = ByteReader.getUInt16(data, offset += 2);
        this.minorSubsystemVersion = ByteReader.getUInt16(data, offset += 2);
        this.win32VersionValue = ByteReader.getUInt32(data, offset += 2);
        this.sizeOfImage = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfHeaders = ByteReader.getUInt32(data, offset += 4);
        this.checksum = ByteReader.getUInt32(data, offset += 4);
        this.subsystem = ByteReader.getUInt16(data, offset += 4);
        this.DLLCharacteristics = ByteReader.getUInt16(data, offset += 2);
        offset += 2;
        if (this.magicVersionNumber == 267) {
            this.sizeOfStackReserve = ByteReader.getUInt32(data, offset);
            this.sizeOfStackCommit = ByteReader.getUInt32(data, offset += 4);
            this.sizeOfHeapReserve = ByteReader.getUInt32(data, offset += 4);
            this.sizeOfHeapCommit = ByteReader.getUInt32(data, offset += 4);
            offset += 4;
        } else {
            this.sizeOfStackReserve = ByteReader.getUInt32(data, offset);
            this.sizeOfStackReserveHigh = ByteReader.getUInt32(data, offset += 4);
            this.sizeOfStackCommit = ByteReader.getUInt32(data, offset += 4);
            this.sizeOfStackCommitHigh = ByteReader.getUInt32(data, offset += 4);
            this.sizeOfStackReserve = ByteReader.getUInt32(data, offset += 4);
            this.sizeOfHeapReserveHigh = ByteReader.getUInt32(data, offset += 4);
            this.sizeOfHeapCommit = ByteReader.getUInt32(data, offset += 4);
            this.sizeOfHeapCommitHigh = ByteReader.getUInt32(data, offset += 4);
            offset += 4;
        }
        this.loaderFlags = ByteReader.getUInt32(data, offset);
        this.numberOfDataDirectoryEntries = ByteReader.getUInt32(data, offset += 4);
        this.headerSize = (offset += 4) - this.headerSize;
        return this.headerSize;
    }

    @Override
    public int getSize() {
        return this.headerSize;
    }

    public long getImageBase() {
        return this.imageBase;
    }

    public long getBaseOfData() {
        return this.baseOfData;
    }

    public long getBaseOfCode() {
        return this.baseOfCode;
    }

    public int getMagicVersionNumber() {
        return this.magicVersionNumber;
    }

    public int getMajorLinkerVersion() {
        return this.majorLinkerVersion;
    }

    public int getMinorLinkerVersion() {
        return this.minorLinkerVersion;
    }

    public long getSizeOfCode() {
        return this.sizeOfCode;
    }

    public long getSizeOfInitializedData() {
        return this.sizeOfInitializedData;
    }

    public long getSizeOfUninitializedData() {
        return this.sizeOfUninitializedData;
    }

    public long getAddrOfEntryPoint() {
        return this.addrOfEntryPoint;
    }

    public long getSectionAlignment() {
        return this.sectionAlignment;
    }

    public long getFileAlignment() {
        return this.fileAlignment;
    }

    public int getMajorOSVersion() {
        return this.majorOSVersion;
    }

    public int getMinorOSVersion() {
        return this.minorOSVersion;
    }

    public int getMajorImageVersion() {
        return this.majorImageVersion;
    }

    public int getMinorImageVersion() {
        return this.minorImageVersion;
    }

    public int getMajorSubsystemVersion() {
        return this.majorSubsystemVersion;
    }

    public int getMinorSubsystemVersion() {
        return this.minorSubsystemVersion;
    }

    public long getWin32VersionValue() {
        return this.win32VersionValue;
    }

    public long getSizeOfImage() {
        return this.sizeOfImage;
    }

    public long getSizeOfHeaders() {
        return this.sizeOfHeaders;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public int getSubsystem() {
        return this.subsystem;
    }

    public int getDLLCharacteristics() {
        return this.DLLCharacteristics;
    }

    public long getSizeOfStackReserve() throws SizeExceededException {
        if (this.magicVersionNumber == 267) {
            return this.sizeOfStackReserve;
        }
        if (this.sizeOfStackReserveHigh > Integer.MAX_VALUE) {
            throw new SizeExceededException("Range of long exceeded.");
        }
        return this.sizeOfStackReserveHigh << 32 | this.sizeOfStackReserve;
    }

    public long getSizeOfStackCommit() throws SizeExceededException {
        if (this.magicVersionNumber == 267) {
            return this.sizeOfStackCommit;
        }
        if (this.sizeOfStackCommitHigh > Integer.MAX_VALUE) {
            throw new SizeExceededException("Range of long exceeded.");
        }
        return this.sizeOfStackCommitHigh << 32 | this.sizeOfStackCommit;
    }

    public long getSizeOfHeapReserve() throws SizeExceededException {
        if (this.magicVersionNumber == 267) {
            return this.sizeOfHeapReserve;
        }
        if (this.sizeOfHeapReserveHigh > Integer.MAX_VALUE) {
            throw new SizeExceededException("Range of long exceeded.");
        }
        return this.sizeOfHeapReserveHigh << 32 | this.sizeOfHeapReserve;
    }

    public long getSizeOfHeapCommit() throws SizeExceededException {
        if (this.magicVersionNumber == 267) {
            return this.sizeOfHeapCommit;
        }
        if (this.sizeOfHeapCommitHigh > Integer.MAX_VALUE) {
            throw new SizeExceededException("Range of long exceeded.");
        }
        return this.sizeOfHeapCommitHigh << 32 | this.sizeOfHeapCommit;
    }

    public long getLoaderFlags() {
        return this.loaderFlags;
    }

    public long getNumberOfDataDirectoryEntries() {
        return this.numberOfDataDirectoryEntries;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("PE Optional Header");
        if (this.magicVersionNumber == 267) {
            buffer.append(" 32 bit");
        } else {
            buffer.append(" 64 bit");
        }
        buffer.append(String.format("\n  Magic Version Number: .............0x%08x", this.magicVersionNumber));
        buffer.append(String.format("\n  Major Linker Version: .............%010d", this.majorLinkerVersion));
        buffer.append(String.format("\n  Minor Linker Version: .............%010d", this.minorLinkerVersion));
        buffer.append(String.format("\n  Size of Code: .....................%010d", this.sizeOfCode));
        buffer.append(String.format("\n  Size of Initialized Data: .........%010d", this.sizeOfInitializedData));
        buffer.append(String.format("\n  Size of Uninitialized Data: .......%010d", this.sizeOfUninitializedData));
        buffer.append(String.format("\n  Address of Entry Point: ...........0x%08x", this.addrOfEntryPoint));
        buffer.append(String.format("\n  Code Base: ........................0x%08x", this.baseOfCode));
        if (this.magicVersionNumber == 267) {
            buffer.append(String.format("\n  Data Base: ........................0x%08x", this.baseOfData));
            buffer.append(String.format("\n  Image Base: .......................0x%08x", this.imageBase));
        } else {
            buffer.append(String.format("\n  Image Base: .......................0x%04x%04x", this.imageBase, this.baseOfData));
        }
        buffer.append(String.format("\n  Section Alignment: ................0x%08x", this.sectionAlignment));
        buffer.append(String.format("\n  File Alignment: ...................0x%08x", this.fileAlignment));
        buffer.append(String.format("\n  Major OS Version: .................%05d", this.majorOSVersion));
        buffer.append(String.format("\n  Minor OS Version: .................%05d", this.minorOSVersion));
        buffer.append(String.format("\n  Major Image Version: ..............%05d", this.majorImageVersion));
        buffer.append(String.format("\n  Minor Image Version: ..............%05d", this.minorImageVersion));
        buffer.append(String.format("\n  Major Subsystem Version: ..........%05d", this.majorSubsystemVersion));
        buffer.append(String.format("\n  Minor Subsystem Version: ..........%05d", this.minorSubsystemVersion));
        buffer.append(String.format("\n  Win32 Version: ....................%05d", this.win32VersionValue));
        buffer.append(String.format("\n  Size of Image: ....................%010d", this.sizeOfImage));
        buffer.append(String.format("\n  Size of Header: ...................%010d", this.sizeOfHeaders));
        buffer.append(String.format("\n  Checksum: .........................0x%08x", this.checksum));
        buffer.append(String.format("\n  Subsystem: ........................0x%04x", this.subsystem));
        buffer.append(String.format("\n  DLL Characteristics: ..............0x%04x", this.DLLCharacteristics));
        if (this.magicVersionNumber == 267) {
            buffer.append(String.format("\n  Size Of Stack Reserve: ............0x%08x", this.sizeOfStackReserve));
            buffer.append(String.format("\n  Size Of Stack Commit: .............0x%08x", this.sizeOfStackCommit));
            buffer.append(String.format("\n  Size Of Heap Reserve: .............0x%08x", this.sizeOfHeapReserve));
            buffer.append(String.format("\n  Size Of Heap Commit: ..............0x%08x", this.sizeOfHeapCommit));
        } else {
            buffer.append(String.format("\n  Size Of Stack Reserve: ............0x%8x%08x", this.sizeOfStackReserveHigh, this.sizeOfStackReserve));
            buffer.append(String.format("\n  Size Of Stack Commit: .............0x%8x%08x", this.sizeOfStackCommitHigh, this.sizeOfStackCommit));
            buffer.append(String.format("\n  Size Of Heap Reserve: .............0x%8x%08x", this.sizeOfHeapReserveHigh, this.sizeOfHeapReserve));
            buffer.append(String.format("\n  Size Of Heap Commit: ..............0x%8x%08x", this.sizeOfHeapCommitHigh, this.sizeOfHeapCommit));
        }
        buffer.append(String.format("\n  Loader Flags: .....................0x%08x", this.loaderFlags));
        buffer.append(String.format("\n  Number of Data Dir. Entries: ......%05d", this.numberOfDataDirectoryEntries));
        return buffer.toString();
    }
}

