/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.coffpe;

import at.pollaknet.api.facile.exception.DotNetContentNotFoundException;
import at.pollaknet.api.facile.exception.UnexpectedHeaderDataException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ByteReader;

public class PEDataDirectories
implements IDataHeader {
    private static final int STATIC_HEADER_SIZE = 128;
    private long exportDirectoryRVA;
    private long exportDirectorySize;
    private long importDirectoryRVA;
    private long importDirectorySize;
    private long resourceDirectoryRVA;
    private long resourceDirectorySize;
    private long exceptionDirectoryRVA;
    private long exceptionDirectorySize;
    private long certificateDirectoryRVA;
    private long certificateDirectorySize;
    private long baseRelocDirectoryRVA;
    private long baseRelocDirectorySize;
    private long debugDirectoryRVA;
    private long debugDirectorySize;
    private long copyrightDirectoryRVA;
    private long copyrightDirectorySize;
    private long pointerDirectoryRVA;
    private long pointerDirectorySize;
    private long threadLocalStorageDirectoryRVA;
    private long threadLocalStorageDirectorySize;
    private long loadConfigDirectoryRVA;
    private long loadConfigDirectorySize;
    private long boundImportDirectoryRVA;
    private long boundImportDirectorySize;
    private long importAddrTabDirectoryRVA;
    private long importAddrTabDirectorySize;
    private long delayLoadDirectoryRVA;
    private long delayLoadDirectorySize;
    private long commonLanguageRuntimeHeaderRVA;
    private long commonLanguageRuntimeHeaderSize;
    private long reservedDirectoryRVA;
    private long reservedDirectorySize;
    private int headerSize = 0;

    @Override
    public int read(byte[] data, int offset) throws UnexpectedHeaderDataException, DotNetContentNotFoundException {
        this.headerSize = offset;
        this.exportDirectoryRVA = ByteReader.getUInt8(data, offset);
        this.exportDirectorySize = ByteReader.getUInt8(data, offset += 4);
        this.importDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.importDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.resourceDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.resourceDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.exceptionDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.exceptionDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.certificateDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.certificateDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.baseRelocDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.baseRelocDirectorySize = ByteReader.getUInt16(data, offset += 4);
        this.debugDirectoryRVA = ByteReader.getUInt8(data, offset += 4);
        this.debugDirectorySize = ByteReader.getUInt8(data, offset += 4);
        this.copyrightDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.copyrightDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.pointerDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.pointerDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.threadLocalStorageDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.threadLocalStorageDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.loadConfigDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.loadConfigDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.boundImportDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.boundImportDirectorySize = ByteReader.getUInt16(data, offset += 4);
        this.importAddrTabDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.importAddrTabDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.delayLoadDirectoryRVA = ByteReader.getUInt32(data, offset += 4);
        this.delayLoadDirectorySize = ByteReader.getUInt32(data, offset += 4);
        this.commonLanguageRuntimeHeaderRVA = ByteReader.getUInt32(data, offset += 4);
        this.commonLanguageRuntimeHeaderSize = ByteReader.getUInt32(data, offset += 4);
        offset += 4;
        if (this.commonLanguageRuntimeHeaderSize == 0L) {
            throw new DotNetContentNotFoundException("No CLR header found in file.");
        }
        this.reservedDirectoryRVA = ByteReader.getUInt32(data, offset);
        this.reservedDirectorySize = ByteReader.getUInt16(data, offset += 4);
        this.headerSize = (offset += 4) - this.headerSize;
        assert (this.headerSize == 128);
        return this.headerSize;
    }

    @Override
    public int getSize() {
        return 128;
    }

    public long getClrHeaderRVA() {
        return this.commonLanguageRuntimeHeaderRVA;
    }

    public long getClrHeaderSize() {
        return this.commonLanguageRuntimeHeaderSize;
    }

    public long getDebugDirectoryRVA() {
        return this.debugDirectoryRVA;
    }

    public long getDebugDirectorySize() {
        return this.debugDirectorySize;
    }

    public long getLoadConfigDirectoryRVA() {
        return this.loadConfigDirectoryRVA;
    }

    public long getLoadConfigDirectorySize() {
        return this.loadConfigDirectorySize;
    }

    public long getExportDirectoryRVA() {
        return this.exportDirectoryRVA;
    }

    public long getExportDirectorySize() {
        return this.exportDirectorySize;
    }

    public long getImportDirectoryRVA() {
        return this.importDirectoryRVA;
    }

    public long getImportDirectorySize() {
        return this.importDirectorySize;
    }

    public long getResourceDirectoryRVA() {
        return this.resourceDirectoryRVA;
    }

    public long getResourceDirectorySize() {
        return this.resourceDirectorySize;
    }

    public long getExceptionDirectoryRVA() {
        return this.exceptionDirectoryRVA;
    }

    public long getExceptionDirectorySize() {
        return this.exceptionDirectorySize;
    }

    public long getCertificateDirectoryRVA() {
        return this.certificateDirectoryRVA;
    }

    public long getCertificateDirectorySize() {
        return this.certificateDirectorySize;
    }

    public long getBaseRelocDirectoryRVA() {
        return this.baseRelocDirectoryRVA;
    }

    public long getBaseRelocDirectorySize() {
        return this.baseRelocDirectorySize;
    }

    public long getCopyrightDirectoryRVA() {
        return this.copyrightDirectoryRVA;
    }

    public long getCopyrightDirectorySize() {
        return this.copyrightDirectorySize;
    }

    public long getPointerDirectoryRVA() {
        return this.pointerDirectoryRVA;
    }

    public long getPointerDirectorySize() {
        return this.pointerDirectorySize;
    }

    public long getThreadLocalStorageDirectoryRVA() {
        return this.threadLocalStorageDirectoryRVA;
    }

    public long getThreadLocalStorageDirectorySize() {
        return this.threadLocalStorageDirectorySize;
    }

    public long getBoundImportDirectoryRVA() {
        return this.boundImportDirectoryRVA;
    }

    public long getBoundImportDirectorySize() {
        return this.boundImportDirectorySize;
    }

    public long getImportAddressTableDirectoryRVA() {
        return this.importAddrTabDirectoryRVA;
    }

    public long getImportAddressTableDirectorySize() {
        return this.importAddrTabDirectorySize;
    }

    public long getDelayLoadDirectoryRVA() {
        return this.delayLoadDirectoryRVA;
    }

    public long getDelayLoadDirectorySize() {
        return this.delayLoadDirectorySize;
    }

    public long getReservedDirectoryRVA() {
        return this.reservedDirectoryRVA;
    }

    public long getReservedDirectorySize() {
        return this.reservedDirectorySize;
    }

    public String toString() {
        return "PE Data Directories:" + String.format("\n  Import Directory RVA: ..............0x%08x", this.importDirectoryRVA) + String.format("\n  Import Directory Size: .............%010d", this.importDirectorySize) + String.format("\n  Export Directory RVA: ..............0x%08x", this.exportDirectoryRVA) + String.format("\n  Export Directory Size: .............%010d", this.exportDirectorySize) + String.format("\n  Resource Directory RVA: ............0x%08x", this.resourceDirectoryRVA) + String.format("\n  Resource Directory Size: ...........%010d", this.resourceDirectorySize) + String.format("\n  Exception Directory RVA: ...........0x%08x", this.exceptionDirectoryRVA) + String.format("\n  Exception Directory Size: ..........%010d", this.exceptionDirectorySize) + "\n  ------------------------------------" + String.format("\n  Certificate Directory RVA: .........0x%08x", this.certificateDirectoryRVA) + String.format("\n  Certificate Directory Size: ........%010d", this.certificateDirectorySize) + String.format("\n  Base Relocation Directory RVA: .....0x%08x", this.baseRelocDirectoryRVA) + String.format("\n  Base Relocation Directory Size: ....%010d", this.baseRelocDirectorySize) + String.format("\n  Debug Directory RVA: ...............0x%08x", this.debugDirectoryRVA) + String.format("\n  Debug Directory Size: ..............%010d", this.debugDirectorySize) + String.format("\n  Copyright Directory RVA: ...........0x%08x", this.copyrightDirectoryRVA) + String.format("\n  Copyright Directory Size: ..........%010d", this.copyrightDirectorySize) + "\n  ------------------------------------" + String.format("\n  Global Pointer Directory RVA: ......0x%08x", this.pointerDirectoryRVA) + String.format("\n  Global Pointer Directory Size: .....%010d", this.pointerDirectorySize) + String.format("\n  Thread Local Storage Dir. RVA: .....0x%08x", this.threadLocalStorageDirectoryRVA) + String.format("\n  Thread Local Storage Dir. Size: ....%010d", this.threadLocalStorageDirectorySize) + String.format("\n  Load Config Directory RVA: .........0x%08x", this.loadConfigDirectoryRVA) + String.format("\n  Load Config Directory Size: ........%010d", this.loadConfigDirectorySize) + String.format("\n  Bound Import Directory RVA: ........0x%08x", this.boundImportDirectoryRVA) + String.format("\n  Bound Import Directory Size: .......%010d", this.boundImportDirectorySize) + "\n  ------------------------------------" + String.format("\n  Import Address Table RVA: ..........0x%08x", this.importAddrTabDirectoryRVA) + String.format("\n  Import Address Table Size: .........%010d", this.importAddrTabDirectorySize) + String.format("\n  Delay Load (Import) Dir. RVA: ......0x%08x", this.delayLoadDirectoryRVA) + String.format("\n  Delay Load (Import) Dir. Size: .....%010d", this.delayLoadDirectorySize) + String.format("\n  Common Language Runtime RVA: .......0x%08x", this.commonLanguageRuntimeHeaderRVA) + String.format("\n  Common Language Runtime Size: ......%010d", this.commonLanguageRuntimeHeaderSize) + String.format("\n  Reserved Directory RVA: ............0x%08x", this.reservedDirectoryRVA) + String.format("\n  Reserved Directory Size: ...........%010d", this.reservedDirectorySize);
    }
}

