/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.coffpe;

import at.pollaknet.api.facile.exception.CoffPeDataNotFoundException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ByteReader;

public class DOSHeader
implements IDataHeader {
    public static final int MAGIC_NUMBER = 23117;
    public static final int STATIC_HEADER_SIZE = 64;
    private int magicNumber;
    private int bytesOnLastPage;
    private int pagesInFile;
    private int relocations;
    private int sizeOfHeader;
    private int minExtraParagraphs;
    private int maxExtraParagraphs;
    private int initialRelativeSS;
    private int initialSP;
    private int checksum;
    private int initialIP;
    private int initialRelativeCS;
    private int fileAddrOfRelocTable;
    private int overlayNumber;
    private int OEMIdentifier;
    private int OEMInfo;
    private byte[] reservedSpace1 = new byte[8];
    private byte[] reservedSpace2 = new byte[20];
    private long fileAddrOfCOFFHeader;
    private int headerSize;

    @Override
    public int read(byte[] data, int offset) throws CoffPeDataNotFoundException {
        if (data == null || data.length < 64) {
            throw new CoffPeDataNotFoundException("The specified file is too small.");
        }
        this.headerSize = offset;
        this.magicNumber = ByteReader.getUInt16(data, offset);
        if (this.magicNumber != 23117) {
            throw new CoffPeDataNotFoundException("Magic number check of PE header failed.");
        }
        this.bytesOnLastPage = ByteReader.getUInt16(data, offset += 2);
        this.pagesInFile = ByteReader.getUInt16(data, offset += 2);
        this.relocations = ByteReader.getUInt16(data, offset += 2);
        this.sizeOfHeader = ByteReader.getUInt16(data, offset += 2);
        this.minExtraParagraphs = ByteReader.getUInt16(data, offset += 2);
        this.maxExtraParagraphs = ByteReader.getUInt16(data, offset += 2);
        this.initialRelativeSS = ByteReader.getUInt16(data, offset += 2);
        this.initialSP = ByteReader.getUInt16(data, offset += 2);
        this.checksum = ByteReader.getUInt16(data, offset += 2);
        this.initialIP = ByteReader.getUInt16(data, offset += 2);
        this.initialRelativeCS = ByteReader.getUInt16(data, offset += 2);
        this.fileAddrOfRelocTable = ByteReader.getUInt16(data, offset += 2);
        this.overlayNumber = ByteReader.getUInt16(data, offset += 2);
        this.reservedSpace1 = ByteReader.getBytes(data, offset += 2, 8);
        this.OEMIdentifier = ByteReader.getUInt16(data, offset += 8);
        this.OEMInfo = ByteReader.getUInt16(data, offset += 2);
        this.reservedSpace2 = ByteReader.getBytes(data, offset += 2, 20);
        this.fileAddrOfCOFFHeader = ByteReader.getUInt32(data, offset += 20);
        this.headerSize = (offset += 4) - this.headerSize;
        assert (this.headerSize == 64);
        return this.headerSize;
    }

    @Override
    public int getSize() {
        return 64;
    }

    public long getFileAddrOfCOFFHeader() {
        return this.fileAddrOfCOFFHeader;
    }

    public int getNumberOfRelocations() {
        return this.relocations;
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public int getBytesOnLastPage() {
        return this.bytesOnLastPage;
    }

    public int getPagesInFile() {
        return this.pagesInFile;
    }

    public int getSizeOfHeader() {
        return this.sizeOfHeader;
    }

    public int getMinExtraParagraphs() {
        return this.minExtraParagraphs;
    }

    public int getMaxExtraParagraphs() {
        return this.maxExtraParagraphs;
    }

    public int getInitialRelativeSS() {
        return this.initialRelativeSS;
    }

    public int getInitialSP() {
        return this.initialSP;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public int getInitialIP() {
        return this.initialIP;
    }

    public int getInitialRelativeCS() {
        return this.initialRelativeCS;
    }

    public int getFileAddrOfRelocTable() {
        return this.fileAddrOfRelocTable;
    }

    public int getOverlayNumber() {
        return this.overlayNumber;
    }

    public int getOEMIdentifier() {
        return this.OEMIdentifier;
    }

    public int getOEMInfo() {
        return this.OEMInfo;
    }

    public byte[] getReservedSpace1() {
        return this.reservedSpace1;
    }

    public byte[] getReservedSpace2() {
        return this.reservedSpace2;
    }

    public String toString() {
        return "DOS Header" + String.format("\n  Magic Number: ...............................0x%08x", this.magicNumber) + String.format("\n  Bytes on Last Page: .........................%010d", this.bytesOnLastPage) + String.format("\n  Pages in File: ..............................%010d", this.pagesInFile) + String.format("\n  Relocations: ................................%010d", this.relocations) + String.format("\n  Size of Header: .............................%010d", this.sizeOfHeader) + String.format("\n  Min Extra Paragraphs: .......................0x%08x", this.minExtraParagraphs) + String.format("\n  Max Extra Paragraphs: .......................0x%08x", this.maxExtraParagraphs) + String.format("\n  Initial Relative Stack Segment (SS): ........0x%08x", this.initialRelativeSS) + String.format("\n  Initial Stack Pointer (SP): .................0x%08x", this.initialSP) + String.format("\n  Checksum (%s): ...........................0x%08x", this.fileAddrOfCOFFHeader == 0L ? "CRC16" : "CRC32", this.checksum) + String.format("\n  Initial Instruction Pointer (IP): ...........0x%08x", this.initialIP) + String.format("\n  Initial Relative Code Segment (CS): .........0x%08x", this.initialRelativeCS) + String.format("\n  File Address of Reloc Table: ................0x%08x", this.fileAddrOfRelocTable) + String.format("\n  Overlay Number: .............................%010d", this.overlayNumber) + String.format("\n  Reserved Space 1: ...........................%02d Bytes", this.reservedSpace1 == null ? 0 : this.reservedSpace1.length) + String.format("\n  OEM Identifier: .............................0x%08x", this.OEMIdentifier) + String.format("\n  OEM Info: ...................................0x%08x", this.OEMInfo) + String.format("\n  Reserved Space 2: ...........................%02d Bytes", this.reservedSpace2 == null ? 0 : this.reservedSpace2.length) + String.format("\n  File Address of COFF Header: ................0x%08x", this.fileAddrOfCOFFHeader);
    }
}

