/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.coffpe;

import at.pollaknet.api.facile.exception.CoffPeDataNotFoundException;
import at.pollaknet.api.facile.header.IDataHeader;
import at.pollaknet.api.facile.util.ByteReader;

public class COFFPEHeader
implements IDataHeader {
    public static final int PE_SIGNATURE = 17744;
    public static final int STATIC_HEADER_SIZE = 24;
    private long signature;
    private int targetMachineType;
    private int numberOfSections;
    private long timeDateStamp;
    private long pointerToSymbolTable;
    private long numberOfSymbols;
    private int sizeOfOptionalHeader;
    private int characteristics;
    private int headerSize;
    public static final int TARGET_MACHINE_UNKNOWN = 0;
    public static final int TARGET_MACHINE_AM33 = 467;
    public static final int TARGET_MACHINE_AMD64 = 34404;
    public static final int TARGET_MACHINE_ARM = 448;
    public static final int TARGET_MACHINE_EBC = 3772;
    public static final int TARGET_MACHINE_I386 = 332;
    public static final int TARGET_MACHINE_IA64 = 512;
    public static final int TARGET_MACHINE_M32R = 36929;
    public static final int TARGET_MACHINE_MIPS16 = 614;
    public static final int TARGET_MACHINE_MIPSFPU = 870;
    public static final int TARGET_MACHINE_MIPSFPU16 = 1126;
    public static final int TARGET_MACHINE_POWERPC = 496;
    public static final int TARGET_MACHINE_POWERPCFP = 497;
    public static final int TARGET_MACHINE_R4000 = 358;
    public static final int TARGET_MACHINE_SH3 = 418;
    public static final int TARGET_MACHINE_SH3DSP = 419;
    public static final int TARGET_MACHINE_SH4 = 422;
    public static final int TARGET_MACHINE_SH5 = 424;
    public static final int TARGET_MACHINE_THUMB = 450;
    public static final int TARGET_MACHINE_WCEMIPSV2 = 361;
    public static final int CHARACTERISTICS_FLAG_RELOCS_STRIPPED = 1;
    public static final int CHARACTERISTICS_FLAG_EXECUTABLE_IMAGE = 2;
    public static final int CHARACTERISTICS_FLAG_LINE_NUMS_STRIPPED = 4;
    public static final int CHARACTERISTICS_FLAG_LOCAL_SYMS_STRIPPED = 8;
    public static final int CHARACTERISTICS_FLAG_AGGRESSIVE_WS_TRIM = 16;
    public static final int CHARACTERISTICS_FLAG_LARGE_ADDRESS_AWARE = 32;
    public static final int CHARACTERISTICS_FLAG_RESERVED = 64;
    public static final int CHARACTERISTICS_FLAG_BYTES_REVERSED_LO = 128;
    public static final int CHARACTERISTICS_FLAG_32BIT_MACHINE = 256;
    public static final int CHARACTERISTICS_FLAG_DEBUG_STRIPPED = 512;
    public static final int CHARACTERISTICS_FLAG_REMOVABLE_RUN_FROM_SWAP = 1024;
    public static final int CHARACTERISTICS_FLAG_NET_RUN_FROM_SWAP = 2048;
    public static final int CHARACTERISTICS_FLAG_SYSTEM = 4096;
    public static final int CHARACTERISTICS_FLAG_DLL = 8192;
    public static final int CHARACTERISTICS_FLAG_UP_SYSTEM_ONLY = 16384;
    public static final int CHARACTERISTICS_FLAG_BYTES_REVERSED_HI = 32768;

    @Override
    public int read(byte[] data, int offset) throws CoffPeDataNotFoundException {
        this.headerSize = offset;
        this.signature = ByteReader.getUInt32(data, offset);
        if (this.signature != 17744L) {
            throw new CoffPeDataNotFoundException("Invalid \"PE\" signature.");
        }
        this.targetMachineType = ByteReader.getUInt16(data, offset += 4);
        this.numberOfSections = ByteReader.getUInt16(data, offset += 2);
        this.timeDateStamp = ByteReader.getUInt32(data, offset += 2);
        this.pointerToSymbolTable = ByteReader.getUInt32(data, offset += 4);
        this.numberOfSymbols = ByteReader.getUInt32(data, offset += 4);
        this.sizeOfOptionalHeader = ByteReader.getUInt16(data, offset += 4);
        this.characteristics = ByteReader.getUInt16(data, offset += 2);
        this.headerSize = (offset += 2) - this.headerSize;
        assert (this.headerSize == 24);
        return this.headerSize;
    }

    @Override
    public int getSize() {
        return 24;
    }

    public int getNumberOfSections() {
        return this.numberOfSections;
    }

    public boolean isADll() {
        return ByteReader.testFlags(8192, this.characteristics);
    }

    public long getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public int getSizeOfOptionalHeader() {
        return this.sizeOfOptionalHeader;
    }

    public long getSignature() {
        return this.signature;
    }

    public int getTargetMachineType() {
        return this.targetMachineType;
    }

    public long getPointerToSymbolTable() {
        return this.pointerToSymbolTable;
    }

    public long getNumberOfSymbols() {
        return this.numberOfSymbols;
    }

    public int getCharacteristicsFlags() {
        return this.characteristics;
    }

    public String toString() {
        return "COFF/PE Header" + String.format("\n  Signature: ..................0x%08x", this.signature) + String.format("\n  Target Machine Type: ........%010d", this.targetMachineType) + String.format("\n  Number of File Sections: ....%010d", this.numberOfSections) + String.format("\n  Time Date Stamp: ............0x%08x", this.timeDateStamp) + String.format("\n  Pointer to Symbol Table: ....0x%08x", this.pointerToSymbolTable) + String.format("\n  Number of Symbols: ..........%010d", this.numberOfSymbols) + String.format("\n  Size of Optional Header: ....%010d", this.sizeOfOptionalHeader) + String.format("\n  Characteristics: ............0x%08x", this.characteristics);
    }
}

