/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.util;

import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexDecoder {
    public static final int UNUSED_TABLE_INDEX = -1;
    private static final int MAX_TWO_BYTE_TABLE_SIZE = 65535;
    private static final byte SMALL_TABLE_BYTE_SIZE = 2;
    private static final byte LARGE_TABLE_BYTE_SIZE = 4;
    public static final int TYPE_DEF_OR_REF_BIT_SIZE = 2;
    public static final int[] TYPE_DEF_OR_REF_TABLE_INDICES = new int[]{2, 1, 27};
    public static final int HAS_CONSTANT_BIT_SIZE = 2;
    public static final int[] HAS_CONSTANT_TABLE_INDICES = new int[]{4, 8, 23};
    public static final int HAS_CUSTOM_ATTRIBUTE_BIT_SIZE = 5;
    public static final int[] HAS_CUSTOM_ATTRIBUTE_TABLE_INDICES = new int[]{6, 4, 1, 2, 8, 9, 10, 0, 14, 23, 20, 17, 26, 27, 32, 35, 38, 39, 40};
    public static final int HAS_FIELD_MARSHALL_BIT_SIZE = 1;
    public static final int[] HAS_FIELD_MARSHALL_TABLE_INDICES = new int[]{4, 8};
    public static final int HAS_DECL_SECURITY_BIT_SIZE = 2;
    public static final int[] HAS_DECL_SECURITY_TABLE_INDICES = new int[]{2, 6, 32};
    public static final int MEMBER_REF_PARENT_BIT_SIZE = 3;
    public static final int[] MEMBER_REF_PARENT_TABLE_INDICES = new int[]{2, 1, 26, 6, 27};
    public static final int HAS_SEMANTICS_BIT_SIZE = 1;
    public static final int[] HAS_SEMANTICS_TABLE_INDICES = new int[]{20, 23};
    public static final int METHOD_DEF_OR_REF_BIT_SIZE = 1;
    public static final int[] METHOD_DEF_OR_REF_TABLE_INDICES = new int[]{6, 10};
    public static final int MEMBER_FORWARDED_BIT_SIZE = 1;
    public static final int[] MEMBER_FORWARDED_TABLE_INDICES = new int[]{4, 6};
    public static final int IMPLEMENTATION_BIT_SIZE = 2;
    public static final int[] IMPLEMENTATION_TABLE_INDICES = new int[]{38, 35, 39};
    public static final int CUSTOM_ATTRIBUTE_TYPE_BIT_SIZE = 3;
    public static final int[] CUSTOM_ATTRIBUTE_TYPE_TABLE_INDICES = new int[]{-1, -1, 6, 10, -1};
    public static final int RESOLUTION_SCOPE_BIT_SIZE = 2;
    public static final int[] RESOLUTION_SCOPE_TABLE_INDICES = new int[]{0, 26, 35, 1};
    public static final int TYPE_OR_METHOD_DEF_BIT_SIZE = 1;
    public static final int[] TYPE_OR_METHOD_DEF_TABLE_INDICES = new int[]{2, 6};

    public static int getBitSize(CodedIndex index) {
        switch (index) {
            case TypeDefOrRef: {
                return 2;
            }
            case HasConstant: {
                return 2;
            }
            case HasCustomAttribute: {
                return 5;
            }
            case HasFieldMarshall: {
                return 1;
            }
            case HasDeclSecurity: {
                return 2;
            }
            case MemberRefParent: {
                return 3;
            }
            case HasSemantics: {
                return 1;
            }
            case MethodDefOrRef: {
                return 1;
            }
            case MemberForwarded: {
                return 1;
            }
            case Implementation: {
                return 2;
            }
            case CustomAttributeType: {
                return 3;
            }
            case ResolutionScope: {
                return 2;
            }
            case TypeOrMethodDef: {
                return 1;
            }
        }
        Logger.getLogger("at.pollaknet.api.facile").logp(Level.WARNING, "CodedIndex", "getBitSize", "Bit size of unknown CodedIndex requested. Returning 0 as bit requirement.");
        return 0;
    }

    public static int[] getTableIndices(CodedIndex index) {
        switch (index) {
            case TypeDefOrRef: {
                return TYPE_DEF_OR_REF_TABLE_INDICES;
            }
            case HasConstant: {
                return HAS_CONSTANT_TABLE_INDICES;
            }
            case HasCustomAttribute: {
                return HAS_CUSTOM_ATTRIBUTE_TABLE_INDICES;
            }
            case HasFieldMarshall: {
                return HAS_FIELD_MARSHALL_TABLE_INDICES;
            }
            case HasDeclSecurity: {
                return HAS_DECL_SECURITY_TABLE_INDICES;
            }
            case MemberRefParent: {
                return MEMBER_REF_PARENT_TABLE_INDICES;
            }
            case HasSemantics: {
                return HAS_SEMANTICS_TABLE_INDICES;
            }
            case MethodDefOrRef: {
                return METHOD_DEF_OR_REF_TABLE_INDICES;
            }
            case MemberForwarded: {
                return MEMBER_FORWARDED_TABLE_INDICES;
            }
            case Implementation: {
                return IMPLEMENTATION_TABLE_INDICES;
            }
            case CustomAttributeType: {
                return CUSTOM_ATTRIBUTE_TYPE_TABLE_INDICES;
            }
            case ResolutionScope: {
                return RESOLUTION_SCOPE_TABLE_INDICES;
            }
            case TypeOrMethodDef: {
                return TYPE_OR_METHOD_DEF_TABLE_INDICES;
            }
        }
        Logger.getLogger("at.pollaknet.api.facile").logp(Level.WARNING, "CodedIndex", "getTableIndices", "Table indices of unknown CodedIndex requested. Returning emtpy array.");
        return new int[0];
    }

    public static byte getByteSizeOfTargetRow(int[] numberOfRows, CodedIndex index) {
        int shiftBits = IndexDecoder.getBitSize(index);
        assert (shiftBits <= 6);
        int maxTableSize = 65535 >> shiftBits;
        for (int i : IndexDecoder.getTableIndices(index)) {
            if (i <= -1 || numberOfRows[i] <= maxTableSize) continue;
            return 4;
        }
        return 2;
    }

    public static byte getByteSizeOfTargetRow(int[] numberOfRows, int tableIndex) {
        return numberOfRows[tableIndex] > 65535 ? (byte)4 : 2;
    }

    public static int decodeIndexContent(CodedIndex codedIndex, long index) {
        int bitSize = IndexDecoder.getBitSize(codedIndex);
        long value = index >> bitSize;
        assert (value <= Integer.MAX_VALUE);
        return (int)(value - 1L);
    }

    public static int decodeIndex(CodedIndex codedIndex, long index) {
        int bitSize = IndexDecoder.getBitSize(codedIndex);
        int inverseBitMask = -1 << bitSize;
        return (int)index & ~inverseBitMask;
    }

    public static int decodeHasConstant(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasConstant, index)) {
            case 0: {
                return 4;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 23;
            }
        }
        assert (false);
        return -1;
    }

    public static int decodeHasCustomAttribute(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasCustomAttribute, index)) {
            case 0: {
                return 6;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 0;
            }
            case 8: {
                return 14;
            }
            case 9: {
                return 23;
            }
            case 10: {
                return 20;
            }
            case 11: {
                return 17;
            }
            case 12: {
                return 26;
            }
            case 13: {
                return 27;
            }
            case 14: {
                return 32;
            }
            case 15: {
                return 35;
            }
            case 16: {
                return 38;
            }
            case 17: {
                return 39;
            }
            case 18: {
                return 40;
            }
        }
        assert (false);
        return -1;
    }

    public static int decodeHasFieldMarshall(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasFieldMarshall, index)) {
            case 0: {
                return 4;
            }
            case 1: {
                return 8;
            }
        }
        assert (false);
        return -1;
    }

    public static int decodeHasSemantics(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasSemantics, index)) {
            case 0: {
                return 20;
            }
            case 1: {
                return 23;
            }
        }
        assert (false);
        return -1;
    }

    public static int decodeCustomAttributeType(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasSemantics, index)) {
            case 2: {
                return 6;
            }
            case 3: {
                return 10;
            }
        }
        return -1;
    }

    public static int decodeHasDeclSecurity(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasSemantics, index)) {
            case 0: {
                return 2;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 32;
            }
        }
        assert (false);
        return -1;
    }

    public static int decodeTypeOrMethodDef(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasSemantics, index)) {
            case 0: {
                return 2;
            }
            case 1: {
                return 6;
            }
        }
        assert (false);
        return -1;
    }

    public static int decodeMemberForwarded(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasSemantics, index)) {
            case 0: {
                return 4;
            }
            case 1: {
                return 6;
            }
        }
        assert (false);
        return -1;
    }

    public static int decodeMemberRefParent(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasSemantics, index)) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 26;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 27;
            }
        }
        assert (false);
        return -1;
    }

    public static int decodeMethodDefOrRef(long index) {
        switch (IndexDecoder.decodeIndex(CodedIndex.HasSemantics, index)) {
            case 0: {
                return 6;
            }
            case 1: {
                return 10;
            }
        }
        assert (false);
        return -1;
    }
}

