/*
 * Decompiled with CFR 0.152.
 */
package at.pollaknet.api.facile.header.cli.stream.metatable;

import at.pollaknet.api.facile.header.cli.stream.BlobStream;
import at.pollaknet.api.facile.header.cli.stream.GuidStream;
import at.pollaknet.api.facile.header.cli.stream.MetadataStream;
import at.pollaknet.api.facile.header.cli.stream.StringsStream;
import at.pollaknet.api.facile.header.cli.stream.UserStringStream;
import at.pollaknet.api.facile.header.cli.stream.metatable.AbstractTable;
import at.pollaknet.api.facile.header.cli.util.CodedIndex;
import at.pollaknet.api.facile.header.cli.util.IndexDecoder;
import at.pollaknet.api.facile.metamodel.MetadataModel;
import at.pollaknet.api.facile.metamodel.RenderableCilElement;
import at.pollaknet.api.facile.metamodel.entries.TypeRefEntry;
import at.pollaknet.api.facile.metamodel.util.EntryDecoder;

public class TypeRefTable
extends AbstractTable {
    public static final int TABLE_INDEX = 1;
    public static final int MIN_ROW_SIZE = 6;
    private long[] resolutionScopeCodedIndex;
    private int[] typeNameStringIndex;
    private int[] typeNamespaceStringIndex;
    private byte sizeOfResScopeIndex;

    @Override
    protected void prepareTable(int[] numberOfRows) {
        this.resolutionScopeCodedIndex = new long[this.rows];
        this.typeNameStringIndex = new int[this.rows];
        this.typeNamespaceStringIndex = new int[this.rows];
        this.sizeOfResScopeIndex = IndexDecoder.getByteSizeOfTargetRow(numberOfRows, CodedIndex.ResolutionScope);
    }

    @Override
    protected int readRow(byte[] data, int offset, int row) {
        int rowSize = offset;
        offset += this.readIndex(data, offset, this.resolutionScopeCodedIndex, row, this.sizeOfResScopeIndex);
        offset += this.readStringIndex(data, offset, this.typeNameStringIndex, row);
        offset += this.readStringIndex(data, offset, this.typeNamespaceStringIndex, row);
        rowSize = offset - rowSize;
        assert (rowSize >= 6);
        return rowSize;
    }

    @Override
    public String createTableRepresentation() {
        StringBuffer buffer = new StringBuffer(" TypeRef Table (1):");
        for (int i = 0; i < this.rows; ++i) {
            buffer.append("\n  ResolutionScope CodedIndex: ");
            buffer.append(this.resolutionScopeCodedIndex[i]);
            buffer.append(";\tTypeName StringIndex: ");
            buffer.append(this.typeNameStringIndex[i]);
            buffer.append(";\tTypeNameSpace StringIndex: ");
            buffer.append(this.typeNamespaceStringIndex[i]);
            buffer.append(";");
        }
        return buffer.toString();
    }

    @Override
    public int getRID() {
        return 1;
    }

    @Override
    protected void fillRow(MetadataModel model, MetadataStream m, StringsStream s, UserStringStream u, GuidStream g, BlobStream b, RenderableCilElement[] entry, int index) {
        TypeRefEntry e = (TypeRefEntry)entry[index];
        e.setResolutionScope(EntryDecoder.getResolutionScopeEntry(model, this.resolutionScopeCodedIndex[index]));
        e.setName(s.getString(this.typeNameStringIndex[index]));
        e.setNamespace(s.getString(this.typeNamespaceStringIndex[index]));
    }
}

